/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Delete alert attachment for the given identifier")
public class DeleteAlertAttachmentRequest {
    @JsonProperty(value="identifier")
    private String identifier = null;
    @JsonProperty(value="alertIdentifierType")
    private AlertIdentifierTypeEnum alertIdentifierType = AlertIdentifierTypeEnum.ID;
    @JsonProperty(value="attachmentId")
    private Long attachmentId = null;
    @JsonProperty(value="user")
    private String user = null;

    public DeleteAlertAttachmentRequest identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Identifier of alert which could be alert id, tiny id or alert alias")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public DeleteAlertAttachmentRequest alertIdentifierType(AlertIdentifierTypeEnum alertIdentifierType) {
        this.alertIdentifierType = alertIdentifierType;
        return this;
    }

    @ApiModelProperty(value="Type of the identifier that is provided as an in-line parameter. Possible values are 'id', 'alias' or 'tiny'")
    public AlertIdentifierTypeEnum getAlertIdentifierType() {
        return this.alertIdentifierType;
    }

    public void setAlertIdentifierType(AlertIdentifierTypeEnum alertIdentifierType) {
        this.alertIdentifierType = alertIdentifierType;
    }

    public DeleteAlertAttachmentRequest attachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Identifier of alert attachment")
    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public DeleteAlertAttachmentRequest user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="Display name of the request owner")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteAlertAttachmentRequest deleteAlertAttachmentRequest = (DeleteAlertAttachmentRequest)o;
        return ObjectUtils.equals((Object)this.identifier, (Object)deleteAlertAttachmentRequest.identifier) && ObjectUtils.equals((Object)((Object)this.alertIdentifierType), (Object)((Object)deleteAlertAttachmentRequest.alertIdentifierType)) && ObjectUtils.equals((Object)this.attachmentId, (Object)deleteAlertAttachmentRequest.attachmentId) && ObjectUtils.equals((Object)this.user, (Object)deleteAlertAttachmentRequest.user);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.identifier, this.alertIdentifierType, this.attachmentId, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteAlertAttachmentRequest {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    alertIdentifierType: ").append(this.toIndentedString((Object)this.alertIdentifierType)).append("\n");
        sb.append("    attachmentId: ").append(this.toIndentedString(this.attachmentId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AlertIdentifierTypeEnum {
        ID("id"),
        ALIAS("alias"),
        TINY("tiny");

        private String value;

        private AlertIdentifierTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlertIdentifierTypeEnum fromValue(String text) {
            for (AlertIdentifierTypeEnum b : AlertIdentifierTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

