import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.refrig.PcpHeaterTest
import org.lsst.ccs.subsystem.refrig.PcpPowerDevice
import org.lsst.ccs.subsystem.refrig.PcpPowerControl
import org.lsst.ccs.subsystem.refrig.PcpPlutoDevice
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["pcpheater-test"]

builder.main (PcpHeaterTest, powerChans: [0, 2, 1] /* -Y, +Y, center*/) {

    Maq20 (Maq20Device, modules: ["VS", "VO"]) {
        
        HtrPower (PcpPowerDevice)
        
        MinusYHtr (PcpPowerControl, ident: 0, inVoltage: "0:0:V5:150", outVoltage: "1:0:VP5:150",
                   inCurrent: "0:1:V5:7", outCurrent: "1:1:VP5:7", inEnabled: "0:6:V40:20", maxCurrent: 3.0)

        CenterHtr (PcpPowerControl, ident: 1, inVoltage: "0:2:V10:60", outVoltage: "1:2:VP10:60",
                   inCurrent: "0:3:V10:20", outCurrent: "1:3:VP10:20", inEnabled: "0:7:V40:8", maxCurrent: 12.0)

        PlusYHtr (PcpPowerControl, ident: 2, inVoltage: "0:4:V5:150", outVoltage: "1:4:VP5:150",
                  inCurrent: "0:5:V5:8", outCurrent: "1:5:VP5:8", inEnabled: "0:8:V40:20", maxCurrent: 3.0)
    }

    Pluto (PcpPlutoDevice)

    "Heaters/MinusYHtr_V" (Channel, description: "-Y Heater Voltage", units: "Volts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 0, type: "VOLTAGE")

    "Heaters/MinusYHtr_I" (Channel, description: "-Y Heater Current", units: "Amps", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 0, type: "CURRENT")

    "Heaters/MinusYHtr_P" (Channel, description: "-Y Heater Power", units: "Watts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 0, type: "POWER")

    "Heaters/CenterHtr_V" (Channel, description: "Center Heater Voltage", units: "Volts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 1, type: "VOLTAGE")

    "Heaters/CenterHtr_I" (Channel, description: "Center Heater Current", units: "Amps", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 1, type: "CURRENT")

    "Heaters/CenterHtr_P" (Channel, description: "Center Heater Power", units: "Watts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 1, type: "POWER")

    "Heaters/PlusYHtr_V" (Channel, description: "+Y Heater Voltage", units: "Volts", format: ".1f",
                          devcName: "Maq20/HtrPower", hwChan: 2, type: "VOLTAGE")

    "Heaters/PlusYHtr_I" (Channel, description: "+Y Heater Current", units: "Amps", format: ".1f",
                          devcName: "Maq20/HtrPower", hwChan: 2, type: "CURRENT")

    "Heaters/PlusYHtr_P" (Channel, description: "+Y Heater Power", units: "Watts", format: ".1f",
                          devcName: "Maq20/HtrPower", hwChan: 2, type: "POWER")

}
