/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.pathfinder.constants.CmprSetState;
import org.lsst.ccs.subsystem.pathfinder.constants.HexCmprState;
import org.lsst.ccs.subsystem.pathfinder.constants.ValvePosnState;
import org.lsst.ccs.subsystem.pathfinder.constants.ValveSetState;

public class HexValveState
implements Serializable {
    public static final String KEY = "HexValveState";
    private int tickMillis;
    private final HexCmprState[] hexState = new HexCmprState[2];
    private final CmprSetState[] cmprState = new CmprSetState[6];
    private final ValveSetState[] setState = new ValveSetState[18];
    private final ValvePosnState[] posnState = new ValvePosnState[18];
    private static final long serialVersionUID = -2045605058683173781L;

    public HexValveState() {
        Arrays.fill((Object[])this.hexState, (Object)HexCmprState.OFFLINE);
        Arrays.fill((Object[])this.cmprState, (Object)CmprSetState.OFFLINE);
        Arrays.fill((Object[])this.setState, (Object)ValveSetState.OFFLINE);
        Arrays.fill((Object[])this.posnState, (Object)ValvePosnState.OFFLINE);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setHexState(int hex, HexCmprState state) {
        this.hexState[hex] = state;
    }

    public HexCmprState getHexState(int hex) {
        return this.hexState[hex];
    }

    public void setCmprState(int cmpr, CmprSetState state) {
        this.cmprState[cmpr] = state;
    }

    public CmprSetState getCmprState(int cmpr) {
        return this.cmprState[cmpr];
    }

    public void setSetState(int valve, ValveSetState state) {
        this.setState[valve] = state;
    }

    public ValveSetState getSetState(int valve) {
        return this.setState[valve];
    }

    public void setPosnState(int valve, ValvePosnState state) {
        this.posnState[valve] = state;
    }

    public ValvePosnState getPosnState(int valve) {
        return this.posnState[valve];
    }

    public String toString() {
        return super.toString();
    }
}

