/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class PowerDevice
extends Device
implements HasLifecycle {
    protected static final int NETWORK_CONN_INVALID = 1;
    protected static final int MON_TYPE_POWER = 0;
    protected static final int MON_TYPE_VOLTAGE = 1;
    protected static final int MON_TYPE_CURRENT = 2;
    private static final double MIN_VOLTAGE = 4.0;
    private static final double MAX_CURRENT = 3.0;
    private static final double TIMEOUT = 2.0;
    private static final String REFRIG = "Refrig";
    private static final String CONN_TYPE = "connType";
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    protected static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @ConfigurationParameter(name="connType", category="Refrig", isFinal=true)
    protected volatile DriverConstants.ConnType connType;
    @ConfigurationParameter(name="devcId", category="Refrig", isFinal=true)
    protected volatile String devcId;
    @ConfigurationParameter(name="devcParm", category="Refrig", isFinal=true)
    protected volatile int devcParm = 0;
    protected double[] maxCurrent;
    protected double softMaxCurrent = 0.0;
    protected double minVoltage = 4.0;
    protected int settlingTime = 100;
    private static final Logger LOG;
    private final String devcName;
    protected PowerSupplyDriver psd;
    private final int options;
    private final int minChan;
    private final int maxChan;
    private final double[] voltages;
    private final double[] currents;
    private final Map<Integer, ChannelState> states = new HashMap<Integer, ChannelState>();
    private boolean initError = false;

    public PowerDevice(String name, PowerSupplyDriver psd, int options, int minChan, int maxChan) {
        this.devcName = name;
        this.psd = psd;
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
        this.maxCurrent = new double[maxChan - minChan + 1];
        Arrays.fill(this.maxCurrent, 3.0);
        this.voltages = new double[maxChan - minChan + 1];
        this.currents = new double[maxChan - minChan + 1];
        for (int chan = minChan; chan <= maxChan; ++chan) {
            this.states.put(chan, new ChannelState());
        }
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("maintain-power-" + this.name, () -> this.maintainPower()).withPeriod(Duration.ofMillis(6000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public int getMinChannel() {
        return this.minChan;
    }

    public int getMaxChannel() {
        return this.maxChan;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the connection type")
    public DriverConstants.ConnType getConnType() {
        return this.connType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device ID")
    public String getDevcId() {
        return this.devcId;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initDevice() {
        if (this.connType == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)CONN_TYPE, (String)"is missing");
        }
        if (this.connType == DriverConstants.ConnType.NET && (this.options & 1) != 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)CONN_TYPE, (String)("is invalid: " + this.connType));
        }
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)DEVC_ID, (String)"is missing");
        }
        this.fullName = this.devcName + (this.devcId.isEmpty() ? "" : " (" + this.devcId + ")");
    }

    protected void initialize() {
        try {
            this.psd.open(this.connType, this.devcId, this.devcParm);
            this.initSensors();
            for (int j = 0; j < this.maxCurrent.length; ++j) {
                this.setCurrent(this.minChan + j, this.maxCurrent[j]);
            }
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.psd.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void close() {
        try {
            this.psd.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type;
        Integer iType;
        int hwChan = ch.getHwChan();
        if (hwChan < this.minChan || hwChan > this.maxChan) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"HW channel", (Object)hwChan);
        }
        if ((iType = mTypeMap.get((type = ch.getTypeStr()).toUpperCase())) == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected String getGroupForChannel(Channel ch) {
        return "data";
    }

    protected void readChannelGroup(String group) {
        Arrays.fill(this.currents, Double.NaN);
        Arrays.fill(this.voltages, Double.NaN);
    }

    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        if (this.isOnline()) {
            int hwChan = ch.getHwChan();
            try {
                switch (ch.getType()) {
                    case 2: {
                        double d = this.readCurrent(hwChan);
                        this.currents[hwChan - this.minChan] = d;
                        value = d;
                        break;
                    }
                    case 1: {
                        double d = this.readVoltage(hwChan);
                        this.voltages[hwChan - this.minChan] = d;
                        value = d;
                        break;
                    }
                    case 0: {
                        value = this.voltages[hwChan - this.minChan] * this.currents[hwChan - this.minChan];
                        if (!Double.isNaN(value)) break;
                        value = this.readVoltage(hwChan) * this.readCurrent(hwChan);
                    }
                }
            }
            catch (DriverException e) {
                this.logError("Error reading from", hwChan, e);
                this.setOnline(false);
            }
        }
        return value;
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
        if (this.isOnline()) {
            for (int chan : this.states.keySet()) {
                ChannelState state = this.states.get(chan);
                try {
                    state.enabled = this.getOutput(chan);
                    state.power = (double)Math.round(10.0 * this.readVoltage(chan) * this.readCurrent(chan)) / 10.0;
                    state.voltError = false;
                    state.noLoad = false;
                }
                catch (DriverException e) {
                    this.logError("Error reading from", chan, e);
                }
            }
        }
    }

    public void enableOutput(int chan, boolean enable) {
        ChannelState state = this.getChannelState(chan);
        try {
            this.setOutput(chan, enable);
            state.enabled = enable;
            if (!enable) {
                state.voltError = false;
                state.noLoad = false;
            }
        }
        catch (DriverException e) {
            this.logError("Error enabling output for", chan, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPower(int chan, double value) {
        ChannelState state;
        ChannelState channelState = state = this.getChannelState(chan);
        synchronized (channelState) {
            if (!state.enabled) {
                return;
            }
            ArrayList<Float> values = new ArrayList<Float>();
            if (!Double.isNaN(value)) {
                state.power = value;
            }
            if (state.resistance == 0.0) {
                values.add(Float.valueOf((float)this.minVoltage));
                this.setChanVoltage(chan, this.minVoltage);
                try {
                    Thread.sleep(this.settlingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                double amps = this.readChanCurrent(chan);
                values.add(Float.valueOf((float)amps));
                if (amps > 0.0) {
                    state.resistance = this.readChanVoltage(chan) / amps;
                    state.noLoad = false;
                } else {
                    state.resistance = 0.0;
                }
            }
            if (state.resistance != 0.0) {
                double volts = Math.sqrt(state.power * state.resistance);
                if (this.softMaxCurrent > 0.0) {
                    volts = state.resistance * Math.min(volts / state.resistance, this.softMaxCurrent);
                }
                this.setChanVoltage(chan, volts);
                values.add(Float.valueOf((float)volts));
                try {
                    Thread.sleep(this.settlingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                double amps = this.readChanCurrent(chan);
                values.add(Float.valueOf((float)amps));
                state.resistance = amps <= 0.0 ? 0.0 : this.readChanVoltage(chan) / amps;
                if (state.resistance != 0.0) {
                    volts = Math.sqrt(state.power * state.resistance);
                    if (this.softMaxCurrent > 0.0) {
                        volts = state.resistance * Math.min(volts / state.resistance, this.softMaxCurrent);
                    }
                    this.setChanVoltage(chan, volts);
                    values.add(Float.valueOf((float)volts));
                }
            }
            if (state.resistance == 0.0) {
                if (!state.noLoad) {
                    this.logError("Unable to determine load resistance for", chan, null);
                }
                state.noLoad = true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                StringBuilder msg = new StringBuilder("Setting " + this.name + " channel " + chan + " power to ");
                msg.append((float)state.power).append(": voltages/currents =");
                for (Float v : values) {
                    msg.append(" ").append(v);
                }
                LOG.fine(msg.toString());
            }
        }
    }

    protected void maintainPower() {
        for (int chan : this.states.keySet()) {
            this.setPower(chan, Double.NaN);
        }
    }

    public double getPower(int chan) {
        return this.getChannelState(chan).power;
    }

    public boolean isEnabled(int chan) {
        return this.getChannelState(chan).enabled;
    }

    public boolean hasVoltError(int chan) {
        return this.getChannelState(chan).voltError;
    }

    public boolean hasNoLoad(int chan) {
        return this.getChannelState(chan).noLoad;
    }

    private void setChanVoltage(int chan, double value) {
        if (!this.isOnline()) {
            return;
        }
        ChannelState state = this.getChannelState(chan);
        try {
            this.setVoltage(chan, value);
            state.voltError = false;
        }
        catch (DriverException e) {
            if (!state.voltError) {
                this.logError("Error setting voltage on", chan, e);
            }
            state.voltError = true;
        }
    }

    private double readChanVoltage(int chan) {
        if (!this.isOnline()) {
            return Double.NaN;
        }
        try {
            return this.readVoltage(chan);
        }
        catch (DriverException e) {
            this.logError("Error reading voltage from", chan, e);
            return Double.NaN;
        }
    }

    private double readChanCurrent(int chan) {
        if (!this.isOnline()) {
            return Double.NaN;
        }
        try {
            return this.readCurrent(chan);
        }
        catch (DriverException e) {
            this.logError("Error reading current from", chan, e);
            return Double.NaN;
        }
    }

    public void setVoltage(int chan, double value) throws DriverException {
        this.psd.setVoltage(value, chan);
    }

    public void setCurrent(int chan, double value) throws DriverException {
        this.psd.setCurrent(value, chan);
    }

    public void setOutput(int chan, boolean value) throws DriverException {
        this.psd.setOutput(value, chan);
    }

    public double readVoltage(int chan) throws DriverException {
        return this.psd.readVoltage(chan);
    }

    public double readCurrent(int chan) throws DriverException {
        return this.psd.readCurrent(chan);
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.psd.getOutput(chan);
    }

    private ChannelState getChannelState(int chan) {
        return this.states.get(chan);
    }

    private void logError(String msg, int chan, DriverException e) {
        LOG.log(Level.SEVERE, "{0} {1} channel {2}{3}", new Object[]{msg, this.name, chan, e == null ? "" : ": " + (Object)((Object)e)});
    }

    static {
        mTypeMap.put("POWER", 0);
        mTypeMap.put("VOLTAGE", 1);
        mTypeMap.put("CURRENT", 2);
        LOG = Logger.getLogger(PowerDevice.class.getName());
    }

    public static class ChannelState {
        private double resistance;
        private double power;
        private boolean enabled;
        private boolean voltError;
        private boolean noLoad;
    }
}

