/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystem.ocsbridge.config.Device;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.atheader.SALMain;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.cccamera.CCCamera;

public class OCSBridgeConfig {
    @ConfigurationParameter
    private volatile Device device = Device.CAMERA;
    @ConfigurationParameter
    private final boolean hasFilterChanger = true;
    @ConfigurationParameter
    private volatile String mcmName = "mcm";
    @ConfigurationParameter(maxLength=50)
    private volatile String[] listenSubsystems = new String[0];

    public boolean hasFilterChanger() {
        return true;
    }

    public String getMCMName() {
        return this.mcmName;
    }

    public Device getDevice() {
        return this.device;
    }

    public String[] getListenSubsystems() {
        return this.listenSubsystems;
    }

    SAL<CameraCommand, CameraEvent, CameraTelemetry> getSALManager() {
        return OCSBridgeConfig.createSALManager(this.device);
    }

    static SAL<CameraCommand, CameraEvent, CameraTelemetry> createSALManager(Device device) {
        switch (device) {
            case CAMERA: {
                return SALCamera.create();
            }
            case AUXTEL: {
                return ATCamera.create();
            }
            case COMCAM: {
                return CCCamera.create();
            }
        }
        throw new UnsupportedOperationException("Device not yet supported: " + (Object)((Object)device));
    }

    String getCSCRoot() {
        switch (this.device) {
            case CAMERA: {
                return "MTCamera";
            }
            case AUXTEL: {
                return "ATCamera";
            }
            case COMCAM: {
                return "CCCamera";
            }
        }
        throw new UnsupportedOperationException("Device not yet supported: " + (Object)((Object)this.device));
    }

    SAL<SALCommand, SALEvent, SALTelemetry> getHeaderServiceManager() {
        switch (this.device) {
            case CAMERA: {
                return null;
            }
            case AUXTEL: {
                return SALMain.create();
            }
            case COMCAM: {
                return org.lsst.sal.ccheader.SALMain.create();
            }
        }
        throw new UnsupportedOperationException("Device not yet supported: " + (Object)((Object)this.device));
    }

    static OCSBridgeConfig createDefaultConfig() {
        OCSBridgeConfig config = new OCSBridgeConfig();
        return config;
    }
}

