/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.CornerRaft;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.WFCCDType;
import org.lsst.ccs.utilities.readout.WcsCoordinatesFitsHeaderMetadataProvider;

public class VisualizeFocalPlane {
    public static void main(String[] args) {
        JFrame frame = new JFrame("DrawRect");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setPreferredSize(new Dimension(3800, 3800));
        FocalPlane fp = FocalPlane.createFocalPlane();
        ArrayList<SegmentRectangle> list = new ArrayList<SegmentRectangle>();
        for (Raft r : fp.getRafts()) {
            for (CCD ccd : r.getChildrenList()) {
                for (Segment seg : ccd.getSegments()) {
                    Map<String, Object> map = WcsCoordinatesFitsHeaderMetadataProvider.getWcsCoordinatesFor(ccd).get(ccd.getSegments().indexOf(seg));
                    SegmentRectangle segR = new SegmentRectangle(seg, map);
                    list.add(segR);
                }
            }
        }
        frame.getContentPane().add(new FocalPlaneGeom(list));
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static class FocalPlaneGeom
    extends JPanel {
        private final List<SegmentRectangle> segments;

        FocalPlaneGeom(List<SegmentRectangle> segments) {
            this.segments = segments;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g.translate(700, 700);
            g2.scale(0.01, 0.01);
            g2.rotate(Math.PI);
            for (SegmentRectangle s : this.segments) {
                s.paintComponent(g);
            }
        }
    }

    public static class SegmentRectangle
    extends JPanel {
        private final CCDType type;
        private final boolean isCorner;
        private final Color c;
        private final Raft r;
        private final CCD ccd;
        private final int x0;
        private final int y0;
        private final int deltax;
        private final int deltay;

        SegmentRectangle(Segment seg, Map<String, Object> map) {
            this.ccd = (CCD)seg.getParent();
            this.r = (Raft)this.ccd.getParent();
            int crval1f = Double.valueOf((String)map.get("CRVAL1F")).intValue();
            int crval2f = Double.valueOf((String)map.get("CRVAL2F")).intValue();
            int d12 = Double.valueOf((String)map.get("PC1_2F")).intValue();
            int d21 = Double.valueOf((String)map.get("PC2_1F")).intValue();
            int d11 = Double.valueOf((String)map.get("PC1_1F")).intValue();
            int d22 = Double.valueOf((String)map.get("PC2_2F")).intValue();
            String datasec = (String)map.get("DATASEC");
            String xRange = datasec.replace("[", "").replace("]", "").split(",")[0];
            String yRange = datasec.replace("[", "").replace("]", "").split(",")[1];
            int xmin = Integer.valueOf(xRange.split(":")[0].trim());
            int xmax = Integer.valueOf(xRange.split(":")[1].trim());
            int ymin = Integer.valueOf(yRange.split(":")[0].trim());
            int ymax = Integer.valueOf(yRange.split(":")[1].trim());
            String newDataSec = "[" + xmin + ":" + xmax + "," + ymin + ":" + ymax + "]";
            int x_first = d11 * xmin + d12 * ymin + crval1f;
            int y_first = d21 * xmin + d22 * ymin + crval2f;
            int x_last = d11 * xmax + d12 * ymax + crval1f;
            int y_last = d21 * xmax + d22 * ymax + crval2f;
            String fullName = this.r.getName() + "/" + this.ccd.getName() + "/" + seg.getName();
            this.isCorner = this.r instanceof CornerRaft;
            this.deltax = Math.abs(x_last - x_first);
            this.deltay = Math.abs(y_last - y_first);
            this.x0 = x_last < x_first ? x_last : x_first;
            this.y0 = y_last < y_first ? y_last : y_first;
            this.type = this.ccd.getType();
            this.c = !this.isCorner ? Color.GRAY : (this.type instanceof WFCCDType ? Color.BLUE : Color.RED);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.c);
            Graphics2D g2 = (Graphics2D)g;
            g.drawRect(this.x0, this.y0, this.deltax, this.deltay);
        }
    }
}

