/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.localdb.statusdb.FastBatchPersister;
import org.lsst.ccs.localdb.statusdb.MetaDataPersister;
import org.lsst.ccs.localdb.statusdb.RegisterDataDescLastUpdate;
import org.lsst.ccs.localdb.statusdb.RegisterDataGroup;
import org.lsst.ccs.localdb.statusdb.StatDataAccumulator;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataDescLastUpdate;
import org.lsst.ccs.localdb.statusdb.model.DataGroup;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;

public class StatusDataPersister
extends FastBatchPersister<Object[]>
implements StatusMessageListener,
AgentPresenceListener {
    private final Logger ignore_log = Logger.getLogger(this.getClass().getCanonicalName() + ".ignore");
    private static final DataDesc NULL_DESCRIPTION = new DataDesc();
    private static final long[] DEFAULT_TIME_BIN_WIDTH = new long[]{300000L, 1800000L};
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent subsys;
    private final Map<DataPath, DataDesc> map = new ConcurrentHashMap<DataPath, DataDesc>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private StatDataAccumulator statDataAccumulator;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MetaDataPersister mdPersister;
    private final Set<String> dictionaryProcessed = new CopyOnWriteArraySet<String>();
    private final Map<String, Set<String>> noDictionaryProcessedWarning = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> doNotTrendData = new ConcurrentHashMap<String, Set<String>>();
    private final Map<Long, Long> lastUpdateMap = new ConcurrentHashMap<Long, Long>();

    @Override
    public void build() {
        super.build();
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("data-last-update", () -> this.updateDataLastUpdate()).withIsFixedRate(true).withPeriod(Duration.ofMinutes(1L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataLastUpdate() {
        Map<Long, Long> map = this.lastUpdateMap;
        synchronized (map) {
            this.addToQueue(new Object[]{new RegisterDataDescLastUpdate(this.lastUpdateMap)});
            this.lastUpdateMap.clear();
        }
    }

    @Override
    public void init() {
        super.init();
        SessionFactory fac = StatusdbUtils.getSessionFactory();
        this.log.fine("init StatusPersister");
        Session sess = fac.openSession();
        Transaction tx = sess.beginTransaction();
        List l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            this.map.put(dd.getDataPath(), dd);
            this.log.fine("storing " + dd.getDataPath().getFullKey());
            StatusDataPersister.getStatDescs(dd, sess, this.log);
        }
        tx.commit();
        sess.close();
        this.log.info("analyzing data desc integrity ...");
        this.analizeDataMapIntegrity();
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void start() {
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusData.class).or(BusMessageFilterFactory.messageClass(StatusDataProviderDictionary.class)).or(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class)).and(BusMessageFilterFactory.messageOrigin(null)));
    }

    @Override
    public void shutdown() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        super.shutdown();
    }

    public void disconnecting(AgentInfo ai) {
        if (ai.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) {
            return;
        }
        String agentName = ai.getName();
        this.dictionaryProcessed.remove(agentName);
        this.noDictionaryProcessedWarning.remove(agentName);
        this.doNotTrendData.remove(agentName);
    }

    public void onStatusMessage(StatusMessage s) {
        block11: {
            block10: {
                if (s.getOriginAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) {
                    return;
                }
                if (!(s instanceof StatusData)) break block10;
                KeyValueDataList encodedData = (KeyValueDataList)s.getEncodedData();
                if (encodedData == null) break block11;
                this.processEncodedData(s.getOriginAgentInfo().getName(), encodedData);
                break block11;
            }
            if (s instanceof StatusDataProviderDictionary) {
                String name = s.getOriginAgentInfo().getName();
                this.log.log(Level.FINER, "received a data dictionary for {0}", name);
                if (this.dictionaryProcessed.contains(name)) {
                    return;
                }
                this.dictionaryProcessed.add(name);
                StatusDataProviderDictionary sdpd = (StatusDataProviderDictionary)s;
                DataProviderDictionary dpd = (DataProviderDictionary)sdpd.getObject();
                RegisterDataGroup rdg = new RegisterDataGroup(s.getOriginAgentInfo());
                this.addToQueue(new Object[]{rdg, dpd});
                for (DataProviderInfo dpi : dpd.getDataProviderInfos()) {
                    DataProviderInfo.Type dataType;
                    String typeStr = dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
                    if (typeStr == null || (dataType = DataProviderInfo.Type.valueOf((String)typeStr)) != DataProviderInfo.Type.MONITORING && dataType != DataProviderInfo.Type.TRENDING) continue;
                    if ("true".equals(dpi.getAttributeValue(DataProviderInfo.Attribute.DO_NOT_TREND))) {
                        Set ignoreData = this.doNotTrendData.getOrDefault(name, new CopyOnWriteArraySet());
                        ignoreData.add(name + "/" + dpi.getFullPath());
                        this.ignore_log.fine("Adding " + name + " to ignore list");
                        this.doNotTrendData.put(name, ignoreData);
                        continue;
                    }
                    for (DataProviderInfo.Attribute attr : dpi.getAttributes()) {
                        if (!attr.isMetadata()) continue;
                        this.queueImmediateMetaData(s.getOriginAgentInfo().getAgentStartTime().getUTCInstant().toEpochMilli(), new DataPath(name, dpi.getPath()), attr.getName(), dpi.getAttributeValue(attr));
                    }
                }
            } else if (s instanceof StatusConfigurationInfo) {
                ConfigurationInfo ci = ((StatusConfigurationInfo)s).getConfigurationInfo();
                this.log.log(Level.FINE, "Processing configurationInfo for {0}", ((StatusConfigurationInfo)s).getOriginAgentInfo().getName());
                HashMap<String, ChannelMetadata> channelsMetadata = new HashMap<String, ChannelMetadata>();
                for (ConfigurationParameterInfo par : ci.getAllParameterInfo()) {
                    String parName = par.getParameterName();
                    if (!parName.equals("limitLo") && !parName.equals("limitHi") && !parName.equals("dbandHi") && !parName.equals("dbandLo") && !parName.equals("warnLo") && !parName.equals("warnHi")) continue;
                    String channelPath = par.getComponentName();
                    ChannelMetadata channelMetadata = channelsMetadata.getOrDefault(channelPath, new ChannelMetadata(channelPath));
                    channelMetadata.setMetaValue(parName, par.getCurrentValue());
                    channelsMetadata.put(channelPath, channelMetadata);
                }
                for (ChannelMetadata channelMetadata : channelsMetadata.values()) {
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "alarmLow", channelMetadata.getAlarmLow());
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "alarmHigh", channelMetadata.getAlarmHigh());
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "warningLow", channelMetadata.getWarningLow());
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "warningHigh", channelMetadata.getWarningHigh());
                    this.log.log(Level.FINE, "Updating metadata for {0}: alarmLow({1}) warningLow({2}) warningHigh({3}) alarmHigh({4})", new Object[]{channelMetadata.channelPath, channelMetadata.getAlarmLow(), channelMetadata.getWarningLow(), channelMetadata.getWarningHigh(), channelMetadata.getAlarmHigh()});
                }
            }
        }
    }

    private void queueImmediateMetaData(long tStamp, DataPath name, String metadata, String value) {
        this.mdPersister.queueImmediateMetaData(tStamp, name, metadata, value);
    }

    public synchronized void processEncodedData(String source, KeyValueDataList encodedData) {
        for (KeyValueData d : encodedData) {
            KeyValueData.KeyValueDataType type = d.getType();
            if (null == type) continue;
            switch (type) {
                case KeyValueTrendingData: {
                    this.queueImmediateScalar(source, d);
                    break;
                }
                case KeyValueMetaData: {
                    String metaPath = d.getKey();
                    int lastIndex = metaPath.lastIndexOf(47);
                    String metaname = metaPath.substring(lastIndex + 1);
                    if (metaname.equals("alarmHigh") || metaname.equals("alarmLow") || metaname.equals("warningHigh") || metaname.equals("warningLow")) break;
                    String key = metaPath.replace("/" + metaname, "");
                    this.queueImmediateMetaData(d.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(source, key), metaname, (String)((Object)d.getValue()));
                    break;
                }
            }
        }
    }

    private boolean ignoreData(DataPath path) {
        String source = path.getAgentName();
        Set<String> ignoreData = this.doNotTrendData.get(source);
        if (ignoreData != null && ignoreData.contains(path.getFullKey())) {
            this.ignore_log.log(Level.FINE, "Skipping data {0} for source {1}", new Object[]{path.getFullKey(), source});
            return true;
        }
        return false;
    }

    private void queueImmediateScalar(String source, KeyValueData kvd) {
        if (!this.dictionaryProcessed.contains(source)) {
            Set warningIssued = this.noDictionaryProcessedWarning.computeIfAbsent(source, s -> new CopyOnWriteArraySet());
            if (!warningIssued.contains(kvd.getKey())) {
                this.log.log(Level.WARNING, "Skipping data {0} {1} (no dictionary)", new Object[]{source, kvd.getKey()});
                warningIssued.add(kvd.getKey());
            }
            return;
        }
        long tStamp = kvd.getCCSTimeStamp().getUTCInstant().toEpochMilli();
        DataPath name = new DataPath(source, kvd.getKey());
        if (this.ignoreData(name)) {
            return;
        }
        Serializable d = kvd.getValue();
        this.log.log(Level.FINER, "got update {0}", name);
        RawData data = new RawData();
        data.setTime(tStamp);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).doubleValue()));
        } else if (d instanceof Integer) {
            data.setDoubleData(Double.valueOf(((Integer)d).doubleValue()));
        } else if (d instanceof Short) {
            data.setDoubleData(Double.valueOf(((Short)d).doubleValue()));
        } else if (d instanceof Long) {
            data.setDoubleData(Double.valueOf(((Long)d).doubleValue()));
        } else {
            data.setStringData(String.valueOf(d));
        }
        this.addToQueue(new Object[]{data, name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistData(RawData data, DataPath name, Session sess) {
        if (data.getDoubleData() != null && !Double.isFinite(data.getDoubleData())) {
            this.log.log(Level.WARNING, "Skipping non-finite RawData value {0} for path {1}", new Object[]{data.getDoubleData(), data.getDataDesc()});
            return;
        }
        DataDesc dd = this.getDataDescription(name, "trending", sess);
        if (dd == null || dd == NULL_DESCRIPTION) {
            return;
        }
        data.setDataDesc(dd);
        sess.lock((Object)dd, LockMode.NONE);
        Map<Long, Long> map = this.lastUpdateMap;
        synchronized (map) {
            Long storedLastUpdate = this.lastUpdateMap.getOrDefault(dd.getId(), -1L);
            long t = data.getTime();
            if (t > storedLastUpdate) {
                this.lastUpdateMap.put(dd.getId(), t);
            }
        }
        sess.persist((Object)data);
        this.statDataAccumulator.addToQueue(data);
    }

    public StatDataAccumulator getStatAccumulator() {
        return this.statDataAccumulator;
    }

    private void persistDataDescLastUpdate(RegisterDataDescLastUpdate lastUpdate, Session sess) {
        long start = System.currentTimeMillis();
        for (Map.Entry<Long, Long> e : lastUpdate.getLastUpdates().entrySet()) {
            Long id = e.getKey();
            long t = e.getValue();
            DataDescLastUpdate last = new DataDescLastUpdate(id, t);
            sess.saveOrUpdate((Object)last);
        }
        long delta = System.currentTimeMillis() - start;
        this.log.log(Level.INFO, "Took {0} ms to update last time for {1} entries.", new Object[]{delta, lastUpdate.getLastUpdates().size()});
    }

    private void persistDataGroups(RegisterDataGroup rdg, DataProviderDictionary dpd, Session sess) {
        String agentName = rdg.getAgentName();
        ArrayList<DataPath> dictionaryPaths = new ArrayList<DataPath>();
        for (DataProviderInfo dataProviderInfo : dpd.getDataProviderInfos()) {
            String typeStr = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            if (typeStr == null) continue;
            try {
                DataProviderInfo.Type dataType = DataProviderInfo.Type.valueOf((String)typeStr);
                if (dataType != DataProviderInfo.Type.MONITORING && dataType != DataProviderInfo.Type.TRENDING) continue;
                dictionaryPaths.add(new DataPath(agentName, dataProviderInfo.getPath()));
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Illegal type conversion from {0}", typeStr);
            }
        }
        for (Map.Entry entry : this.map.entrySet()) {
            boolean isInDictionary = dictionaryPaths.remove(entry.getKey());
            DataDesc dataDesc = (DataDesc)entry.getValue();
            if (dataDesc.getDataPath() == null || !dataDesc.getDataPath().getAgentName().equals(agentName)) continue;
            if (!dataDesc.getActive()) {
                if (!isInDictionary) continue;
                dataDesc.setActive(true);
                sess.saveOrUpdate((Object)dataDesc);
                continue;
            }
            if (isInDictionary) continue;
            this.log.log(Level.WARNING, "Disabling Data description for {0}", entry.getKey());
            dataDesc.setActive(false);
            sess.saveOrUpdate((Object)dataDesc);
        }
        for (String string : dpd.getGroups()) {
            for (DataProviderInfo dpi : dpd.getDataProviderDescriptionsForGroup(string)) {
                DataDesc dd = this.getDataDescription(new DataPath(agentName, dpi.getPath()), "trending", sess);
                rdg.addDataDescToGroup(string, dd);
            }
        }
        this.log.log(Level.FINER, "persisting data group information");
        for (Map.Entry entry : rdg.getDataDescs().entrySet()) {
            String groupName = (String)entry.getKey();
            DataGroup dg = StatusDataPersister.getDataGroup(agentName, groupName, sess);
            this.log.log(Level.FINER, "updating data group {0} for {1}", new Object[]{groupName, agentName});
            for (DataDesc dd : (List)entry.getValue()) {
                if (dg.getMembers().containsKey(dd.getDataPath())) continue;
                dg.addMember(dd);
            }
        }
        sess.flush();
    }

    private DataDesc getDataDescription(DataPath key, String type, Session sess) {
        Query q = sess.getNamedQuery("findDataDesc").setString("agentName", key.getAgentName()).setString("dataName", key.getDataName());
        DataDesc dd = (DataDesc)q.uniqueResult();
        if (dd == null) {
            dd = new DataDesc();
            dd.setDataPath(key);
            dd.setDataType(type);
            sess.persist((Object)dd);
            this.log.log(Level.FINE, "Adding default Data Description for {0}: {1}", new Object[]{key, dd.getId()});
            this.map.put(key, dd);
        }
        return dd;
    }

    public static synchronized DataGroup getDataGroup(String agentName, String groupName, Session sess) {
        Query q = sess.getNamedQuery("findDataGroup").setString("agentName", agentName).setString("groupName", groupName);
        DataGroup dg = (DataGroup)q.uniqueResult();
        if (dg == null) {
            dg = new DataGroup(agentName, groupName);
            sess.persist((Object)dg);
        }
        return dg;
    }

    public static List<StatDesc> getStatDescs(DataDesc dd, Session sess, Logger log) {
        List stats = sess.getNamedQuery("findStatDesc").setEntity("dd", (Object)dd).setFlushMode(FlushMode.COMMIT).setCacheable(true).list();
        if (stats.isEmpty()) {
            try {
                for (long statInterval : DEFAULT_TIME_BIN_WIDTH) {
                    StatDesc defaultSD = new StatDesc();
                    defaultSD.setDataDesc(dd);
                    defaultSD.setTimeBinWidth(statInterval);
                    sess.persist((Object)defaultSD);
                    stats.add(defaultSD);
                    log.log(Level.FINE, "Adding default statistical binning of {0} milliseconds to {1}", new Object[]{statInterval, dd.getDataPath()});
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem getting statistical data bin for {0} {1}", new Object[]{dd.getDataPath(), dd.getId()});
                throw e;
            }
        }
        return stats;
    }

    private void analizeDataMapIntegrity() {
    }

    static boolean areDataNamesConsistent(String name1, String name2) {
        if (name1.equals(name2)) {
            return true;
        }
        String[] array1 = name1.split("/");
        String[] array2 = name2.split("/");
        for (int i = 0; i < Math.min(array1.length, array2.length); ++i) {
            if (array1[i].equals(array2[i])) continue;
            return true;
        }
        return array1.length == array2.length;
    }

    @Override
    public void persist(Object[] obj, Session sess) {
        Object toPersist = obj[0];
        if (toPersist instanceof RegisterDataGroup) {
            this.persistDataGroups((RegisterDataGroup)toPersist, (DataProviderDictionary)obj[1], sess);
        } else if (toPersist instanceof RegisterDataDescLastUpdate) {
            this.persistDataDescLastUpdate((RegisterDataDescLastUpdate)toPersist, sess);
        } else {
            DataPath name = (DataPath)obj[1];
            if (toPersist instanceof RawData) {
                this.persistData((RawData)toPersist, name, sess);
            } else if (toPersist != null) {
                sess.persist(toPersist);
            }
        }
    }

    class ChannelMetadata {
        private final String channelPath;
        private double limitLo;
        private double limitHi;
        private double dbandLo;
        private double dbandHi;
        private String warnLo;
        private String warnHi;
        private boolean useOldDband = true;

        ChannelMetadata(String channelPath) {
            this.channelPath = channelPath;
        }

        void setMetaValue(String parName, String parValue) {
            double val = Double.parseDouble(parValue);
            if (parName.equals("limitLo")) {
                this.limitLo = val;
            } else if (parName.equals("limitHi")) {
                this.limitHi = val;
            } else if (parName.equals("dbandHi")) {
                this.dbandHi = val;
            } else if (parName.equals("dbandLo")) {
                this.dbandLo = val;
            } else if (parName.equals("warnLo")) {
                this.useOldDband = false;
                this.warnLo = parValue;
            } else if (parName.equals("warnHi")) {
                this.useOldDband = false;
                this.warnHi = parValue;
            } else {
                throw new IllegalArgumentException("Illegal Parameter name " + parName);
            }
        }

        String getAlarmHigh() {
            return String.valueOf(this.limitHi);
        }

        String getWarningHigh() {
            return this.useOldDband ? String.valueOf(this.dbandHi <= 0.0 ? this.limitHi : this.limitHi - this.dbandHi) : this.warnHi;
        }

        String getWarningLow() {
            return this.useOldDband ? String.valueOf(this.dbandLo <= 0.0 ? this.limitLo : this.limitLo + this.dbandLo) : this.warnLo;
        }

        String getAlarmLow() {
            return String.valueOf(this.limitLo);
        }
    }
}

