/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.auxelex.RebPS;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.auxelex.SrpException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.RebPsBoardAlarm;
import org.lsst.ccs.subsystem.power.RebTrippedState;
import org.lsst.ccs.subsystem.power.constants.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.PowerSupplyState;
import org.lsst.ccs.subsystem.power.states.RebDPhiState;
import org.lsst.ccs.subsystem.power.states.RebHvBiasState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class RebPsDevice
extends Device {
    private static final Logger LOG = Logger.getLogger(RebPsDevice.class.getName());
    private static final String UNKN_PSID = "PS-XX";
    private static final int PS_POWER = 255;
    private static final double LIM_LOW_DIGITAL = 4.5;
    private static final double LIM_HIGH_DIGITAL = 6.0;
    private static final double LIM_LOW_ANALOG = 6.5;
    private static final double LIM_HIGH_ANALOG = 8.5;
    private static final double LIM_LOW_CLKL_SR = 12.0;
    private static final double LIM_HIGH_CLKL_SR = 17.0;
    private static final double LIM_LOW_CLKL_CR = 10.0;
    private static final double LIM_HIGH_CLKL_CR = 12.0;
    private static final double LIM_LOW_CLKH_SR = 15.0;
    private static final double LIM_HIGH_CLKH_SR = 17.0;
    private static final double LIM_LOW_CLKH_CR = 10.0;
    private static final double LIM_HIGH_CLKH_CR = 12.0;
    private static final double LIM_LOW_OD_SR = 35.0;
    private static final double LIM_HIGH_OD_SR = 42.0;
    private static final double LIM_LOW_OD_CR = 35.0;
    private static final double LIM_HIGH_OD_CR = 37.0;
    private static final double LIM_LOW_HEATER_SR = 7.0;
    private static final double LIM_HIGH_HEATER_SR = 13.0;
    private static final double LIM_LOW_HEATER_CR = 5.0;
    private static final double LIM_HIGH_HEATER_CR = 7.0;
    private static final double LIM_LOW_DPHI = 4.0;
    private static final double LIM_HIGH_DPHI = 13.0;
    private static final Map<String, Integer> psMap = new HashMap<String, Integer>();
    private static final SeqParams[] onSeqSR02;
    private static final SeqParams[] onSeqSR1;
    private static final SeqParams[] onSeqCR0;
    private static final SeqParams[] onSeqCR1;
    @ConfigurationParameter(name="ipAddr", category="Power", isFinal=true)
    private volatile String ipAddr;
    @ConfigurationParameter(name="nPowerOnPub", category="Power", description="Number of publications after a power on sequence")
    private volatile int nPowerOnPub = 15;
    @ConfigurationParameter(isReadOnly=true, maxLength=6, description="List of Rebs powered by this PS")
    private volatile List<String> rebs = new ArrayList<String>();
    private List<String> rebsList;
    @ConfigurationParameter(name="switchName", category="build")
    private volatile String switchName;
    private int psType = -1;
    private final RebPS ps = new RebPS(null);
    private int psVersion = 1;
    private Event listener;
    private String psId = "PS-XX";
    private Properties props;
    private boolean isSimulated;
    private double[] power = new double[6];
    private volatile int caughtExceptionNumber = 0;
    private volatile int numberOfConsectiveExceptionsToOffline = 1;
    private boolean initError = false;
    private final RebTrippedState noTrip = new RebTrippedState(false);
    private final StateBundle deviceAndRebsState = new StateBundle(new Enum[0]);
    private final Object stateLock = new Object();
    private boolean isCornerRaft = false;
    private volatile int rebBeingPoweredOn = -1;
    private volatile int lastFail = Integer.MIN_VALUE;
    private final List<RebPowerState> rebPowerStates = new CopyOnWriteArrayList<RebPowerState>();
    private int simulatedPsType = -1;
    @LookupPath
    protected String psPath;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private List<RebPsBoardAlarm> boardTemperatureAlarms = new ArrayList<RebPsBoardAlarm>();
    private List<MonitorUpdateTask> tasksForDevice = null;

    public void build() {
        super.build();
        if (this.rebsList != null) {
            this.rebs.addAll(this.rebsList);
        } else {
            LOG.log(Level.WARNING, "The list of Rebs has not been provided; read-only configuration parameter \"rebs\" will be empty.");
        }
    }

    protected void initDevice() {
        this.tasksForDevice = this.getDeviceMonitorUpdateTasks();
        this.isSimulated = RunMode.isSimulation();
        String fileName = "psid.properties";
        if (BootstrapResourceUtils.getBootstrapResource((String)fileName) == null) {
            LOG.log(Level.WARNING, "PS ID properties file ({0}) not found", fileName);
        }
        this.props = BootstrapResourceUtils.getBootstrapProperties((String)fileName);
        if (this.ipAddr == null && !this.isSimulated) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ipAddr", (String)"is missing");
        }
        this.fullName = "REB PS board (" + (this.isSimulated ? "simulated" : this.ipAddr) + ")";
        this.ps.setLogName(this.fullName);
    }

    protected void initialize() {
        try {
            this.ps.open(this.isSimulated ? "" : this.ipAddr);
            this.ps.configTemperature();
            this.psVersion = this.ps.getVersion();
            this.psType = this.ps.getType();
            this.generatePsId();
            this.caughtExceptionNumber = 0;
            this.initSensors();
            if (this.listener != null) {
                this.listener.opened();
            }
            String buildStamp = this.ps.getBuildStamp();
            Srp.BoardType boardType = this.ps.getBoardType();
            long serialNumber = this.ps.getSerialNo();
            int fwVersion = this.ps.getFwVersion();
            LOG.log(Level.INFO, () -> String.format("Connected to %s with buildstamp=\"%s\" boardType=%s serial=%x fwVersion=%d psVersion=%d psType=%d", this.fullName, buildStamp, boardType, serialNumber, fwVersion, this.psVersion, this.psType));
            this.initError = false;
            for (Alarm alarm : this.boardTemperatureAlarms) {
                alarm.clearState();
            }
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.ps.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void setOnline(boolean online) {
        this.initializeState(online);
        super.setOnline(online);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeState(boolean online) {
        Object object = this.stateLock;
        synchronized (object) {
            this.deviceAndRebsState.setComponentState(this.path, new Enum[]{online ? PowerSupplyState.ON : PowerSupplyState.OFF});
            for (String path : this.rebs) {
                if (path.contains("Heater") || path.isEmpty()) continue;
                this.deviceAndRebsState.setComponentState(path, new Enum[]{RebPowerState.UNKNOWN});
                this.deviceAndRebsState.setComponentState(path, new Enum[]{RebHvBiasState.UNKNOWN});
                if (!this.isCornerRaft) continue;
                this.deviceAndRebsState.setComponentState(path, new Enum[]{RebDPhiState.UNKNOWN});
            }
        }
        this.lastFail = Integer.MIN_VALUE;
        this.rebPowerStates.clear();
        this.rebPowerStates.addAll(Collections.nCopies(6, RebPowerState.UNKNOWN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTripState(int rebNumber, RebTrippedState trippedState) {
        Object object = this.stateLock;
        synchronized (object) {
            String rebPath = this.rebs.get(rebNumber);
            if (this.path.contains("Heater") || this.path.isEmpty()) {
                return;
            }
            RebPowerState rebCurrentState = (RebPowerState)this.deviceAndRebsState.getComponentState(rebPath, RebPowerState.class);
            if (trippedState.hasTripped()) {
                if (rebCurrentState != RebPowerState.TRIPPED) {
                    this.deviceAndRebsState.setComponentState(rebPath, new Enum[]{RebPowerState.TRIPPED});
                }
            } else if (rebCurrentState == RebPowerState.TRIPPED) {
                this.deviceAndRebsState.setComponentState(rebPath, new Enum[]{RebPowerState.UNKNOWN});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRebState(int rebNumber, int rebPowerState) {
        Object object = this.stateLock;
        synchronized (object) {
            String rebPath = this.rebs.get(rebNumber);
            if (this.path.contains("Heater") || this.path.isEmpty()) {
                return;
            }
            RebPowerState state = RebPowerState.TRIPPED;
            if (this.deviceAndRebsState.getComponentState(rebPath, RebPowerState.class) != RebPowerState.TRIPPED) {
                state = this.getRebPowerState(rebPowerState);
            }
            this.deviceAndRebsState.setComponentState(rebPath, new Enum[]{state});
            this.rebPowerStates.set(rebNumber, state);
            this.deviceAndRebsState.setComponentState(rebPath, new Enum[]{this.getRebHvBiasState(rebPowerState)});
            if (this.isCornerRaft) {
                this.deviceAndRebsState.setComponentState(rebPath, new Enum[]{this.getRebDphiState(rebPowerState)});
            }
        }
    }

    protected void close() {
        if (this.listener != null) {
            this.listener.closed();
        }
        this.psId = UNKN_PSID;
        try {
            this.ps.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    public void setReadTimeout(long timeout) {
        LOG.log(Level.FINE, "Updating read timeout for {0} to {1} ms", new Object[]{this.fullName, timeout});
        this.ps.setReadTimeout((int)timeout);
    }

    public void setConsecutiveExceptiionsToOffline(int nExceptions) {
        LOG.log(Level.FINE, "Updating the number of consecutive exceptions to go Offline for Device {0} to {1}", new Object[]{this.fullName, nExceptions});
        this.numberOfConsectiveExceptionsToOffline = nExceptions;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer rebNum = null;
        Integer psNum = null;
        String[] flds = type.split(":");
        if (flds.length == 1) {
            if (flds[0].toUpperCase().equals("TEMP")) {
                psNum = -1;
                rebNum = 0;
            } else if (flds[0].toUpperCase().equals("STATE")) {
                psNum = -2;
                rebNum = 0;
            }
        } else if (flds.length == 2) {
            try {
                rebNum = Integer.valueOf(flds[0]);
                psNum = psMap.get(flds[1].toUpperCase());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (psNum == null) {
            String text = rebNum == null ? "type (REB number)" : "type (PS name)";
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)text, (Object)type);
        }
        if (psNum >= 0 && psNum != 255 && !RebPS.testChannelNumber((int)psNum, (int)hwChan)) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{rebNum << 8 | psNum, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            if (type == -1) {
                if (hwChan > this.ps.getNumTemperatures()) {
                    ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
                }
            } else if (type == -2) {
                if (hwChan < -1 || hwChan > this.ps.getNumRebs()) {
                    ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
                }
            } else {
                int rebNum = type >> 8;
                int psNum = type & 0xFF;
                if (psNum != 255 && !this.ps.testRebNumber(rebNum)) {
                    ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"REB number", (Object)rebNum);
                }
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.isOnline()) {
            boolean isTempChan = type == -1;
            boolean isStateChan = type == -2;
            int rebNum = type >> 8;
            int psNum = type & 0xFF;
            try {
                if (isTempChan) {
                    value = hwChan == this.ps.getNumTemperatures() ? this.ps.readFPGATemperature() : this.ps.readTemperature(hwChan);
                } else if (isStateChan) {
                    if (hwChan == -1) {
                        int nReb = this.ps.getNumRebs();
                        int rawValue = this.ps.getFailureSummary();
                        int convertedValue = rawValue & (1 << nReb) - 1;
                        LOG.log(Level.FINER, "PS {0} tripped state value: {1} (failure sumary: {2})", new Object[]{this.path, convertedValue, rawValue});
                        if (convertedValue != this.lastFail) {
                            if (this.lastFail != Integer.MIN_VALUE) {
                                LOG.log(Level.INFO, "PS {0} tripped state value changed from {1} to {2}", new Object[]{this.path, this.lastFail, convertedValue});
                            }
                            this.lastFail = convertedValue;
                            for (int reb = 0; reb < nReb; ++reb) {
                                RebTrippedState currentState;
                                if ((this.lastFail & 1 << reb) != 0) {
                                    String tripReason = String.format("REB PS %s tripped: %s", reb, this.ps.getFailureDetailString(reb));
                                    LOG.severe(tripReason);
                                    currentState = new RebTrippedState(true, tripReason);
                                } else {
                                    currentState = this.noTrip;
                                }
                                this.updateTripState(reb, currentState);
                            }
                        }
                        value = convertedValue;
                    } else {
                        int state = this.ps.getPower(hwChan);
                        this.updateRebState(hwChan, state);
                        value = state;
                    }
                } else if (psNum == 255) {
                    if (rebNum >= 6) {
                        value = 0.0;
                        for (int j = 0; j < this.ps.getNumRebs(); ++j) {
                            value += this.power[j];
                        }
                    } else {
                        value = 0.0;
                        for (int psN = 0; psN < 7; ++psN) {
                            if (psN == 6 || !this.ps.isPowerOn(rebNum, psN)) continue;
                            double volts = this.ps.readChannel(rebNum, psN, 2);
                            if (psN == 4) {
                                volts = this.ps.readChannel(rebNum, psN, 0) - volts;
                            }
                            value += volts * this.ps.readChannel(rebNum, psN, 1);
                        }
                        this.power[rebNum] = value;
                    }
                } else if (psNum != 4 || hwChan != 4 || this.ps.isPowerOn(rebNum, psNum)) {
                    value = this.ps.readChannel(rebNum, psNum, hwChan);
                }
                this.caughtExceptionNumber = 0;
            }
            catch (DriverException e) {
                Supplier<String> msgSupplier;
                Level logLevel = Level.SEVERE;
                if (psNum == 2 || psNum == 6) {
                    if (this.rebBeingPoweredOn == rebNum && e instanceof SrpException.SrpInvalidRegisterAddressException) {
                        logLevel = Level.FINER;
                    }
                    msgSupplier = () -> String.format("Error reading %s: reb=%d ps=%d", this.fullName, rebNum, psNum);
                } else if (e instanceof SrpException.SrpInvalidRegisterAddressException) {
                    if (this.rebPowerStates.get(rebNum) != RebPowerState.ON) {
                        logLevel = Level.FINER;
                    }
                    msgSupplier = () -> String.format("Error reading %s: reb=%d ps=%d (not powered on?)", this.fullName, rebNum, psNum);
                } else {
                    msgSupplier = () -> String.format("Error reading %s: reb=%d ps=%d", this.fullName, rebNum, psNum);
                }
                this.processCaughtException((Exception)((Object)e), logLevel, msgSupplier);
            }
        }
        return value;
    }

    private void processCaughtException(Exception e) {
        this.processCaughtException(e, Level.SEVERE, null);
    }

    private void processCaughtException(Exception e, Level level, Supplier<String> msgSupplier) {
        boolean countTowardOfflineState;
        boolean bl = countTowardOfflineState = e instanceof DriverTimeoutException || e.getCause() instanceof IOException;
        if (countTowardOfflineState) {
            ++this.caughtExceptionNumber;
        }
        if (countTowardOfflineState || msgSupplier != null) {
            LOG.log(level, e, () -> {
                String defaultMsg;
                String string = defaultMsg = countTowardOfflineState ? String.format("Caught exception (%s) for %s", this.caughtExceptionNumber, this.fullName) : "";
                if (msgSupplier != null) {
                    if (!defaultMsg.isEmpty()) {
                        defaultMsg = defaultMsg + "\n";
                    }
                    defaultMsg = defaultMsg + (String)msgSupplier.get();
                }
                return defaultMsg;
            });
        }
        if (this.caughtExceptionNumber >= this.numberOfConsectiveExceptionsToOffline) {
            this.setOnline(false);
        }
    }

    public boolean checkPsTripped() {
        if (!this.isOnline()) {
            return false;
        }
        try {
            int nReb = this.ps.getNumRebs();
            int fail = this.ps.getFailureSummary() & (1 << nReb) - 1;
            if (fail == this.lastFail) {
                return false;
            }
            this.lastFail = fail;
            if (fail == 0) {
                return false;
            }
            for (int reb = 0; reb < nReb; ++reb) {
                if ((fail & 1 << reb) == 0) continue;
                LOG.severe(String.format("REB PS %s tripped: %s", reb, this.ps.getFailureDetailString(reb)));
            }
            return true;
        }
        catch (DriverException e) {
            this.processCaughtException((Exception)((Object)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateBundle getRebPsDeviceState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.deviceAndRebsState.clone();
        }
    }

    public double[] getDacs(boolean getHV) {
        double[] dacs = new double[this.ps.getNumRebs()];
        int psNum = getHV ? 6 : 5;
        for (int reb = 0; reb < dacs.length; ++reb) {
            dacs[reb] = Double.NaN;
            try {
                if (!this.isOnline()) continue;
                dacs[reb] = this.ps.readChannel(reb, psNum, -1);
                continue;
            }
            catch (DriverException e) {
                this.processCaughtException((Exception)((Object)e), Level.SEVERE, () -> String.format("REB PS %s getDacs exception", this.fullName));
            }
        }
        return dacs;
    }

    public void setBiasDac(int rebNum, double value) throws PowerException {
        try {
            this.ps.writeDac(rebNum, 6, value);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void setDphiDac(int rebNum, double value) throws PowerException {
        try {
            this.ps.writeDac(rebNum, 5, value);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void setPowerOn(int reb, int psNum, boolean on) throws PowerException {
        if (psNum == -1 && on) {
            this.rebBeingPoweredOn = reb;
        }
        if (psNum == -1 && !on) {
            this.rebPowerStates.set(reb, RebPowerState.OFF);
        }
        if (psNum >= 0 && psNum != 6 && (this.psType != 1 || psNum != 5)) {
            return;
        }
        try {
            if (psNum < 0) {
                this.ps.setPower(reb, on ? 1 : 0);
            } else {
                int newValue;
                if (this.psType == 1 && reb % 3 == 2) {
                    return;
                }
                int value = this.ps.getPower(reb);
                if ((value & 1) == 0) {
                    return;
                }
                int mask = 1 << psNum + 1;
                int n = newValue = on ? value | mask : value & ~mask;
                if ((mask & (value ^ newValue)) == 0) {
                    return;
                }
                this.ps.setPower(reb, newValue);
            }
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage(), e);
        }
        finally {
            this.rebBeingPoweredOn = -1;
        }
        if (on) {
            this.forceDataPublicationForNextUpdateIterations();
        }
    }

    public void togglePower(int reb, int psNum) throws PowerException {
        try {
            int psn = psNum < 0 ? 0 : psNum + 1;
            this.setPowerOn(reb, psNum, (this.ps.getPower(reb) >> psn & 1) == 0);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void sequencePower(int reb, boolean on) throws PowerException {
        if (this.psVersion == 1) {
            this.setPowerOn(reb, -1, on);
            return;
        }
        try {
            SeqParams[] onSeq;
            if (this.psType == 1) {
                if (reb == 2) {
                    return;
                }
                onSeq = reb == 0 ? onSeqCR0 : onSeqCR1;
            } else {
                SeqParams[] seqParamsArray = onSeq = reb == 1 ? onSeqSR1 : onSeqSR02;
            }
            if (on) {
                this.ps.writeDac(reb, 6, 0.0);
                if (this.psType == 1) {
                    this.ps.writeDac(reb, 5, 4095.0);
                }
                for (SeqParams parm : onSeq) {
                    int effReb = reb + parm.rebOff;
                    int value = this.ps.getPower(effReb);
                    if ((value & 1) == 0) {
                        this.ps.setPower(effReb, value |= 1);
                    }
                    this.ps.setPower(effReb, value |= 1 << parm.psNum + 1);
                    if (this.checkPower(effReb, parm)) continue;
                    this.ps.setPower(effReb, value &= ~(1 << parm.psNum + 1));
                    throw new PowerException("REB " + effReb + " power supply " + parm.psNum + " failed to stabilize");
                }
            } else {
                this.ps.setPower(reb, this.ps.getPower(reb) & 0xFFFFFF7F & 0xFFFFFFBF);
                for (int j = onSeq.length - 1; j >= 0; --j) {
                    SeqParams parm = onSeq[j];
                    int effReb = reb + parm.rebOff;
                    int value = this.ps.getPower(effReb) & ~(1 << parm.psNum + 1);
                    this.ps.setPower(effReb, value);
                    if (value != 1) continue;
                    this.ps.setPower(effReb, 0);
                }
            }
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void sequencePower(boolean on) throws PowerException {
        for (int reb = 0; reb < this.ps.getNumRebs(); ++reb) {
            this.sequencePower(reb, on);
        }
    }

    public double[] readChanExtrema(int reb, PsName psName, ChanName chan) throws PowerException {
        try {
            double[] value = this.ps.readChanExtended(reb, psName.getValue(), chan.getValue());
            return new double[]{value[1], value[2]};
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void resetChanExtrema(int reb, PsName psName, ChanName chan) throws PowerException {
        try {
            this.ps.resetChanExtrema(reb, psName.getValue(), chan.getValue());
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void setListener(Event listen) {
        this.listener = listen;
    }

    public void clearListener() {
        this.listener = null;
    }

    public int[] getErrors() {
        return new int[]{this.ps.getNumTimeout(), this.ps.getNumSeqErr()};
    }

    public RebPS getPs() {
        return this.ps;
    }

    public int getPsType() {
        return this.psType;
    }

    public int getPsVersion() {
        return this.psVersion;
    }

    public String getPsId() {
        return this.psId;
    }

    private boolean checkPower(int reb, SeqParams parms) throws PowerException {
        boolean okay = false;
        int nGood = 0;
        for (int count = 0; count < 20 && !okay; ++count) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                double voltage = this.ps.readChannel(reb, parms.psNum, 4);
                nGood = voltage >= parms.minGood && voltage <= parms.maxGood ? nGood + 1 : 0;
                okay = nGood >= 3;
                continue;
            }
            catch (DriverException e) {
                throw new PowerException(e.getMessage());
            }
        }
        return okay;
    }

    private void generatePsId() throws DriverException {
        if (this.isSimulated) {
            this.psId = "PS-SIM";
            this.psType = this.simulatedPsType != -1 ? this.simulatedPsType : 0;
            return;
        }
        String serial = String.format("%016x", this.ps.getSerialNo());
        this.psId = this.props.getProperty("org.lsst.ccs.power.psid." + serial);
        if (this.psId == null) {
            if (this.ps.getNumRebs() == 3) {
                LOG.log(Level.WARNING, "Unknown PS serial number: {0}", serial);
                this.psId = serial.substring(5, 10);
            } else {
                this.psId = this.psType == 1 ? "CR-" : "SR-";
                try {
                    int id = Integer.valueOf(this.ipAddr.split("\\.")[3]);
                    this.psId = this.psId + String.format("%03d", id);
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    this.psId = this.psId + "XXX";
                }
            }
        }
        this.psType = this.psType == -1 ? (this.psId.substring(0, 2).equals("CR") ? 1 : 0) : this.psType;
    }

    private void forceDataPublicationForNextUpdateIterations() {
        for (MonitorUpdateTask task : this.tasksForDevice) {
            task.forceDataPublicationOnNextUpdates(this.nPowerOnPub);
        }
    }

    void setSimulatedPsType(int simulatedType) {
        if (!RunMode.isSimulation()) {
            throw new RuntimeException("What are you doing? This cannot be done unless in simulation!!!");
        }
        if (simulatedType != 1 && simulatedType != 0) {
            throw new RuntimeException("What are you doing? Setting simulated type to unknown value!!! " + simulatedType);
        }
        if (this.simulatedPsType == -1) {
            this.simulatedPsType = simulatedType;
        } else if (this.simulatedPsType != simulatedType) {
            throw new RuntimeException("What are you doing? Overriding already assigned value: " + this.simulatedPsType + " != " + simulatedType);
        }
    }

    @Command(name="dump", type=Command.CommandType.ACTION, level=1, description="Dump info about power supply")
    public String dumpInfo() throws DriverException {
        long serialNo = this.ps.getSerialNo();
        String buildStamp = this.ps.getBuildStamp();
        double fPGATemperature = this.ps.readFPGATemperature();
        double fPGAMinTemperature = this.ps.readMinFPGATemperature();
        double fPGAMaxTemperature = this.ps.readMaxFPGATemperature();
        int numSeqErr = this.ps.getNumSeqErr();
        int numTimeout = this.ps.getNumTimeout();
        return String.format("%s\n\tbuildStamp: %s\n\tserialNumber: %x\n\tfpga(temp,min,max): [%g,%g,%g]\n\tnumSeqErr: %d\n\tnumTimeout: %d", this.fullName, buildStamp, serialNo, fPGATemperature, fPGAMinTemperature, fPGAMaxTemperature, numSeqErr, numTimeout);
    }

    @Command(name="readReg", type=Command.CommandType.ACTION, level=1, description="Query one or more registers")
    public int[] readRegs(int addr, @Argument(defaultValue="1") int count) throws DriverException {
        return this.ps.readRegs(addr, count);
    }

    public String getBulkPsSwitchName() {
        return this.switchName;
    }

    private RebHvBiasState getRebHvBiasState(int powerState) {
        int hvBiasState = this.decodePowerState(powerState, RebPsEnum.HVBIAS);
        if (hvBiasState < 0) {
            return RebHvBiasState.UNKNOWN;
        }
        if (hvBiasState == 0) {
            return RebHvBiasState.OFF;
        }
        if (hvBiasState == 1) {
            return RebHvBiasState.ON;
        }
        throw new RuntimeException("Unknown HVBias state " + hvBiasState);
    }

    private RebDPhiState getRebDphiState(int powerState) {
        int dphiState = this.decodePowerState(powerState, RebPsEnum.DPHI);
        if (dphiState < 0) {
            return RebDPhiState.UNKNOWN;
        }
        if (dphiState == 0) {
            return RebDPhiState.OFF;
        }
        if (dphiState == 1) {
            return RebDPhiState.ON;
        }
        throw new RuntimeException("Unknown Dphi state " + dphiState);
    }

    private RebPowerState getRebPowerState(int powerState) {
        int pState = this.decodePowerState(powerState, RebPsEnum.MASTER);
        if (pState < 0) {
            return RebPowerState.UNKNOWN;
        }
        if (pState == 0) {
            return RebPowerState.OFF;
        }
        return RebPowerState.ON;
    }

    private int decodePowerState(int powerState, RebPsEnum id) {
        if (powerState < 0) {
            return -1;
        }
        int psNum = id.getNumber() + 1;
        int r = powerState >> psNum & 1;
        return r;
    }

    static {
        psMap.put("DIGITAL", 0);
        psMap.put("ANALOG", 1);
        psMap.put("CLOCKHI", 3);
        psMap.put("CLOCKLO", 4);
        psMap.put("DPHI", 5);
        psMap.put("HEATER", 5);
        psMap.put("HVBIAS", 6);
        psMap.put("OD", 2);
        psMap.put("POWER", 255);
        onSeqSR02 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 12.0, 17.0), new SeqParams(3, 15.0, 17.0), new SeqParams(2, 35.0, 42.0), new SeqParams(5, 7.0, 13.0)};
        onSeqSR1 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 12.0, 17.0), new SeqParams(3, 15.0, 17.0), new SeqParams(2, 35.0, 42.0)};
        onSeqCR0 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 10.0, 12.0), new SeqParams(3, 10.0, 12.0), new SeqParams(2, 35.0, 37.0), new SeqParams(0, 2, 5.0, 7.0)};
        onSeqCR1 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 10.0, 12.0), new SeqParams(3, 10.0, 12.0), new SeqParams(2, 35.0, 37.0)};
    }

    public static enum ChanName {
        VBEFLDO(0),
        VAFTLDO(2),
        IBEFLDO(1);

        int value;

        private ChanName(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum PsName {
        DIGITAL(0),
        ANALOG(1),
        CLOCKHI(3),
        CLOCKLO(4),
        OD(2),
        HEATER(5),
        DPHI(5);

        int value;

        private PsName(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static interface Event {
        public void opened();

        public void closed();
    }

    static class SeqParams {
        final int psNum;
        final int rebOff;
        final double minGood;
        final double maxGood;

        SeqParams(int psNum, double minGood, double maxGood) {
            this(psNum, 0, minGood, maxGood);
        }

        SeqParams(int psNum, int rebOff, double minGood, double maxGood) {
            this.psNum = psNum;
            this.rebOff = rebOff;
            this.minGood = minGood;
            this.maxGood = maxGood;
        }
    }
}

