/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcam.filterchanger;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.comcam.filterchanger.MotronaIV251Device;
import org.lsst.ccs.subsystem.comcam.filterchanger.NanotecPD4NDevice;
import org.lsst.ccs.subsystem.comcam.filterchanger.alerts.ComCamFCAlerts;
import org.lsst.ccs.subsystem.comcam.filterchanger.data.EndSetFilterData;
import org.lsst.ccs.subsystem.comcam.filterchanger.data.SetFilterData;
import org.lsst.ccs.subsystem.comcam.filterchanger.states.ComCamFCState;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class ComCamFilterChanger
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private NanotecPD4NDevice motor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private MotronaIV251Device encoder;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alert;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(ComCamFilterChanger.class.getName());
    private static final double encoderUnit = 0.005;
    private final Map<ComCamFCState, Integer> posMap = new ConcurrentHashMap<ComCamFCState, Integer>();
    private final Map<ComCamFCState, String> fNameMap = new ConcurrentHashMap<ComCamFCState, String>();
    private boolean initDone = false;
    private volatile boolean requestStop = false;
    private Thread checkMove;
    private volatile boolean moveSucceeded;
    private volatile Duration lastTimeEstimate;
    private volatile Duration lastTimeCorrection = Duration.ZERO;
    private long tsleepCorr;
    private static final String startKey = "startSetFilter";
    private static final String endKey = "endSetFilter";
    private static final Duration intervalTestMove = Duration.ofMillis(1000L);
    private static final double maxErrorToDoCorrection = 1.0;
    private final Object posLock = new Object();
    private final Object filtLock = new Object();
    @ConfigurationParameter(isFinal=true, maxLength=15, units="unitless", description="List of available filter types")
    protected volatile List<String> filterTypes = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, maxLength=30, units="unitless", description="Map of available filter names to types")
    protected volatile Map<String, String> filterNames = new LinkedHashMap<String, String>();
    @ConfigurationParameter(description="linear encoder target, filter 1", units="unitless")
    protected volatile Integer positionFilter1;
    @ConfigurationParameter(description="linear encoder target, filter 2", units="unitless")
    protected volatile Integer positionFilter2;
    @ConfigurationParameter(description="linear encoder target, filter 3", units="unitless")
    protected volatile Integer positionFilter3;
    @ConfigurationParameter(description="linear encoder target, load 1", units="unitless")
    protected volatile Integer positionLoad1;
    @ConfigurationParameter(description="linear encoder target, load 3", units="unitless")
    protected volatile Integer positionLoad3;
    @ConfigurationParameter(description="position tolerance in mm", units="mm")
    protected volatile Double tolerance;
    @ConfigurationParameter(description="name of filter in position 1", units="unitless")
    protected volatile String nameFilter1;
    @ConfigurationParameter(description="name of filter in position 2", units="unitless")
    protected volatile String nameFilter2;
    @ConfigurationParameter(description="name of filter in position 3", units="unitless")
    protected volatile String nameFilter3;

    public ComCamFilterChanger() {
        super("ccfcs", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void init() {
        ClearAlertHandler ccfcsClearAlertHandler = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                String alertId = alert.getAlertId();
                if (alertId.equals(ComCamFCAlerts.LIMIT_SWITCH.getId()) || alertId.equals(ComCamFCAlerts.POS_ERROR.getId()) || alertId.equals(ComCamFCAlerts.TIMEOUT.getId()) || alertId.equals(ComCamFCAlerts.STOPPED.getId()) || alertId.equals(ComCamFCAlerts.DRIVER_EX.getId())) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                if (alertId.equals(ComCamFCAlerts.MOTOR_FAULT.getId()) || alertId.equals(ComCamFCAlerts.MOTOR_OVERTEMP.getId())) {
                    return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
            }
        };
        this.alert.registerAlert(ComCamFCAlerts.LIMIT_SWITCH.newAlert(), ccfcsClearAlertHandler);
        this.alert.registerAlert(ComCamFCAlerts.POS_ERROR.newAlert(), ccfcsClearAlertHandler);
        this.alert.registerAlert(ComCamFCAlerts.MOTOR_FAULT.newAlert(), ccfcsClearAlertHandler);
        this.alert.registerAlert(ComCamFCAlerts.MOTOR_OVERTEMP.newAlert(), ccfcsClearAlertHandler);
        this.alert.registerAlert(ComCamFCAlerts.TIMEOUT.newAlert(), ccfcsClearAlertHandler);
        this.alert.registerAlert(ComCamFCAlerts.STOPPED.newAlert(), ccfcsClearAlertHandler);
        this.alert.registerAlert(ComCamFCAlerts.DRIVER_EX.newAlert(), ccfcsClearAlertHandler);
        this.stateService.registerState(ComCamFCState.class, "Filter-changer State", (Object)this);
        this.dataProviderDictionaryService.registerClass(SetFilterData.class, startKey);
        this.dataProviderDictionaryService.registerClass(EndSetFilterData.class, endKey);
        if (this.filterTypes == null || this.filterTypes.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"filterTypes", (String)"value is missing");
        }
        if (this.filterNames == null || this.filterNames.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"filterNames", (String)"value is missing");
        }
        Set<String> keys = this.filterNames.keySet();
        for (String key : keys) {
            if (this.filterTypes.contains(this.filterNames.get(key))) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)("Filter name " + key), (String)"does not map to valid type");
        }
        if (this.positionFilter1 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"positionFilter1", (String)"value is missing");
        }
        if (this.positionFilter2 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"positionFilter2", (String)"value is missing");
        }
        if (this.positionFilter3 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"positionFilter3", (String)"value is missing");
        }
        if (this.positionLoad1 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"positionLoad1", (String)"value is missing");
        }
        if (this.positionLoad3 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"positionLoad3", (String)"value is missing");
        }
        if (this.tolerance == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"value is missing");
        }
        if (this.nameFilter1 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"nameFilter1", (String)"value is missing");
        }
        if (!this.filterNames.containsKey(this.nameFilter1)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"nameFilter1", (String)(this.nameFilter1 + " is not a valid filter name"));
        }
        if (this.nameFilter2 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"nameFilter2", (String)"value is missing");
        }
        if (!this.filterNames.containsKey(this.nameFilter2)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"nameFilter2", (String)(this.nameFilter2 + " is not a valid filter name"));
        }
        if (this.nameFilter3 == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"nameFilter3", (String)"value is missing");
        }
        if (!this.filterNames.containsKey(this.nameFilter3)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"nameFilter3", (String)(this.nameFilter3 + " is not a valid filter name"));
        }
        this.posMap.put(ComCamFCState.POSITION_FILTER1, this.positionFilter1);
        this.posMap.put(ComCamFCState.POSITION_FILTER2, this.positionFilter2);
        this.posMap.put(ComCamFCState.POSITION_FILTER3, this.positionFilter3);
        this.posMap.put(ComCamFCState.POSITION_LOAD1, this.positionLoad1);
        this.posMap.put(ComCamFCState.POSITION_LOAD3, this.positionLoad3);
        this.fNameMap.put(ComCamFCState.POSITION_FILTER1, this.nameFilter1);
        this.fNameMap.put(ComCamFCState.POSITION_FILTER2, this.nameFilter2);
        this.fNameMap.put(ComCamFCState.POSITION_FILTER3, this.nameFilter3);
        LOG.info("Filter " + this.nameFilter1 + " is in filter position 1");
        LOG.info("Filter " + this.nameFilter2 + " is in filter position 2");
        LOG.info("Filter " + this.nameFilter3 + " is in filter position 3");
        this.initDone = true;
    }

    public void postInit() {
    }

    public void postStart() {
        if (!RunMode.isSimulation()) {
            if (!this.motor.isOnline()) {
                throw new RuntimeException("NanotecPD4N stepper motor not online");
            }
            if (!this.encoder.isOnline()) {
                throw new RuntimeException("MotronaIV251 encoder-converter not online");
            }
            try {
                this.findFCState();
            }
            catch (DriverException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.publishFCState(ComCamFCState.POSITION_OTHER, 0);
        }
        this.checkMove = new Thread("dummy"){};
    }

    public String vetoTransitionToNormalMode() {
        if (this.getFilter().equals("")) {
            return "Filter changer not positioned at a filter";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="positionFilter1")
    public void setPositionFilter1(Integer value) {
        if (this.initDone) {
            if (value == null || value <= 0) throw new IllegalArgumentException(this.name + ": improper value for positionFilter1, not changed");
            Object object = this.posLock;
            synchronized (object) {
                this.positionFilter1 = value;
                Integer old = this.posMap.replace(ComCamFCState.POSITION_FILTER1, value);
                LOG.info(this.name + " config: positionFilter1 changed from " + old + " to " + value);
                return;
            }
        } else {
            if (value == null || value <= 0) return;
            this.positionFilter1 = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="positionFilter2")
    public void setPositionFilter2(Integer value) {
        if (this.initDone) {
            if (value == null || value <= 0) throw new IllegalArgumentException(this.name + ": improper value for positionFilter2, not changed");
            Object object = this.posLock;
            synchronized (object) {
                this.positionFilter2 = value;
                Integer old = this.posMap.replace(ComCamFCState.POSITION_FILTER2, value);
                LOG.info(this.name + " config: positionFilter2 changed from " + old + " to " + value);
                return;
            }
        } else {
            if (value == null || value <= 0) return;
            this.positionFilter2 = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="positionFilter3")
    public void setPositionFilter3(Integer value) {
        if (this.initDone) {
            if (value == null || value <= 0) throw new IllegalArgumentException(this.name + ": improper value for positionFilter3, not changed");
            Object object = this.posLock;
            synchronized (object) {
                this.positionFilter3 = value;
                Integer old = this.posMap.replace(ComCamFCState.POSITION_FILTER3, value);
                LOG.info(this.name + " config: positionFilter3 changed from " + old + " to " + value);
                return;
            }
        } else {
            if (value == null || value <= 0) return;
            this.positionFilter3 = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="positionLoad1")
    public void setPositionLoad1(Integer value) {
        if (this.initDone) {
            if (value == null || value <= 0) throw new IllegalArgumentException(this.name + ": improper value for positionLoad1, not changed");
            Object object = this.posLock;
            synchronized (object) {
                this.positionLoad1 = value;
                Integer old = this.posMap.replace(ComCamFCState.POSITION_LOAD1, value);
                LOG.info(this.name + " config: positionLoad1 changed from " + old + " to " + value);
                return;
            }
        } else {
            if (value == null || value <= 0) return;
            this.positionLoad1 = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="positionLoad3")
    public void setPositionLoad3(Integer value) {
        if (this.initDone) {
            if (value == null || value <= 0) throw new IllegalArgumentException(this.name + ": improper value for positionLoad3, not changed");
            Object object = this.posLock;
            synchronized (object) {
                this.positionLoad3 = value;
                Integer old = this.posMap.replace(ComCamFCState.POSITION_LOAD3, value);
                LOG.info(this.name + " config: positionLoad3 changed from " + old + " to " + value);
                return;
            }
        } else {
            if (value == null || value <= 0) return;
            this.positionLoad3 = value;
        }
    }

    @ConfigurationParameterChanger(propertyName="tolerance")
    public void setTolerance(Double tol) {
        if (this.initDone) {
            if (tol == null || tol <= 0.0) {
                throw new IllegalArgumentException(this.name + ":  improper value for tolerance, not changed");
            }
            if (this.checkMove.isAlive()) {
                LOG.warning(this.name + ":  cannot change tolerance while move is in progress");
            } else {
                LOG.info("tolerance set to " + tol + " mm");
                this.tolerance = tol;
            }
        } else {
            this.tolerance = tol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="nameFilter1")
    public void setNameFilter1(String fname) {
        if (this.initDone) {
            if (fname == null || !this.filterNames.containsKey(fname)) {
                throw new IllegalArgumentException(this.name + " " + fname + " is not a valid filter name; showAllFilters to see choices");
            }
            Object object = this.filtLock;
            synchronized (object) {
                LOG.info("Filter " + fname + " is in filter position 1");
                this.nameFilter1 = fname;
                this.fNameMap.replace(ComCamFCState.POSITION_FILTER1, fname);
            }
        } else {
            this.nameFilter1 = fname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="nameFilter2")
    public void setNameFilter2(String fname) {
        if (this.initDone) {
            if (fname == null || !this.filterNames.containsKey(fname)) {
                throw new IllegalArgumentException(this.name + " " + fname + " is not a valid filter name; showAllFilters to see choices");
            }
            Object object = this.filtLock;
            synchronized (object) {
                LOG.info("Filter " + fname + " is in filter position 2");
                this.nameFilter2 = fname;
                this.fNameMap.replace(ComCamFCState.POSITION_FILTER2, fname);
            }
        } else {
            this.nameFilter2 = fname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="nameFilter3")
    public void setNameFilter3(String fname) {
        if (this.initDone) {
            if (fname == null || !this.filterNames.containsKey(fname)) {
                throw new IllegalArgumentException(this.name + " " + fname + " is not a valid filter name; showAllFilters to see choices");
            }
            Object object = this.filtLock;
            synchronized (object) {
                LOG.info("Filter " + fname + " is in filter position 3");
                this.nameFilter3 = fname;
                this.fNameMap.replace(ComCamFCState.POSITION_FILTER3, fname);
            }
        } else {
            this.nameFilter3 = fname;
        }
    }

    private ComCamFCState getFilterState(String filterName) {
        if (filterName.equals(this.fNameMap.get(ComCamFCState.POSITION_FILTER1))) {
            return ComCamFCState.POSITION_FILTER1;
        }
        if (filterName.equals(this.fNameMap.get(ComCamFCState.POSITION_FILTER2))) {
            return ComCamFCState.POSITION_FILTER2;
        }
        if (filterName.equals(this.fNameMap.get(ComCamFCState.POSITION_FILTER3))) {
            return ComCamFCState.POSITION_FILTER3;
        }
        return null;
    }

    private void publishFCState(ComCamFCState state, int position) {
        this.stateService.updateAgentState(new Enum[]{state});
        String msg = this.name + " state changed to " + state;
        if (state.isFilterPosition()) {
            String fname = "";
            int fslot = 0;
            if (state == ComCamFCState.POSITION_FILTER1) {
                fname = this.nameFilter1;
                fslot = 1;
            } else if (state == ComCamFCState.POSITION_FILTER2) {
                fname = this.nameFilter2;
                fslot = 2;
            } else if (state == ComCamFCState.POSITION_FILTER3) {
                fname = this.nameFilter3;
                fslot = 3;
            }
            String ftype = this.filterNames.get(fname);
            double fpos = 0.005 * (double)position;
            EndSetFilterData data = new EndSetFilterData(fname, ftype, fslot, fpos);
            KeyValueDataList kvd = new KeyValueDataList();
            kvd.addData(endKey, (Serializable)data);
            this.agent.publishSubsystemDataOnStatusBus((KeyValueData)kvd);
            msg = msg + " (filter " + fname + ")";
        }
        LOG.info(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findFCState() throws DriverException {
        int tol = (int)(this.tolerance / 0.005);
        int position = this.encoder.readPosition();
        Object object = this.posLock;
        synchronized (object) {
            ComCamFCState state = Math.abs(position - this.posMap.get(ComCamFCState.POSITION_FILTER1)) <= tol ? ComCamFCState.POSITION_FILTER1 : (Math.abs(position - this.posMap.get(ComCamFCState.POSITION_FILTER2)) <= tol ? ComCamFCState.POSITION_FILTER2 : (Math.abs(position - this.posMap.get(ComCamFCState.POSITION_FILTER3)) <= tol ? ComCamFCState.POSITION_FILTER3 : (Math.abs(position - this.posMap.get(ComCamFCState.POSITION_LOAD1)) <= tol ? ComCamFCState.POSITION_LOAD1 : (Math.abs(position - this.posMap.get(ComCamFCState.POSITION_LOAD3)) <= tol ? ComCamFCState.POSITION_LOAD3 : ComCamFCState.POSITION_OTHER))));
            if (state != this.stateService.getState(ComCamFCState.class)) {
                this.publishFCState(state, position);
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showAllFilters", description="show all defined filters")
    public String showAllFilters() {
        String fnames = "Defined filter (type):\n";
        for (String key : this.filterNames.keySet()) {
            fnames = fnames + "    " + key + " (" + this.filterNames.get(key) + ")\n";
        }
        return fnames;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="getAllFilters", description="get map of filter names,types")
    public Map<String, String> getAllFilters() {
        return this.filterNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, level=0, name="showInstalledFilters", description="show installed filters")
    public String showInstalledFilters() {
        String flist = "Installed Filters\n";
        Object object = this.filtLock;
        synchronized (object) {
            flist = flist + "    1  " + this.nameFilter1 + "\n    2  " + this.nameFilter2 + "\n    3  " + this.nameFilter3 + "\n";
        }
        return flist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, level=0, name="getInstalledFilters", description="List of installed filters")
    public List<String> getInstalledFilters() {
        ArrayList<String> installedFilters = new ArrayList<String>();
        Object object = this.filtLock;
        synchronized (object) {
            installedFilters.add(this.nameFilter1);
            installedFilters.add(this.nameFilter2);
            installedFilters.add(this.nameFilter3);
        }
        return installedFilters;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showFilterState", description="show current state, and filter name, if any")
    public String showState() {
        ComCamFCState state = (ComCamFCState)this.stateService.getState(ComCamFCState.class);
        String fname = "";
        if (state == ComCamFCState.POSITION_FILTER1) {
            fname = this.nameFilter1;
        } else if (state == ComCamFCState.POSITION_FILTER2) {
            fname = this.nameFilter2;
        } else if (state == ComCamFCState.POSITION_FILTER3) {
            fname = this.nameFilter3;
        }
        return state + "   " + fname;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="getFilter", description="return current filter name, if any")
    public String getFilter() {
        ComCamFCState state = (ComCamFCState)this.stateService.getState(ComCamFCState.class);
        String fname = "";
        if (state == ComCamFCState.POSITION_FILTER1) {
            fname = this.nameFilter1;
        } else if (state == ComCamFCState.POSITION_FILTER2) {
            fname = this.nameFilter2;
        } else if (state == ComCamFCState.POSITION_FILTER3) {
            fname = this.nameFilter3;
        }
        return fname;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setFCState", autoAck=false, description="find FC state, and publish if changed")
    public void setFCState() throws DriverException {
        this.helper().precondition(!this.checkMove.isAlive(), this.name + " move in progress", new Object[0]).precondition(this.stateService.getState(ComCamFCState.class) != ComCamFCState.POSITION_MOVING, " cannot set state if previous state is MOVING", new Object[0]).action(() -> this.findFCState());
    }

    @Command(type=Command.CommandType.QUERY, name="showEstimatedDuration", description="show estimate of the time a move would take", level=0)
    public String showEstimatedDuration(@Argument(name="distance", description="distance in mm for estimnation") double distance) {
        try (ConfigurationService.ConfigurationLock lock = this.configService.acquireConfigurationLock();){
            Duration estimate = this.motor.getTimeEstimate(distance);
            String string = Long.toString(estimate.toMillis()) + " ms";
            return string;
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, name="stopMotor", description="set flag to stop motion", autoAck=false)
    public void stopMotor() {
        this.helper().precondition(this.stateService.getState(ComCamFCState.class) == ComCamFCState.POSITION_MOVING, this.name + " not currently moving", new Object[0]).action(() -> {
            this.requestStop = true;
        });
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="moveByDistance", description="move by specified distance", autoAck=false)
    public void moveByDistance(@Argument(name="distance", description="signed distance in mm") double distance) throws DriverException {
        this.helper().precondition(!this.checkMove.isAlive(), this.name + " move in progress", new Object[0]).action(() -> this.move(distance));
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="moveToPosition", description="move to predefined position", autoAck=false)
    public void moveToPosition(@Argument(name="position", description="ComCamFCState representing a position") ComCamFCState position) throws DriverException {
        this.helper().precondition(!this.checkMove.isAlive(), this.name + " move in progress", new Object[0]).precondition(position.isKnownPosition(), "requested state not a specific position", new Object[0]).precondition(position != this.stateService.getState(ComCamFCState.class), "already in state " + position.toString(), new Object[0]).action(() -> {
            Integer d = this.posMap.get(position) - this.encoder.readPosition();
            double distance = (double)d.intValue() * 0.005;
            this.move(distance);
        });
    }

    @Command(type=Command.CommandType.ACTION, level=0, name="goToFilter", description="move to specified filter", autoAck=false)
    public void goToFilter(@Argument(name="position", description="name of filter") String filterName) throws DriverException {
        this.helper().precondition(!this.checkMove.isAlive(), this.name + " move in progress", new Object[0]).precondition(this.fNameMap.containsValue(filterName), "not an installed filter, issue showInstalledFilters", new Object[0]).precondition(this.getFilterState(filterName) != this.stateService.getState(ComCamFCState.class), "changer already positioned at " + filterName, new Object[0]).action(() -> {
            String filterType = this.filterNames.get(filterName);
            SetFilterData data = new SetFilterData(filterName, filterType);
            KeyValueDataList kvd = new KeyValueDataList();
            kvd.addData(startKey, (Serializable)data);
            this.agent.publishSubsystemDataOnStatusBus((KeyValueData)kvd);
            ComCamFCState position = this.getFilterState(filterName);
            Integer d = this.posMap.get(position) - this.encoder.readPosition();
            double distance = (double)d.intValue() * 0.005;
            this.move(distance);
        });
    }

    private void move(final double distance) throws DriverException {
        this.lastTimeEstimate = this.motor.getTimeEstimate(distance).plusSeconds(3L);
        this.lastTimeCorrection = Duration.ZERO;
        this.moveSucceeded = false;
        final int goal = this.encoder.readPosition() + (int)(distance / 0.005);
        this.requestStop = false;
        this.motor.move(distance);
        this.publishFCState(ComCamFCState.POSITION_MOVING, 0);
        this.checkMove = new Thread("checkMove"){

            @Override
            public void run() {
                block9: {
                    long timeStart = System.currentTimeMillis();
                    long timeoutTime = timeStart + ComCamFilterChanger.this.lastTimeEstimate.toMillis();
                    do {
                        try {
                            Thread.sleep(intervalTestMove.toMillis());
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException("Unexpected interrupt while waiting for motion to complete ", ex);
                        }
                        try {
                            if (!ComCamFilterChanger.this.moveComplete(goal)) continue;
                            ComCamFilterChanger.this.findFCState();
                        }
                        catch (DriverException ex) {
                            try {
                                ComCamFilterChanger.this.motor.stopQ();
                            }
                            catch (DriverException driverException) {
                                // empty catch block
                            }
                            ComCamFilterChanger.this.alert.raiseAlert(ComCamFCAlerts.DRIVER_EX.newAlert(), AlertState.ALARM, ex.toString());
                            ComCamFilterChanger.this.publishFCState(ComCamFCState.POSITION_OTHER, 0);
                        }
                        break block9;
                    } while (System.currentTimeMillis() <= timeoutTime);
                    try {
                        ComCamFilterChanger.this.motor.stopQ();
                    }
                    catch (DriverException ex) {
                        // empty catch block
                    }
                    String msg = String.format("Move of %5.3f m timed out after %d ms", distance / 1000.0, timeoutTime);
                    ComCamFilterChanger.this.alert.raiseAlert(ComCamFCAlerts.TIMEOUT.newAlert(), AlertState.ALARM, msg);
                    ComCamFilterChanger.this.publishFCState(ComCamFCState.POSITION_OTHER, 0);
                }
            }
        };
        this.checkMove.setDaemon(true);
        this.checkMove.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean moveComplete(int goal) throws DriverException {
        boolean isCorrection = false;
        if (this.motor.getReadyFlag()) {
            if (this.requestStop) {
                LOG.info(this.name + " Motion has ended, so Stop command ignored");
                this.requestStop = false;
            }
            double diff = (double)(goal - this.encoder.readPosition()) * 0.005;
            LOG.info(this.name + String.format(": Goal - position = %f mm", diff));
            if (Math.abs(diff) > this.tolerance && Math.abs(diff) <= 1.0) {
                LOG.info(this.name + String.format(": applying correction move", new Object[0]));
                try (ConfigurationService.ConfigurationLock lock = this.configService.acquireConfigurationLock();){
                    this.lastTimeCorrection = this.motor.getTimeEstimate(diff).plusSeconds(1L);
                    this.tsleepCorr = this.lastTimeCorrection.toMillis();
                    this.motor.move(diff);
                }
                try {
                    Thread.sleep(this.tsleepCorr);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException("Unexpected interrupt while waiting for motion to complete ", ex);
                }
                diff = (double)(goal - this.encoder.readPosition()) * 0.005;
                LOG.info(this.name + String.format(": Goal - position = %f mm", diff));
                isCorrection = true;
            }
            if (Math.abs(diff) > this.tolerance) {
                String msg = String.format("position after move off by %f mm", -diff);
                this.alert.raiseAlert(ComCamFCAlerts.POS_ERROR.newAlert(), AlertState.ALARM, msg);
                return true;
            }
            if (!isCorrection) {
                this.moveSucceeded = true;
                return true;
            }
        }
        if (this.motor.getLimitSwitches() != 0) {
            String location = Integer.toString(this.encoder.readPosition());
            this.motor.resetError();
            this.motor.moveBackOff();
            this.alert.raiseAlert(ComCamFCAlerts.LIMIT_SWITCH.newAlert(), AlertState.ALARM, "encoder = " + location);
        } else if (this.motor.getMotorError()) {
            this.motor.resetError();
            this.alert.raiseAlert(ComCamFCAlerts.MOTOR_FAULT.newAlert(), AlertState.ALARM, "code(s): " + this.motor.decodeLastError());
        } else if (this.motor.getPosError()) {
            String location = Integer.toString(this.encoder.readPosition());
            this.motor.resetError();
            this.alert.raiseAlert(ComCamFCAlerts.POS_ERROR.newAlert(), AlertState.ALARM, "unexplained, encoder = " + location);
        } else if (!isCorrection) {
            if (!this.requestStop) return false;
            this.motor.stopQ();
            this.alert.raiseAlert(ComCamFCAlerts.STOPPED.newAlert(), AlertState.ALARM, "stopped");
        } else {
            this.moveSucceeded = true;
        }
        this.requestStop = false;
        return true;
    }

    @Command(type=Command.CommandType.ACTION, level=0, autoAck=false, name="waitForMove", description="Wait until move is complete")
    public void waitForMove() throws InterruptedException {
        this.helper().precondition(this.lastTimeEstimate != null, "No move since lasr waitFor", new Object[0]).duration(this.lastTimeEstimate.plus(this.lastTimeCorrection).plusSeconds(1L)).enterFaultOnException(true).action(() -> {
            Duration waitTime = this.lastTimeEstimate.plus(this.lastTimeCorrection).plusSeconds(1L);
            boolean ok = this.stateService.waitFor(t -> !t.isInState((Enum)ComCamFCState.POSITION_MOVING), waitTime.toMillis(), TimeUnit.MILLISECONDS);
            this.lastTimeEstimate = null;
            if (!this.moveSucceeded) {
                throw new RuntimeException("move failed, check Alerts for reason");
            }
            if (!ok) {
                throw new TimeoutException("waitForMove timed out");
            }
        });
    }
}

