/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.mmm.GenericMMM;
import org.lsst.ccs.subsystem.mmm.MMMUtilities;
import org.lsst.ccs.subsystem.mmm.MinionGroup;

public class AlertDispatcher
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    GenericMMM mmm;
    @LookupName
    String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected Map<String, AlertHandler> handlers = new HashMap<String, AlertHandler>();
    @ConfigurationParameter
    public volatile boolean isEnabled = true;
    private MMMUtilities mu;
    @ConfigurationParameter(isFinal=true)
    private volatile MinionGroup group;
    private String groupName;
    private static org.lsst.ccs.utilities.logging.Logger log = org.lsst.ccs.utilities.logging.Logger.getLogger((String)"org.lsst.ccs.subsystem.mmm");

    public AlertDispatcher() {
        this(null);
    }

    AlertDispatcher(MMMUtilities mu2) {
        this.mu = mu2;
    }

    public MMMUtilities getMmmUtilities() {
        return this.mu;
    }

    public void postInit() {
        if (this.mmm != null) {
            if (this.mu != null) {
                throw new RuntimeException("**** Something went very wrong. This AlertDispatcher has already been initialized");
            }
            this.mu = this.mmm.getMmmUtilities();
        }
        if (this.group == null) {
            throw new IllegalArgumentException("The group for this dispatcher should have been defined by now");
        }
        this.groupName = this.group.name();
    }

    @Command
    public String status() {
        return this.status("");
    }

    String status(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("Name     : ").append(this.isEnabled).append("\n");
        sb.append(indent).append("Enabled  : ").append(this.isEnabled).append("\n");
        sb.append(indent).append("Group    : ").append((Object)this.group).append("\n");
        sb.append(indent).append("Handlers :\n");
        for (AlertHandler h : this.handlers.values()) {
            sb.append(h.status(indent + "\t"));
        }
        return sb.toString();
    }

    public Enum getGroup() {
        return this.group;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void onAlert(AlertNotification notif) {
        if (this.isEnabled) {
            for (AlertHandler h : this.handlers.values()) {
                h.onAlert(notif);
            }
        }
    }

    public static org.lsst.ccs.utilities.logging.Logger getLogger() {
        return log;
    }

    private void addHandler(AlertHandler h) {
        this.handlers.put(h.getName(), h);
    }

    @Command
    public AlertHandler setOriginSelector(String handlerName, String origin) {
        AlertHandler h = this.handlers.get(handlerName);
        h.setOriginSelector(origin);
        return h;
    }

    @Command
    public AlertHandler setOriginAndAlertIdSelector(String handlerName, String origin, String alertId) {
        AlertHandler h = this.handlers.get(handlerName);
        h.setOriginAndAlertIdSelector(origin, alertId);
        return h;
    }

    @Command
    public String[] getAlertHandlers() {
        return this.handlers.keySet().toArray(new String[0]);
    }

    public static class EmailAlertAction
    extends AlertAction {
        @ConfigurationParameter(isFinal=true)
        protected volatile String fromEmail = "mmm@no-reply.org";
        @ConfigurationParameter(isFinal=true)
        protected volatile String replyToEmail = null;
        @ConfigurationParameter(isFinal=true)
        protected volatile String smtpHost = "smtpunix.slac.stanford.edu";
        @ConfigurationParameter(maxLength=10)
        public volatile List<String> emailList = new ArrayList<String>();
        @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
        private List<EmailAlertDeliveryStrategy> strategies = new ArrayList<EmailAlertDeliveryStrategy>();
        @LookupField(strategy=LookupField.Strategy.ANCESTORS)
        private AlertDispatcher dispatcher;
        @ConfigurationParameter(isFinal=true)
        volatile String filePath = null;
        File file = null;
        long lastModified;
        private InternetAddress[] addressFromConfig = new InternetAddress[0];
        private InternetAddress[] addressFromFile = new InternetAddress[0];
        private InternetAddress[] allTheAddresses;
        Session session;
        InternetAddress fromAddress;

        @Override
        public String getDescription() {
            String description = "Email notification to configuration list [";
            for (InternetAddress email : this.addressFromConfig) {
                description = description + email.getAddress() + ", ";
            }
            description = description.substring(0, description.length() - 2);
            description = description + "]";
            if (this.filePath != null) {
                description = " list from file (" + this.filePath + ") [";
                for (InternetAddress email : this.addressFromFile) {
                    description = description + email.getAddress() + ", ";
                }
                description = description.substring(0, description.length() - 2);
                description = description + "]";
            }
            return description;
        }

        public void init() {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.smtpHost);
            this.session = Session.getInstance((Properties)props, null);
            if (this.strategies.isEmpty()) {
                this.strategies.add(new EmailAlertDeliveryStrategy());
            }
            for (EmailAlertDeliveryStrategy strategy : this.strategies) {
                strategy.alertAction = this;
            }
            try {
                this.fromAddress = new InternetAddress(this.fromEmail);
            }
            catch (AddressException e) {
                log.error((Object)("Error while parsing address " + this.fromEmail), (Throwable)e);
                throw new RuntimeException("Error while parsing address " + this.fromEmail, e);
            }
            if (this.filePath != null) {
                try {
                    this.file = new File(this.filePath);
                    this.updateEmailListFromFile(this.file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @ConfigurationParameterChanger(propertyName="emailList")
        public final void setEmailList(List<String> emails) {
            this.addressFromConfig = this.getAddressesFromList(emails);
            this.updateAllTheAddresses();
            this.emailList.clear();
            this.emailList.addAll(emails);
        }

        private InternetAddress[] getAddressesFromList(List<String> emails) {
            InternetAddress[] tmpArray = new InternetAddress[emails.size()];
            int count = 0;
            for (String email : emails) {
                try {
                    tmpArray[count++] = new InternetAddress(email);
                }
                catch (AddressException e) {
                    log.error((Object)("Error while parsing address " + email), (Throwable)e);
                    throw new RuntimeException("Error while parsing address " + email, e);
                }
            }
            return tmpArray;
        }

        private synchronized void updateAllTheAddresses() {
            ArrayList<InternetAddress> list = new ArrayList<InternetAddress>(Arrays.asList(this.addressFromConfig));
            list.addAll(Arrays.asList(this.addressFromFile));
            this.allTheAddresses = list.toArray(new InternetAddress[list.size()]);
        }

        private void updateEmailListFromFile(File f) {
            if (this.lastModified != this.file.lastModified()) {
                log.info((Object)("Updating email list form " + f.getAbsolutePath() + " " + f.lastModified()));
                try {
                    String line;
                    FileInputStream fis = new FileInputStream(f);
                    InputStreamReader in = new InputStreamReader(fis);
                    BufferedReader reader = new BufferedReader(in);
                    ArrayList<String> addresses = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        int indx = (line = line.trim()).indexOf("#");
                        if (indx > -1) {
                            line = line.substring(0, indx);
                            line = line.trim();
                        }
                        addresses.add(line);
                    }
                    this.addressFromFile = this.getAddressesFromList(addresses);
                    this.updateAllTheAddresses();
                    this.lastModified = f.lastModified();
                }
                catch (IOException fnf) {
                    fnf.printStackTrace();
                }
            }
        }

        @Override
        public void accept(AlertNotification notif) {
            if (this.file != null && this.file.exists()) {
                this.updateEmailListFromFile(this.file);
            }
            for (EmailAlertDeliveryStrategy strategy : this.strategies) {
                if (!strategy.processAlertNotification(notif)) continue;
                return;
            }
        }

        void sendEmailMessage(String subject, String text) {
            try {
                MimeMessage msg = new MimeMessage(this.session);
                msg.setFrom((Address)this.fromAddress);
                msg.setRecipients(Message.RecipientType.TO, (Address[])this.allTheAddresses);
                if (this.replyToEmail != null) {
                    InternetAddress replyTo = new InternetAddress(this.replyToEmail);
                    msg.setReplyTo((Address[])new InternetAddress[]{replyTo});
                }
                msg.setSubject(subject);
                msg.setText(text);
                msg.setSentDate(new Date());
                Transport.send((Message)msg);
            }
            catch (MessagingException e) {
                log.error((Object)("Failed sending email " + (Object)((Object)e)), (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public static class EmailAlertDeliveryStrategy {
        private DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss dd MMM yyyy");
        @ConfigurationParameter(isFinal=true)
        public volatile boolean sendFirstEmail = true;
        @ConfigurationParameter(isFinal=true)
        public volatile Duration maxAccumulation = Duration.ofMinutes(0L);
        @ConfigurationParameter(isFinal=true)
        public volatile String origin = "";
        private final List<AlertNotification> notifications = new CopyOnWriteArrayList<AlertNotification>();
        private Timer timer = new Timer();
        private TimerTask emailNotificationTimerTask;
        private static final Logger LOG = Logger.getLogger(EmailAlertDeliveryStrategy.class.getName());
        private EmailAlertAction alertAction;

        private void sendEmailNow(boolean clearTask) {
            String subject;
            if (clearTask) {
                this.emailNotificationTimerTask = null;
            }
            if (this.notifications.isEmpty()) {
                return;
            }
            LOG.log(Level.FINEST, "Sending Email notification with {0} notifications ({1},{2})", new Object[]{this.notifications.size(), this.sendFirstEmail, this.maxAccumulation});
            if (this.notifications.size() == 1) {
                AlertNotification notif = this.notifications.get(0);
                subject = "CCS Alert " + notif.getSeverity() + " " + notif.getOrigin() + " " + notif.getAlert().getAlertId();
            } else {
                subject = "CCS Alert Digest for group: " + this.alertAction.dispatcher.getGroupName() + ": " + this.notifications.size() + " notifications over " + this.maxAccumulation.toMinutes() + " minutes";
            }
            String text = "";
            for (AlertNotification notif : this.notifications) {
                LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(notif.getTimestamp()), ZoneId.systemDefault());
                text = text + "CCS Alert " + notif.getSubsystemGroup().name() + "\n  origin:   " + notif.getOrigin() + "\n  cause:    " + notif.getCause() + "\n  id:       " + notif.getAlert().getAlertId() + "\n  severity: " + notif.getSeverity() + "\n  descr:    " + notif.getAlert().getDescription() + "\n  time:     " + date.format(this.dtf) + "\n";
            }
            LOG.log(Level.FINE, "Sending email: \n{0}\n{1}", new Object[]{subject, text});
            this.alertAction.sendEmailMessage(subject, text);
            this.notifications.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processAlertNotification(AlertNotification notif) {
            if (this.origin.isEmpty() || notif.getOrigin().matches(this.origin)) {
                List<AlertNotification> list = this.notifications;
                synchronized (list) {
                    this.notifications.add(notif);
                    if (this.emailNotificationTimerTask == null) {
                        if (this.maxAccumulation.getSeconds() > 0L) {
                            this.emailNotificationTimerTask = new TimerTask(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    List list = notifications;
                                    synchronized (list) {
                                        this.sendEmailNow(true);
                                    }
                                }
                            };
                            this.timer.schedule(this.emailNotificationTimerTask, this.maxAccumulation.toMillis());
                        }
                        if (this.sendFirstEmail) {
                            this.sendEmailNow(false);
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class AlertAction
    implements Consumer<AlertNotification>,
    Predicate<AlertNotification>,
    HasLifecycle {
        final org.lsst.ccs.utilities.logging.Logger ACTION_LOG = org.lsst.ccs.utilities.logging.Logger.getLogger((String)"org.lsst.ccs.mmm.action");
        @LookupName
        String name;
        @ConfigurationParameter
        public volatile boolean enabled = true;

        protected org.lsst.ccs.utilities.logging.Logger getLogger() {
            return this.ACTION_LOG;
        }

        @Command
        public String status() {
            return this.status("");
        }

        String status(String indent) {
            StringBuilder sb = new StringBuilder();
            sb.append(indent).append("Name        : ").append(this.name).append("\n");
            sb.append(indent).append("Enabled     : ").append(this.enabled).append("\n");
            sb.append(indent).append("Description : ").append(this.getDescription()).append("\n");
            return sb.toString();
        }

        public abstract String getDescription();

        @Override
        public boolean test(AlertNotification notif) {
            return true;
        }
    }

    public static class AlertHandler {
        @LookupName
        String handlerName;
        @ConfigurationParameter
        public volatile boolean enabled = true;
        @LookupField(strategy=LookupField.Strategy.CHILDREN)
        List<AlertAction> actions = new ArrayList<AlertAction>();
        Predicate<AlertNotification> selector;

        public String getName() {
            return this.handlerName;
        }

        public AlertHandler setSelector(Predicate<AlertNotification> selector) {
            this.selector = selector;
            return this;
        }

        public AlertHandler orSelector(Predicate<AlertNotification> or) {
            this.selector = this.selector == null ? or : this.selector.or(or);
            return this;
        }

        public AlertHandler andSelector(Predicate<AlertNotification> and) {
            this.selector = this.selector == null ? and : this.selector.and(and);
            return this;
        }

        public Predicate<AlertNotification> originSelector(String origin) {
            return a -> a.getOrigin().equals(origin);
        }

        public Predicate<AlertNotification> alertIdSelector(String id) {
            return a -> a.getAlert().getAlertId().equals(id);
        }

        public Predicate<AlertNotification> alertLevelSelector(AlertState severity) {
            return a -> a.getSeverity().ordinal() >= severity.ordinal();
        }

        public AlertHandler setOriginSelector(String origin) {
            return this.setSelector(this.originSelector(origin));
        }

        public AlertHandler setOriginAndAlertIdSelector(String origin, String alertId) {
            return this.setSelector(this.originSelector(origin).and(this.alertIdSelector(alertId)));
        }

        @Command
        public String status() {
            return this.status("");
        }

        String status(String indent) {
            StringBuilder sb = new StringBuilder();
            sb.append(indent).append("Name     : ").append(this.handlerName).append("\n");
            sb.append(indent).append("Enabled  : ").append(this.enabled).append("\n");
            sb.append(indent).append("Selector : ").append(this.selector).append("\n");
            sb.append(indent).append("Actions  :\n");
            if (this.actions.size() > 0) {
                for (AlertAction h : this.actions) {
                    sb.append(h.status(indent + "\t"));
                }
            } else {
                sb.append(indent).append("\tNone defined");
            }
            sb.append("\n");
            return sb.toString();
        }

        public void onAlert(AlertNotification notif) {
            if (!this.enabled) {
                return;
            }
            if (this.selector != null && !this.selector.test(notif)) {
                return;
            }
            boolean processed = false;
            for (AlertAction a : this.actions) {
                if (processed) {
                    return;
                }
                if (!a.enabled || !a.test(notif)) continue;
                try {
                    a.accept(notif);
                    processed = true;
                }
                catch (Throwable e) {
                    log.error((Object)("Error handling action " + e), e);
                    e.printStackTrace();
                }
            }
        }
    }
}

