/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.drivers.bk.Model9130;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class BK9130GroupDevice
extends PowerDevice {
    private final Model9130 ps;
    private final double[] outVoltages = new double[3];
    private final double[] outCurrents = new double[3];
    private final boolean[] outOutputs = new boolean[3];
    private double[] inVoltages;
    private double[] inCurrents;
    private boolean[] inOutputs;
    private DriverException voltageException;
    private DriverException currentException;
    private DriverException outputException;

    public BK9130GroupDevice() {
        super("B&K 9130 PS", (PowerSupplyDriver)new Model9130(), 1, 0, 3);
        this.ps = (Model9130)this.psd;
    }

    @Override
    protected void writeVoltage(double voltage, int hwChan) {
        this.outVoltages[hwChan - 1] = voltage;
    }

    @Override
    protected double readVoltage(int hwChan) throws PowerException {
        if (this.voltageException != null) {
            this.handleException(this.voltageException);
        }
        return this.inVoltages[hwChan - 1];
    }

    @Override
    protected void writeCurrent(double current, int hwChan) {
        this.outCurrents[hwChan - 1] = current;
    }

    @Override
    protected double readCurrent(int hwChan) throws PowerException {
        if (this.currentException != null) {
            this.handleException(this.currentException);
        }
        return this.inCurrents[hwChan - 1];
    }

    @Override
    protected void writeOutput(boolean onState, int hwChan) {
        this.outOutputs[hwChan - 1] = onState;
    }

    @Override
    protected boolean readOutput(int hwChan) throws PowerException {
        if (this.outputException != null) {
            this.handleException(this.outputException);
        }
        return this.inOutputs[hwChan - 1];
    }

    @Override
    protected void readVoltageGroup() {
        try {
            this.inVoltages = this.ps.readVoltage();
            this.voltageException = null;
        }
        catch (DriverException e) {
            this.voltageException = e;
        }
    }

    @Override
    protected void writeVoltageGroup() throws DriverException {
        this.ps.setVoltage(this.outVoltages);
    }

    @Override
    protected void readCurrentGroup() {
        try {
            this.inCurrents = this.ps.readCurrent();
            this.currentException = null;
        }
        catch (DriverException e) {
            this.currentException = e;
        }
    }

    @Override
    protected void writeCurrentGroup() throws DriverException {
        this.ps.setCurrent(this.outCurrents);
    }

    @Override
    protected void readOutputGroup() {
        try {
            this.inOutputs = this.ps.getOutput();
            this.outputException = null;
        }
        catch (DriverException e) {
            this.outputException = e;
        }
    }

    @Override
    protected void writeOutputGroup() throws DriverException {
        this.ps.setOutput(this.outOutputs);
    }
}

