/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.MpmPlutoDevice;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.MpmAlert;
import org.lsst.ccs.subsystem.utility.constants.MpmLatches;
import org.lsst.ccs.subsystem.utility.constants.MpmSwitches;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class ComCamMpmMain
extends Subsystem
implements HasLifecycle,
AlertListener {
    private static final Map<Integer, MpmAlert> alertMap = new HashMap<Integer, MpmAlert>();
    private static final Map<String, String> revAlertMap;
    private static final MpmAlert[] plcAlerts;
    private static final String[] plcNames;
    private static final int[] plcID;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MpmPlutoDevice plutoDevc;
    private static final Logger LOG;
    private final MpmSysState mpmState = new MpmSysState();
    private boolean running = false;
    private boolean switchChanged = false;

    public ComCamMpmMain() {
        super("comcam-mpm", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("Protection-state", () -> this.updateMpmState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void init() {
        for (MpmAlert alert : plcAlerts) {
            this.alertService.registerAlert(alert.getAlert());
        }
        for (MpmAlert alert : alertMap.values()) {
            this.alertService.registerAlert(alert.getAlert());
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("mpmType", ComCamMpmMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        if (this.plutoDevc != null) {
            int cond;
            for (cond = 0; cond < 11; ++cond) {
                this.mpmState.setLatch(cond, LatchState.CLEAR);
            }
            for (cond = 0; cond < 7; ++cond) {
                this.mpmState.setCondition(cond, ConditionState.NO);
            }
        } else {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
    }

    public void postStart() {
        LOG.info("Protection subsystem started");
        this.running = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the protection system state")
    public MpmSysState getSystemState() {
        this.mpmState.setTickMillis(this.getTickPeriod());
        return this.mpmState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws UtilityException {
        return new ArrayList<String>(MpmSwitches.NAME_MAP.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String swch, @Argument(description="Whether to turn on") boolean on) throws UtilityException {
        Integer sw = MpmSwitches.NAME_MAP.get(swch);
        if (sw == null) {
            throw new UtilityException("Invalid switch name: " + swch);
        }
        SwitchState state = this.mpmState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        this.plutoDevc.setSwitchOn(sw, on, false);
        this.switchChanged = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get latched condition names")
    public List<String> getLatchNames() throws UtilityException {
        return new ArrayList<String>(MpmLatches.NAME_MAP.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a latched condition")
    public void clearLatch(@Argument(description="The condition name") String cond) throws UtilityException {
        try {
            Integer id = MpmLatches.NAME_MAP.get(cond);
            if (id == null) {
                throw new UtilityException("Invalid condition name: " + cond);
            }
            this.plutoDevc.clearLatch(id);
        }
        finally {
            this.updateMpmState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    private void updateMpmState() {
        int cond;
        MpmAlert alert;
        if (!this.running) {
            return;
        }
        boolean changed = this.switchChanged;
        this.switchChanged = false;
        for (int iplc = 0; iplc < 2; ++iplc) {
            PLCState newState;
            int plc = plcID[iplc];
            Boolean active = this.plutoDevc.isPlcActive(plc);
            PLCState pLCState = active == null ? PLCState.OFFLINE : (newState = active != false ? PLCState.ALIVE : PLCState.DEAD);
            if (newState == this.mpmState.getPlcState(plc)) continue;
            changed = true;
            this.mpmState.setPlcState(plc, newState);
            alert = plcAlerts[iplc];
            String plcDesc = plcNames[iplc] + " protection PLC ";
            if (newState == PLCState.ALIVE) {
                this.lowerAlert(alert, plcDesc + "is alive");
                continue;
            }
            String errDesc = newState == PLCState.DEAD ? "has died: error = " + this.plutoDevc.getErrorCode(plc) : "is offline";
            this.raiseAlert(alert, plcDesc + errDesc);
        }
        for (int sw = 0; sw < 7; ++sw) {
            SwitchState state = this.plutoDevc.getSwitchState(sw);
            if (state == this.mpmState.getSwitchState(sw)) continue;
            this.mpmState.setSwitchState(sw, state);
            changed = true;
        }
        for (cond = 0; cond < 11; ++cond) {
            Boolean active = this.plutoDevc.isLatchActive(cond);
            Boolean latched = this.plutoDevc.isLatchLatched(cond);
            LatchState state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            alert = alertMap.get(cond);
            LatchState oldState = this.mpmState.getLatch(cond);
            if (state == oldState) continue;
            this.mpmState.setLatch(cond, state);
            if (state == LatchState.ACTIVE) {
                this.raiseAlert(alert, "Protection PLC error condition set");
            } else if (state != LatchState.OFFLINE) {
                if (oldState != LatchState.ACTIVE && state == LatchState.LATCHED) {
                    this.raiseAlert(alert, "Protection PLC error condition set");
                }
                if (oldState == LatchState.ACTIVE || state == LatchState.LATCHED) {
                    this.lowerAlert(alert, "Protection PLC error condition cleared");
                }
            }
            changed = true;
        }
        for (cond = 0; cond < 7; ++cond) {
            ConditionState state;
            Boolean active = this.plutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.mpmState.getCondition(cond)) continue;
            this.mpmState.setCondition(cond, state);
            changed = true;
        }
        if (this.mpmState.getLimit(0) == Integer.MAX_VALUE) {
            int[] limits = this.plutoDevc.getTempLimits();
            for (int j = 0; j < 4; ++j) {
                this.mpmState.setLimit(j, limits[j]);
            }
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
    }

    private void raiseAlert(MpmAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
    }

    private void lowerAlert(MpmAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            String cond = revAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (UtilityException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.mpmState.setTickMillis(this.getTickPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("MPMState", (Serializable)this.mpmState));
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    static {
        alertMap.put(5, MpmAlert.COLD_TEMP_HIGH);
        alertMap.put(6, MpmAlert.COLD_TEMP_LOW);
        alertMap.put(7, MpmAlert.CRYO_TEMP_HIGH);
        alertMap.put(8, MpmAlert.CRYO_TEMP_LOW);
        alertMap.put(9, MpmAlert.CRYO_VACUUM_BAD);
        alertMap.put(10, MpmAlert.HEX_VACUUM_BAD);
        alertMap.put(1, MpmAlert.UT_COOLANT_LEAK);
        alertMap.put(2, MpmAlert.UT_LEAK_DETC_FAULT);
        alertMap.put(3, MpmAlert.UT_SMOKE_DETC);
        alertMap.put(4, MpmAlert.UT_SMOKE_DETC_FAULT);
        alertMap.put(0, MpmAlert.UT_TEMP_HIGH);
        revAlertMap = new HashMap<String, String>();
        for (Map.Entry<Integer, MpmAlert> e : alertMap.entrySet()) {
            revAlertMap.put(e.getValue().getId(), MpmLatches.ID_MAP.get((int)e.getKey()));
        }
        plcAlerts = new MpmAlert[2];
        ComCamMpmMain.plcAlerts[0] = MpmAlert.POWER_PLC_NOT_ALIVE;
        ComCamMpmMain.plcAlerts[1] = MpmAlert.CRYO_PLC_NOT_ALIVE;
        plcNames = new String[2];
        plcID = new int[2];
        ComCamMpmMain.plcID[0] = 0;
        ComCamMpmMain.plcNames[0] = "Trunk";
        ComCamMpmMain.plcID[1] = 2;
        ComCamMpmMain.plcNames[1] = "Cryo";
        LOG = Logger.getLogger(ComCamMpmMain.class.getName());
    }
}

