/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.Checksum;

public class SALClassDescription {
    private final String className;
    private final Map<String, SALVariable> variables = new TreeMap<String, SALVariable>(new VariableComparator());
    private final int level;
    private final String category;

    SALClassDescription(String className, int level, String category) {
        this.className = className;
        this.level = level;
        this.category = category;
    }

    SALVariable getVariable(String variableName) {
        return this.variables.get(variableName);
    }

    void add(SALVariable var) {
        this.variables.put(var.getVariableName(), var);
    }

    public String getClassName() {
        return this.className;
    }

    public List<SALVariable> getVariables() {
        return new ArrayList<SALVariable>(this.variables.values());
    }

    public int getLevel() {
        return this.level;
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        return "SALClassDescription{className=" + this.className + ", level=" + this.level + ", category=" + this.category + this.getVariables().stream().map(v -> v.toString()).collect(Collectors.joining("\n\t", "\n\t", "\n")) + '}';
    }

    public void updateChecksum(Checksum sum) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeUTF(this.className);
                dos.writeInt(this.level);
                if (this.category != null) {
                    dos.writeUTF(this.category);
                }
            }
            bos.flush();
            sum.update(bos.toByteArray(), 0, bos.size());
        }
        catch (IOException x) {
            throw new RuntimeException("Unpexected error computing checksum", x);
        }
        for (SALVariable variable : this.variables.values()) {
            variable.updateCheckSum(sum);
        }
    }

    void renameVariable(SALVariable variable, String newName) {
        String oldName = variable.getVariableName();
        this.variables.remove(oldName);
        variable.setName(newName);
        this.variables.put(newName, variable);
    }

    int getSharedLocationCount(SALVariable sv) {
        if (sv instanceof PatternMatchedSALVariable) {
            PatternMatchedSALVariable pmv = (PatternMatchedSALVariable)sv;
            OptionalInt count = this.variables.values().stream().filter(var -> var instanceof PatternMatchedSALVariable).map(var -> (PatternMatchedSALVariable)var).filter(var -> var.getLocationVariable() == pmv.getLocationVariable()).mapToInt(var -> var.getCount()).max();
            return count.isPresent() ? count.getAsInt() : 0;
        }
        return 1;
    }

    private static class VariableComparator
    implements Comparator<String> {
        private VariableComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            o1 = o1.replace("warnHi", "dbandHi");
            o1 = o1.replace("warnLo", "dbandLo");
            o2 = o2.replace("warnHi", "dbandHi");
            o2 = o2.replace("warnLo", "dbandLo");
            return o1.compareTo(o2);
        }
    }

    public static class BusVariable {
        private final String pathAndNameOnBuses;

        public BusVariable(String pathAndNameOnBuses) {
            this.pathAndNameOnBuses = pathAndNameOnBuses;
        }

        public String getPathAndNameOnBuses() {
            return this.pathAndNameOnBuses;
        }

        public String toString() {
            return "BusVariable{pathAndNameOnBuses=" + this.pathAndNameOnBuses + '}';
        }
    }

    public static class PatternMatchedSALVariable
    extends SALVariable {
        private final String patternName;
        private final String pattern;
        private final List<BusVariable> busVariables = new ArrayList<BusVariable>();
        private final LocationVariable locationVariable;

        public PatternMatchedSALVariable(String patternName, String pattern, LocationVariable location, String variableName, String type, String units, String description) {
            super(variableName, type, units, description);
            this.patternName = patternName;
            this.pattern = pattern;
            this.locationVariable = location;
        }

        void addBusVariable(BusVariable var) {
            this.busVariables.add(var);
        }

        public String getPatternName() {
            return this.patternName;
        }

        public String getPattern() {
            return this.pattern;
        }

        public List<BusVariable> getBusVariables() {
            return this.busVariables;
        }

        public LocationVariable getLocationVariable() {
            return this.locationVariable;
        }

        @Override
        public int getCount() {
            return this.busVariables.size();
        }

        @Override
        public String toString() {
            return "PatternMatchedSALVariable{" + super.toString() + " patternName=" + this.patternName + ", pattern=" + this.pattern + ", locationVariable=" + this.locationVariable + this.busVariables.stream().map(v -> v.toString()).collect(Collectors.joining("\n\t\t", "\n\t\t", "\n\t")) + '}';
        }
    }

    public static class LocationVariable
    extends SALVariable {
        public LocationVariable(String variableName, String description) {
            super(variableName, "String", "unitless", description);
        }

        @Override
        public String toString() {
            return "LocationVariable{" + super.toString() + '}';
        }
    }

    public static class SimpleSALVariable
    extends SALVariable {
        private final BusVariable busVariable;

        public SimpleSALVariable(String variableName, String type, String units, String description, BusVariable busVariable) {
            super(variableName, type, units, description);
            this.busVariable = busVariable;
        }

        public BusVariable getBusVariable() {
            return this.busVariable;
        }

        @Override
        public String toString() {
            return "SimpleSALVariable{" + super.toString() + " busVariable=" + this.busVariable + '}';
        }
    }

    public static abstract class SALVariable {
        private String variableName;
        private final String type;
        private final String units;
        private final String description;

        public SALVariable(String variableName, String type, String units, String description) {
            if (type == null || type.isEmpty()) {
                type = "String";
            }
            this.variableName = variableName;
            this.type = type;
            this.units = units;
            this.description = description;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public String getType() {
            return this.type;
        }

        public String getUnits() {
            return this.units;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCount() {
            return 1;
        }

        public String toString() {
            return "variableName=" + this.variableName + ", type=" + this.type + ", units=" + this.units + ", description=\"" + this.description + "\"";
        }

        private void setName(String newName) {
            this.variableName = newName;
        }

        private void updateCheckSum(Checksum sum) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                try (DataOutputStream dos = new DataOutputStream(bos);){
                    dos.writeUTF(this.variableName);
                    dos.writeUTF(this.type);
                }
                bos.flush();
                sum.update(bos.toByteArray(), 0, bos.size());
            }
            catch (IOException x) {
                throw new RuntimeException("Unexpected error computing checksum", x);
            }
        }
    }
}

