/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.schedule;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import com.ifountain.opsgenie.client.model.beans.ScheduleRotation;
import com.ifountain.opsgenie.client.model.schedule.AddScheduleRequest;
import com.ifountain.opsgenie.client.model.schedule.AddScheduleResponse;
import com.ifountain.opsgenie.client.model.schedule.UpdateScheduleResponse;
import java.util.List;
import java.util.TimeZone;

public class UpdateScheduleRequest
extends BaseRequest<AddScheduleResponse, AddScheduleRequest>
implements ObjectWithTimeZone {
    private String id;
    private String name;
    private Boolean enabled;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private List<ScheduleRotation> rotations;
    private String team;
    private String description;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ScheduleRotation> getRotations() {
        if (this.getTimeZone() != null && this.rotations != null) {
            for (ScheduleRotation scheduleRotation : this.rotations) {
                scheduleRotation.setScheduleTimeZone(this.getTimeZone());
            }
        }
        return this.rotations;
    }

    public void setRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.timeZone;
    }

    public UpdateScheduleRequest withId(String id) {
        this.id = id;
        return this;
    }

    public UpdateScheduleRequest withName(String name) {
        this.name = name;
        return this;
    }

    public UpdateScheduleRequest withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public UpdateScheduleRequest withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public UpdateScheduleRequest withRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
        return this;
    }

    public UpdateScheduleRequest withTeam(String team) {
        this.team = team;
        return this;
    }

    public UpdateScheduleRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getEndPoint() {
        return "/v1/json/schedule";
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (this.id == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("id");
        }
    }

    @Override
    public UpdateScheduleResponse createResponse() {
        return new UpdateScheduleResponse();
    }
}

