/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.utilities.location.Location;

public class SensorLocation {
    private static final Pattern SENSOR_PATTERN = Pattern.compile("R(\\d\\d)S(.)([012])");
    final Location rebLocation;
    final int sensor;

    public SensorLocation(byte bay, byte board, int sensor) {
        this(new Location((int)bay, (int)board), sensor);
    }

    public SensorLocation(Location rebLocation, int sensor) {
        int nCCDs;
        int n = nCCDs = rebLocation.type() == Location.LocationType.SCIENCE ? 3 : 2;
        if (sensor >= nCCDs) {
            throw new IllegalArgumentException("Invalid sensor # " + sensor + " for " + rebLocation);
        }
        this.rebLocation = rebLocation;
        this.sensor = sensor;
    }

    public Location getRebLocation() {
        return this.rebLocation;
    }

    public int getSensor() {
        return this.sensor;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.rebLocation);
        hash = 83 * hash + this.sensor;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SensorLocation other = (SensorLocation)obj;
        if (this.sensor != other.sensor) {
            return false;
        }
        return Objects.equals(this.rebLocation, other.rebLocation);
    }

    static SensorLocation of(String string) {
        Matcher matcher = SENSOR_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid sensor location: " + string);
        }
        String reb = "R" + matcher.group(1) + "/Reb" + matcher.group(2);
        Location rebLocation = Location.of((String)reb);
        int sensor = Integer.parseInt(matcher.group(3));
        return new SensorLocation(rebLocation, sensor);
    }

    public String toString() {
        return this.rebLocation.getRaftName() + this.rebLocation.getSensorName(this.sensor);
    }
}

