/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.CompMaq20PWMControl;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.CryoCompLimits;
import org.lsst.ccs.subsystem.refrig.constants.BypassValveState;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.CoolantValveState;
import org.lsst.ccs.subsystem.refrig.constants.OilSepHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.OrificeValveState;
import org.lsst.ccs.subsystem.refrig.constants.SurgeHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CryoCompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class CryoCompressor
extends Compressor {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private CryoCompLimits compLimits;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private CompMaq20PWMControl pwmControl;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    private String suctPressChan;
    private String phaseSepTempChan;
    private String oilLevelChan;
    private static final Logger LOG = Logger.getLogger(CryoCompressor.class.getName());

    public CryoCompressor() {
        super(new CryoCompState());
    }

    public void build() {
        this.stateService.registerState(OrificeValveState.class, "Orifice valve state", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{OrificeValveState.OFFLINE});
        this.stateService.registerState(BypassValveState.class, "Bypass valve state", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{BypassValveState.OFFLINE});
        this.stateService.registerState(CoolantValveState.class, "Coolant valve state", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{CoolantValveState.OFFLINE});
        this.stateService.registerState(SurgeHeaterState.class, "Surge tank heater state", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{SurgeHeaterState.OFFLINE});
        this.stateService.registerState(OilSepHeaterState.class, "Oil separator heater state", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{OilSepHeaterState.OFFLINE});
    }

    @Override
    public void postInit() {
        Channel oilLevel;
        Channel suctPress;
        Channel phaseSepTemp;
        super.postInit();
        Channel channel = phaseSepTemp = this.phaseSepTempChan != null ? (Channel)this.channelMap.get(this.phaseSepTempChan) : null;
        if (phaseSepTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"phaseSepTempChan", (String)"not specified or not defined");
        }
        this.condData[4].channel = phaseSepTemp;
        Channel channel2 = suctPress = this.suctPressChan != null ? (Channel)this.channelMap.get(this.suctPressChan) : null;
        if (suctPress == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"suctPressChan", (String)"not specified or not defined");
        }
        this.condData[9].channel = this.discTemp;
        this.condData[8].channel = this.discPress;
        this.condData[8].channel2 = suctPress;
        Channel channel3 = oilLevel = this.oilLevelChan != null ? (Channel)this.channelMap.get(this.oilLevelChan) : null;
        if (oilLevel == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"oilLevelChan", (String)"not specified or not defined");
        }
        this.condData[6].channel = oilLevel;
        this.switchDevices[1] = this.plutoDevc;
        this.switchChannels[1] = 2;
        this.switchDevices[3] = this.maq20Devc;
        this.switchChannels[3] = 2;
        this.switchDevices[4] = this.maq20Devc;
        this.switchChannels[4] = 1;
        this.switchDevices[5] = this.maq20Devc;
        this.switchChannels[5] = 3;
        this.switchDevices[6] = this.maq20Devc;
        this.switchChannels[6] = 4;
        if (this.compLimits == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"CryoCompLimits", (String)"not defined");
        }
        this.limitData = this.compLimits.getLimitData();
    }

    @Override
    protected synchronized boolean updateState() {
        boolean changed = super.updateState();
        if (changed) {
            SwitchState swState = this.state.getSwitchState(3);
            OrificeValveState ovState = swState == SwitchState.ON ? OrificeValveState.OPEN : (swState == SwitchState.OFF ? OrificeValveState.SHUT : OrificeValveState.OFFLINE);
            swState = this.state.getSwitchState(5);
            BypassValveState bvState = swState == SwitchState.ON ? BypassValveState.OPEN : (swState == SwitchState.OFF ? BypassValveState.SHUT : BypassValveState.OFFLINE);
            swState = this.state.getSwitchState(4);
            CoolantValveState cvState = swState == SwitchState.ON ? CoolantValveState.SHUT : (swState == SwitchState.OFF ? CoolantValveState.OPEN : CoolantValveState.OFFLINE);
            swState = this.state.getSwitchState(1);
            OilSepHeaterState oshState = swState == SwitchState.ON ? OilSepHeaterState.ON : (swState == SwitchState.OFF ? OilSepHeaterState.OFF : OilSepHeaterState.OFFLINE);
            swState = this.state.getSwitchState(6);
            SurgeHeaterState shState = swState == SwitchState.ON ? SurgeHeaterState.ON : (swState == SwitchState.OFF ? SurgeHeaterState.OFF : SurgeHeaterState.OFFLINE);
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{ovState, bvState, cvState, oshState, shState});
        }
        this.controlValves(this.state.getCompressorState() == CompressorState.RUNNING, this.stateChanged);
        this.controlFan(this.state.getCompressorState() == CompressorState.RUNNING, this.stateChanged);
        this.controlHeater();
        return changed;
    }

    private void controlValves(boolean compOn, boolean changed) {
        try {
            if (compOn) {
                double press = this.condData[0].channel.getValue();
                if (press > this.limitData[12].immedLimit) {
                    this.setSwitch(3, false);
                } else if (press < this.limitData[11].immedLimit) {
                    this.setSwitch(3, true);
                }
            }
            if (changed) {
                if (compOn) {
                    this.setSwitch(5, false);
                } else {
                    this.setSwitch(3, false);
                }
                this.setSwitch(4, !compOn);
            }
        }
        catch (RefrigException e) {
            LOG.log(Level.SEVERE, "Error operating {0} compressor valves: {1}", new Object[]{this.name, e});
        }
    }

    private void controlHeater() {
        double temp = this.discTemp.getValue();
        if (temp > this.limitData[10].immedLimit && this.state.getSwitchState(1) == SwitchState.ON) {
            LOG.log(Level.WARNING, "Turning {0} compressor heater off - discharge temperature ({1}) > {2}", new Object[]{this.name, temp, this.limitData[10].immedLimit});
            try {
                this.setSwitch(1, false);
            }
            catch (RefrigException e) {
                LOG.log(Level.SEVERE, "Error operating {0} compressor heater: {1}", new Object[]{this.name, e});
            }
        }
    }

    private void controlFan(boolean compOn, boolean changed) {
        if (changed && this.pwmControl != null) {
            if (compOn) {
                this.pwmControl.enable();
            } else {
                this.pwmControl.disable();
            }
        }
    }
}

