/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class ResolveURI
extends SystemFunction {
    String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        String string2 = atomicValue.getStringValue();
        if (this.argument.length == 2) {
            string = this.argument[1].evaluateAsString(xPathContext);
        } else {
            string = this.expressionBaseURI;
            if (this.expressionBaseURI == null) {
                this.dynamicError("Base URI in static context is unknown", "FONS0005", xPathContext);
                return null;
            }
        }
        Platform platform = xPathContext.getConfiguration().getPlatform();
        try {
            URI uRI = platform.makeAbsolute(string2, string);
            return new AnyURIValue(uRI.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.dynamicError("Base URI " + Err.wrap(string) + " is invalid: " + uRISyntaxException.getMessage(), "FORG0002", xPathContext);
            return null;
        }
    }

    public Item evaluateItemOLD(XPathContext xPathContext) throws XPathException {
        URI uRI;
        String string;
        URI uRI2;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        String string2 = atomicValue.getStringValue();
        try {
            uRI2 = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.dynamicError("Relative URI " + Err.wrap(string2) + " is invalid: " + uRISyntaxException.getMessage(), "FORG0002", xPathContext);
            return null;
        }
        if (uRI2.isAbsolute()) {
            return new StringValue(string2);
        }
        if (this.argument.length == 2) {
            string = this.argument[1].evaluateAsString(xPathContext);
        } else {
            string = this.expressionBaseURI;
            if (this.expressionBaseURI == null) {
                this.dynamicError("Base URI in static context is unknown", "FONS0005", xPathContext);
                return null;
            }
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.dynamicError("Base URI " + Err.wrap(string) + " is invalid: " + uRISyntaxException.getMessage(), "FORG0002", xPathContext);
            return null;
        }
        URI uRI3 = uRI.resolve(uRI2);
        return new AnyURIValue(uRI3.toString());
    }
}

