/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.example;

import java.io.File;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.guider.Config;
import org.lsst.ccs.daq.guider.FitsWriterFactory;
import org.lsst.ccs.daq.guider.ROISpec;
import org.lsst.ccs.daq.guider.SensorLocation;
import org.lsst.ccs.daq.guider.Series;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Guider;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class GuiderTool {
    private static final Logger LOG = Logger.getLogger(GuiderTool.class.getName());
    private Store store;
    private Guider guider;
    private Guider.Subscriber subscribe0;
    private Guider.Subscriber subscribe1;

    @Command(name="connect", description="Connect to a DAQ guider")
    public void connect(@Argument(name="partition", description="Partition name") String partition) throws DAQException {
        if (this.store != null) {
            this.store.close();
        }
        this.store = new Store(partition);
        this.guider = this.store.getGuider();
    }

    @Command(name="close", description="Close DAQ store")
    public void close() throws DAQException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Command(name="stop", description="Stop the guider")
    public Status stop() throws DAQException {
        this.checkStore();
        return this.guider.stop();
    }

    @Command(name="pause", description="Pause the guider")
    public Status pause() throws DAQException {
        this.checkStore();
        return this.guider.pause();
    }

    @Command(name="resume", description="Resume the guider")
    public Status resume() throws DAQException {
        this.checkStore();
        return this.guider.resume();
    }

    @Command(name="sleep", description="Sleep the guider")
    public Status sleep() throws DAQException {
        this.checkStore();
        return this.guider.sleep();
    }

    @Command(name="wake", description="Wake the guider")
    public Status wake() throws DAQException {
        this.checkStore();
        return this.guider.wake();
    }

    @Command(name="config", description="Get the guider config")
    public Config config() throws DAQException {
        this.checkStore();
        return this.guider.config();
    }

    @Command(name="series", description="Get the guider series")
    public Series series() throws DAQException {
        this.checkStore();
        return this.guider.series();
    }

    @Command(name="start", description="Start the guider")
    public Status start(String imageName, String roiSpec) throws DAQException {
        this.checkStore();
        ROISpec spec = ROISpec.parse(roiSpec);
        spec.sanityCheck(this.guider.getConfiguredLocations());
        return this.guider.start(spec.getCommon(), imageName, spec.getLocations());
    }

    @Command(name="validate", description="Validate the roi")
    public void validate(String roiSpec) throws DAQException {
        this.checkStore();
        ROISpec spec = ROISpec.parse(roiSpec);
        spec.sanityCheck(this.guider.getConfiguredLocations());
        this.guider.validate(spec.getCommon(), spec.getLocations());
    }

    @Command(name="fits", description="Subscribe to notifications to write a FITS file")
    public void fitsWrite() throws DAQException {
        FitsHeadersSpecificationsBuilder headerSpecBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecBuilder.addSpecFile("guider-primary.spec", "primary");
        headerSpecBuilder.addSpecFile("guider-stamp.spec", "stamp");
        Map headerSpecifications = headerSpecBuilder.getHeaderSpecifications();
        this.checkStore();
        FitsIntWriter.FileNamer namer = props -> new File(new File("."), String.format("%s_%s_%s.fits", props.get("ImageName"), props.get("RaftBay"), props.get("CCDSlot")));
        Location R00 = Location.of((String)"R00/RebG");
        SensorLocation sensorLocation0 = new SensorLocation(R00, 0);
        SensorLocation sensorLocation1 = new SensorLocation(R00, 1);
        FitsWriterFactory writer0 = new FitsWriterFactory(this.store.getPartition(), namer, headerSpecifications);
        FitsWriterFactory writer1 = new FitsWriterFactory(this.store.getPartition(), namer, headerSpecifications);
        this.subscribe0 = this.guider.subscribe(Collections.singleton(sensorLocation0), ByteOrder.BIG_ENDIAN, writer0);
        Thread t0 = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.subscribe0.waitForGuider();
                    }
                }
                catch (DAQException x) {
                    LOG.log(Level.SEVERE, "DAQ Exception", x);
                    continue;
                }
                break;
            }
        });
        t0.start();
        this.subscribe1 = this.guider.subscribe(Collections.singleton(sensorLocation1), ByteOrder.BIG_ENDIAN, writer1);
        Thread t1 = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.subscribe1.waitForGuider();
                    }
                }
                catch (DAQException x) {
                    LOG.log(Level.SEVERE, "DAQ Exception", x);
                    continue;
                }
                break;
            }
        });
        t1.start();
    }

    @Command(name="unsubscribe", description="Unsubscribe ")
    public void unsubscribe() throws DAQException {
        if (this.subscribe0 != null) {
            this.subscribe0.close();
        }
        if (this.subscribe1 != null) {
            this.subscribe1.close();
        }
    }

    @Command(name="version", description="Get version info")
    public Version version() throws DAQException {
        return Store.getClientVersion();
    }

    @Command(name="locations", description="List configured locations")
    public LocationSet locations() throws DAQException {
        this.checkStore();
        return this.guider.getConfiguredLocations();
    }

    private void checkStore() {
        if (this.store == null) {
            throw new RuntimeException("Please connect to store first");
        }
    }
}

