/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.DictionaryProvider;
import org.lsst.ccs.subsystem.ocsbridge.HeaderServiceEventHandler;
import org.lsst.ccs.subsystem.ocsbridge.MCMCCSLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeSALLayer;
import org.lsst.ccs.subsystem.ocsbridge.SoftwareVersionsGenerator;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSSubsystem
extends Subsystem
implements HasLifecycle {
    private OCSBridge ocsBridge;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private OCSBridgeConfig config;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private DictionaryProvider dictionaryProvider;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private HeaderServiceEventHandler eventHandler;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLoginService loginService;

    OCSSubsystem() {
        super("ocs-bridge", AgentInfo.AgentType.OCS_BRIDGE);
    }

    public void init() {
        this.agentStateService.registerState(SummaryStateEvent.SummaryState.class, "SAL Summary State", (Object)this);
        this.agentStateService.registerState(OfflineDetailedStateEvent.OfflineState.class, "SAL Offline State", (Object)this);
        this.agentStateService.registerState(CCSCommandStateEvent.CCSCommandState.class, "SAL Command State", (Object)this);
    }

    public void postStart() {
        this.loginService.login(this.config.getUserID(), "noCredentialsNeeded");
        CCS ccs = new CCS();
        MCMCCSLayer mcmLayer = new MCMCCSLayer(this, ccs, this.config, this.loginService, this.agentLockService);
        this.ocsBridge = new OCSBridge(this.config, ccs, mcmLayer, this.dictionaryProvider);
        State lse209State = this.ocsBridge.getLse209State();
        State offlineState = this.ocsBridge.getOfflineState();
        State<CCSCommandStateEvent.CCSCommandState> commandState = this.ocsBridge.getCommandState();
        SoftwareVersionsGenerator softwareVersionsGenerator = new SoftwareVersionsGenerator(this.ocsBridge, (Agent)this);
        this.agentStateService.updateAgentState(new Enum[]{lse209State.getState(), offlineState.getState(), commandState.getState()});
        State.StateChangeListener<Enum> l = (when, state, oldState, cause) -> {
            this.agentStateService.updateAgentState(when, new Enum[]{state});
            if (state == SummaryStateEvent.SummaryState.STANDBY) {
                softwareVersionsGenerator.run(true);
            }
        };
        lse209State.addStateChangeListener(l);
        offlineState.addStateChangeListener(l);
        commandState.addStateChangeListener(l);
        this.ocsBridge.setCCSCommandExecutor(new CCSCommandExecutor(){

            @Override
            void sendAck(CCSCommand.CCSAckOrNack can) {
                OCSSubsystem.this.sendAck(can.getDuration().plus(Duration.ofMillis(100L)));
            }

            @Override
            void sendNack(CCSCommand.CCSAckOrNack can) {
                OCSSubsystem.this.sendNack((Serializable)((Object)can.getReason()));
            }
        });
        OCSBridgeSALLayer ocsInterface = new OCSBridgeSALLayer(this.ocsBridge);
        ocsInterface.addSALEventListener(this.eventHandler);
        this.ocsBridge.setOCSCommandExecutor(ocsInterface);
        ocsInterface.start();
        softwareVersionsGenerator.run(false);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setAvailable() throws Exception {
        CCSCommand.CCSSetAvailableCommand setAvailable = new CCSCommand.CCSSetAvailableCommand();
        this.ocsBridge.execute(setAvailable);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void revokeAvailable() throws Exception {
        CCSCommand.CCSRevokeAvailableCommand revokeAvailable = new CCSCommand.CCSRevokeAvailableCommand();
        this.ocsBridge.execute(revokeAvailable);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void simulateFault() throws Exception {
        CCSCommand.CCSSimulateFaultCommand simulateFault = new CCSCommand.CCSSimulateFaultCommand();
        this.ocsBridge.execute(simulateFault);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clearFault() throws Exception {
        CCSCommand.CCSClearFaultCommand clearFault = new CCSCommand.CCSClearFaultCommand();
        this.ocsBridge.execute(clearFault);
    }
}

