/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.model.ConvertFromTimeZone;
import com.ifountain.opsgenie.client.model.beans.BeanWithId;
import com.ifountain.opsgenie.client.model.beans.ScheduleRotation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;

public class Schedule
extends BeanWithId
implements ConvertFromTimeZone {
    private String name;
    private String team;
    private String description;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private Boolean enabled;
    @JsonProperty(value="rules")
    private List<ScheduleRotation> rotations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<ScheduleRotation> getRotations() {
        return this.rotations;
    }

    public void setRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    @Override
    public void setTime() throws ParseException {
        if (this.getTimeZone() != null && this.rotations != null && this.rotations.size() > 0) {
            for (ScheduleRotation scheduleRotation : this.rotations) {
                scheduleRotation.setScheduleTimeZone(this.getTimeZone());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                String endDateString = null;
                String startDateString = null;
                if (scheduleRotation.getEndDate() != null) {
                    endDateString = sdf.format(scheduleRotation.getEndDate());
                }
                if (scheduleRotation.getStartDate() != null) {
                    startDateString = sdf.format(scheduleRotation.getStartDate());
                }
                sdf.setTimeZone(this.getTimeZone());
                if (endDateString != null) {
                    scheduleRotation.setEndDate(sdf.parse(endDateString));
                }
                if (startDateString == null) continue;
                scheduleRotation.setStartDate(sdf.parse(startDateString));
            }
        }
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.timeZone;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Schedule withName(String name) {
        this.name = name;
        return this;
    }

    public Schedule withTeam(String team) {
        this.team = team;
        return this;
    }

    public Schedule withDescription(String description) {
        this.description = description;
        return this;
    }

    public Schedule withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Schedule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Schedule withRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
        return this;
    }
}

