/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;

public class EmergencyResponseManager
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(EmergencyResponseManager.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, RebPowerSupplyNode> rebs = new HashMap<String, RebPowerSupplyNode>();
    @ConfigurationParameter(description="Only cleared alerts are processed.")
    private volatile boolean processOnlyClearedAlerts = true;
    private OriginManager originManager;
    private AlertPayloadListener alertPayloadListener = new AlertPayloadListener();
    private final Map<String, RebEmergencyResponseDelegate> rebEmergencyResponseDelegates = new ConcurrentHashMap<String, RebEmergencyResponseDelegate>();

    public void init() {
        this.alertService.startStatusAlertListening(info -> info.isAgentWorkerOrService());
        this.originManager = new OriginManager(this.agent.getName());
        for (Map.Entry<String, RebPowerSupplyNode> e : this.rebs.entrySet()) {
            this.rebEmergencyResponseDelegates.put(e.getKey(), new RebEmergencyResponseDelegate(e.getValue()));
        }
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.originManager);
    }

    public void start() {
        this.alertService.addListener((AlertListener)this.alertPayloadListener);
    }

    public void shutdown() {
        this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this.originManager);
        this.alertService.removeListener((AlertListener)this.alertPayloadListener);
    }

    private class OriginManager
    implements AgentPresenceListener {
        private final List<String> origins = new CopyOnWriteArrayList<String>();

        OriginManager(String agentName) {
            this.origins.add(agentName);
        }

        public void connecting(AgentInfo ... agents) {
            for (AgentInfo ai : agents) {
                if (!ai.hasAgentProperty(RebPowerAction.class.getCanonicalName())) continue;
                LOG.log(Level.INFO, "Adding agent {0} to list of origins for payload {1}", new Object[]{ai.getName(), RebPowerAction.class.getCanonicalName()});
                this.origins.add(ai.getName());
                RaisedAlertSummary s = (RaisedAlertSummary)EmergencyResponseManager.this.alertService.getAllSummaries().get(ai.getName());
                if (s == null) continue;
                EmergencyResponseManager.this.alertPayloadListener.processAlertSummary(s, ai.getName());
            }
        }

        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo ai : agents) {
                if (!this.origins.remove(ai.getName())) continue;
                LOG.log(Level.INFO, "Removing agent {0} from the list of origins for payload {1}", new Object[]{ai.getName(), RebPowerAction.class.getCanonicalName()});
                EmergencyResponseManager.this.alertPayloadListener.processAgentDisconnection(ai.getName());
            }
        }

        List<String> getOrigins() {
            return this.origins;
        }
    }

    private class AlertPayloadListener
    implements AlertListener {
        private final List<String> initialized = new CopyOnWriteArrayList<String>();

        private AlertPayloadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAlert(AlertEvent event) {
            if (EmergencyResponseManager.this.originManager.getOrigins().contains(event.getSource())) {
                Alert alert = event.getAlert();
                AlertEvent.AlertEventType type = event.getType();
                String origin = event.getSource();
                if (null != type) {
                    List<String> list = this.initialized;
                    synchronized (list) {
                        if (type != AlertEvent.AlertEventType.AGENT_DISCONNECTION && !this.initialized.contains(origin)) {
                            this.initialized.add(origin);
                            this.processAlertSummary(event.getSummary(), origin);
                        } else {
                            switch (type) {
                                case ALERT_RAISED: {
                                    this.processAlert(origin, alert, event.getLevel());
                                    break;
                                }
                                case ALERT_CLEARED: {
                                    this.processClearedAlerts(origin, event);
                                    break;
                                }
                                case AGENT_DISCONNECTION: {
                                    this.processAgentDisconnection(origin);
                                }
                            }
                        }
                    }
                }
            }
        }

        private void processClearedAlerts(String origin, AlertEvent event) {
            List clearedIds = event.getClearedIds();
            for (RebEmergencyResponseDelegate delegate : EmergencyResponseManager.this.rebEmergencyResponseDelegates.values()) {
                for (String clearedId : clearedIds) {
                    delegate.processAlert(origin, clearedId, event.getStateForClearedAlert(clearedId));
                }
            }
        }

        private void processAlertsAfterDisconnection(String origin) {
            for (RebEmergencyResponseDelegate delegate : EmergencyResponseManager.this.rebEmergencyResponseDelegates.values()) {
                delegate.processDisconnection(origin);
            }
        }

        private void processAlert(String origin, Alert alert, AlertState state) {
            RebPowerAction rebPowerAction = RebPowerAction.getRebPowerActionPayloadFromAlert((Alert)alert);
            if (rebPowerAction != null) {
                String rebPath = rebPowerAction.getRebPath();
                RebPowerSupplyNode rebNode = (RebPowerSupplyNode)EmergencyResponseManager.this.rebs.get(rebPath);
                if (rebNode == null) {
                    LOG.log(Level.SEVERE, "Could not find RebNode for path {0}", new Object[]{rebPath});
                } else {
                    RebEmergencyResponseDelegate delegate = (RebEmergencyResponseDelegate)EmergencyResponseManager.this.rebEmergencyResponseDelegates.get(rebPath);
                    delegate.processEmergencyResponse(origin, alert, rebPowerAction);
                }
            } else if (!EmergencyResponseManager.this.processOnlyClearedAlerts) {
                for (RebEmergencyResponseDelegate delegate : EmergencyResponseManager.this.rebEmergencyResponseDelegates.values()) {
                    delegate.processAlert(origin, alert.getAlertId(), state);
                }
            }
        }

        void processAlertSummary(RaisedAlertSummary summary, String origin) {
            for (RaisedAlertHistory alertHistory : summary.getAllRaisedAlertHistories()) {
                if (!EmergencyResponseManager.this.processOnlyClearedAlerts) {
                    this.processAlert(origin, alertHistory.getLatestAlert(), alertHistory.getLatestAlertState());
                    continue;
                }
                this.processAlert(origin, alertHistory.getHighestAlert(), alertHistory.getHighestAlertState());
            }
        }

        void processAgentDisconnection(String origin) {
            this.initialized.remove(origin);
            this.processAlertsAfterDisconnection(origin);
        }
    }

    private class RebEmergencyResponseDelegate {
        private final RebPowerSupplyNode rebNode;
        private final Map<RebPowerAction.Type, List<String>> outstandingAlerts = new ConcurrentHashMap<RebPowerAction.Type, List<String>>();

        public RebEmergencyResponseDelegate(RebPowerSupplyNode rebNode) {
            this.rebNode = rebNode;
        }

        synchronized void processEmergencyResponse(String origin, Alert alert, RebPowerAction rebPowerAction) {
            this.addAlertCause(origin, alert, rebPowerAction);
            this.rebNode.processEmergencyResponse(origin, alert, rebPowerAction);
        }

        private void addAlertCause(String origin, Alert alert, RebPowerAction action) {
            String internalId;
            List alertIds = this.outstandingAlerts.getOrDefault(action.getType(), new ArrayList());
            if (!alertIds.contains(internalId = origin + "/" + alert.getAlertId())) {
                alertIds.add(internalId);
            }
            this.outstandingAlerts.put(action.getType(), alertIds);
            this.rebNode.updateEmergencyState(action.getType(), alertIds);
        }

        void processAlert(String origin, String alertId, AlertState state) {
            for (Map.Entry<RebPowerAction.Type, List<String>> e : this.outstandingAlerts.entrySet()) {
                List<String> alertIds = e.getValue();
                if (!alertIds.remove(origin + "/" + alertId)) continue;
                if (state == AlertState.ALARM) {
                    LOG.log(Level.SEVERE, "Something went really wrong in processing Reb Alerts.");
                }
                this.rebNode.updateEmergencyState(e.getKey(), alertIds);
            }
        }

        void processDisconnection(String origin) {
            for (Map.Entry<RebPowerAction.Type, List<String>> e : this.outstandingAlerts.entrySet()) {
                List<String> alertIds = e.getValue();
                Iterator<String> iter = alertIds.iterator();
                while (iter.hasNext()) {
                    String id = iter.next();
                    if (!id.startsWith(origin + "/")) continue;
                    iter.remove();
                }
                this.rebNode.updateEmergencyState(e.getKey(), alertIds);
            }
        }
    }
}

