/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.sal.camera.CameraEvent;

public class FocalPlaneHardwareIdConverter {
    private static final Pattern SENSOR_PATTERN = Pattern.compile("(R..)/(Reb.)/(S..)/(\\w+)");
    private static final Pattern REB_PATTERN = Pattern.compile("(R..)/(Reb.)(?:_hardware)?/(\\w+)");
    private static final Pattern RAFT_PATTERN = Pattern.compile("(R..)/(.+)");
    private static final DelimitedStringSplitJoin DELIMITED_STRING_SPLIT_JOIN = new DelimitedStringSplitJoin();
    private final OCSBridgeConfig.Device device;

    public FocalPlaneHardwareIdConverter(OCSBridgeConfig.Device device) {
        this.device = device;
    }

    public CameraEvent convert(ConfigurationInfo data) {
        TreeSet<String> ccdLocations = new TreeSet<String>();
        TreeSet<String> rebLocations = new TreeSet<String>();
        TreeSet<String> raftLocations = new TreeSet<String>();
        HashMap ccdNames = new HashMap();
        HashMap manSerNums = new HashMap();
        HashMap rebNames = new HashMap();
        HashMap raftNames = new HashMap();
        Map hardwareMap = data.getCurrentValuesForCategory("HardwareId");
        for (Map.Entry entry : hardwareMap.entrySet()) {
            String type;
            Matcher sensorMatcher = SENSOR_PATTERN.matcher((CharSequence)entry.getKey());
            Matcher rebMatcher = REB_PATTERN.matcher((CharSequence)entry.getKey());
            Matcher raftMatcher = RAFT_PATTERN.matcher((CharSequence)entry.getKey());
            if (sensorMatcher.matches()) {
                String ccdName = sensorMatcher.group(1) + sensorMatcher.group(3);
                ccdLocations.add(ccdName);
                type = sensorMatcher.group(4);
                if ("name".equals(type)) {
                    ccdNames.put(ccdName, entry.getValue());
                    continue;
                }
                if (!"manSerNum".equals(type)) continue;
                manSerNums.put(ccdName, entry.getValue());
                continue;
            }
            if (rebMatcher.matches()) {
                String rebName = rebMatcher.group(1) + rebMatcher.group(2);
                rebLocations.add(rebName);
                type = rebMatcher.group(3);
                if (!"name".equals(type)) continue;
                rebNames.put(rebName, entry.getValue());
                continue;
            }
            if (!raftMatcher.matches()) continue;
            String raftName = raftMatcher.group(1);
            raftLocations.add(raftName);
            type = raftMatcher.group(2);
            if (!"name".equals(type)) continue;
            raftNames.put(raftName, entry.getValue());
        }
        if (this.device == OCSBridgeConfig.Device.AUXTEL) {
            return null;
        }
        return null;
    }

    private static <K> String get(Map<K, String> map, K name) {
        return FocalPlaneHardwareIdConverter.get(map, name, "Unknown");
    }

    private static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        return map.getOrDefault(key, defaultValue);
    }

    private Collector<CharSequence, ?, String> join() {
        return DELIMITED_STRING_SPLIT_JOIN.joining();
    }
}

