/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.abb.Cms;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class CmsDevice
extends Device {
    public static final int TYPE_RMS = 0;
    public static final int TYPE_AC = 1;
    public static final int TYPE_DC = 2;
    private static final Map<String, Modbus.ConnType> cTypeMap = new HashMap<String, Modbus.ConnType>();
    private static final Map<String, Integer> sTypeMap;
    private String connType;
    private String devcId;
    private int baudRate = 0;
    private int address = 1;
    private static final Logger LOG;
    private final Cms cms = new Cms();
    private Modbus.ConnType cType;
    private boolean initError = false;

    protected void initDevice() {
        if (this.connType == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"connType", (String)"is missing");
        }
        this.cType = cTypeMap.get(this.connType.toUpperCase());
        if (this.cType == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"connType", (String)"is invalid");
        }
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "CMS100 (" + this.devcId + ":" + this.address + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.cms.open(this.cType, this.devcId, this.baudRate);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.cms.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer sType;
        if (hwChan <= 0 || hwChan > 64) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwchan", (Object)hwChan);
        }
        if ((sType = sTypeMap.get(type == null || type.isEmpty() ? "RMS" : type.toUpperCase())) == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        return new int[]{sType, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        try {
            switch (type) {
                case 0: {
                    value = this.cms.readRMS(this.address, hwChan);
                    break;
                }
                case 1: {
                    value = this.cms.readAC(this.address, hwChan);
                    break;
                }
                case 2: {
                    value = this.cms.readDC(this.address, hwChan);
                }
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading CMS100 data: {0}", e);
            this.setOnline(false);
        }
        return value;
    }

    static {
        cTypeMap.put("SERIAL", Modbus.ConnType.SERIAL);
        cTypeMap.put("FTDI", Modbus.ConnType.FTDI);
        sTypeMap = new HashMap<String, Integer>();
        sTypeMap.put("RMS", 0);
        sTypeMap.put("AC", 1);
        sTypeMap.put("DC", 2);
        LOG = Logger.getLogger(CmsDevice.class.getName());
    }
}

