/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.refrig.A1000Device;
import org.lsst.ccs.subsystem.refrig.constants.VfdState;

public class SimA1000Device
extends A1000Device {
    private static final Logger LOG = Logger.getLogger(SimA1000Device.class.getName());
    private double frequency;

    @Override
    protected void initDevice() {
        this.fullName = this.getPath() + " (simulated A1000)";
    }

    @Override
    protected void initialize() {
        this.setOnline(true);
        LOG.log(Level.INFO, "Connected to {0}", this.fullName);
    }

    @Override
    protected void close() {
    }

    @Override
    public void setFrequency(double freq) {
        this.frequency = freq;
    }

    @Override
    public double getFrequency() {
        return this.frequency;
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.isOnline()) {
            switch (hwChan) {
                case 0: {
                    value = this.frequency;
                    break;
                }
                case 1: {
                    value = 1.0;
                    break;
                }
                case 2: {
                    value = 380.0;
                    break;
                }
                case 3: {
                    value = 29.0;
                }
            }
        }
        return value;
    }

    @Override
    public VfdState getState() {
        return VfdState.RUNNING;
    }
}

