/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.eaton;

import java.io.IOException;
import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.eaton.EpduG3;

public class TestEpduG3 {
    private static final PrintStream out = System.out;
    private final EpduG3 pdu = new EpduG3();

    @Command(description="Open connection to a PDU")
    public void open(@Argument(description="Connection type") Session.ConnType connType, @Argument(description="Device ID") String devcId, @Argument(description="User name") String userName, @Argument(description="Password") String password) throws DriverException {
        this.pdu.open(connType, devcId, userName, password);
    }

    @Command(description="Open connection to a PDU")
    public void open(@Argument(description="Connection type") Session.ConnType connType, @Argument(description="Device ID") String devcId) throws DriverException {
        this.pdu.open(connType, devcId);
    }

    @Command(description="Close the connection")
    public void close() throws DriverException {
        this.pdu.close();
    }

    @Command(description="Show the product name")
    public String product() throws DriverException {
        return this.pdu.getProductName();
    }

    @Command(description="Show the serial number")
    public String serial() throws DriverException {
        return this.pdu.getSerialNumber();
    }

    @Command(description="Show the firmware version")
    public String version() throws DriverException {
        return this.pdu.getFWVersion();
    }

    @Command(description="Show the temperature")
    public String temperature() throws DriverException {
        return String.format("%.2f C", this.pdu.readTemperature());
    }

    @Command(description="Show the phase count")
    public String phaseCount() throws DriverException {
        return String.format("Phase count: %s", this.pdu.getPhaseCount());
    }

    @Command(description="Show phase voltage")
    public String phaseVoltage(@Argument(description="Phase number") int phase) throws DriverException {
        return String.format("%.2f volts", this.pdu.readPhaseVoltage(phase));
    }

    @Command(description="Show all phase voltages")
    public String phaseVoltage() throws DriverException {
        double[] voltages = this.pdu.readPhaseVoltage();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < voltages.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.2f", j + 1, voltages[j]));
        }
        return text.toString();
    }

    @Command(description="Show phase current")
    public String phaseCurrent(@Argument(description="Phase number") int phase) throws DriverException {
        return String.format("%.3f amps", this.pdu.readPhaseCurrent(phase));
    }

    @Command(description="Show all phase currents")
    public String phaseCurrent() throws DriverException {
        double[] currents = this.pdu.readPhaseCurrent();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < currents.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.3f", j + 1, currents[j]));
        }
        return text.toString();
    }

    @Command(description="Show phase power")
    public String phasePower(@Argument(description="Phase number") int phase) throws DriverException {
        return String.format("%.1f watts", this.pdu.readPhasePower(phase));
    }

    @Command(description="Show all phase power values")
    public String phasePower() throws DriverException {
        double[] powers = this.pdu.readPhasePower();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < powers.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.1f", j + 1, powers[j]));
        }
        return text.toString();
    }

    @Command(description="Show the gang count")
    public String gangCount() throws DriverException {
        return String.format("Gang count: %s", this.pdu.getGangCount());
    }

    @Command(description="Show gang phase")
    public String gangPhase(@Argument(description="Gang number") int gang) throws DriverException {
        return String.format("Gang phase: %s", this.pdu.getGangPhase(gang));
    }

    @Command(description="Show all gang phases")
    public String gangPhase() throws DriverException {
        int[] phases = this.pdu.getGangPhase();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < phases.length; ++j) {
            if (j % 8 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %1s", j + 1, phases[j]));
        }
        return text.toString();
    }

    @Command(description="Show gang voltage")
    public String gangVoltage(@Argument(description="Gang number") int gang) throws DriverException {
        return String.format("%.2f volts", this.pdu.readGangVoltage(gang));
    }

    @Command(description="Show all gang voltages")
    public String gangVoltage() throws DriverException {
        double[] voltages = this.pdu.readGangVoltage();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < voltages.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.2f", j + 1, voltages[j]));
        }
        return text.toString();
    }

    @Command(description="Show gang current")
    public String gangCurrent(@Argument(description="Gang number") int gang) throws DriverException {
        return String.format("%.3f amps", this.pdu.readGangCurrent(gang));
    }

    @Command(description="Show all gang currents")
    public String gangCurrent() throws DriverException {
        double[] currents = this.pdu.readGangCurrent();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < currents.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.3f", j + 1, currents[j]));
        }
        return text.toString();
    }

    @Command(description="Show gang power")
    public String gangPower(@Argument(description="Gang number") int gang) throws DriverException {
        return String.format("%.1f watts", this.pdu.readGangPower(gang));
    }

    @Command(description="Show all gang power values")
    public String gangPower() throws DriverException {
        double[] powers = this.pdu.readGangPower();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < powers.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.1f", j + 1, powers[j]));
        }
        return text.toString();
    }

    @Command(description="Show the outlet count")
    public String outletCount() throws DriverException {
        return "Outlet count: " + this.pdu.getOutletCount();
    }

    @Command(description="Show outlet gang")
    public String outletGang(@Argument(description="Outlet number") int outlet) throws DriverException {
        return String.format("Outlet gang: %s", this.pdu.getOutletGang(outlet));
    }

    @Command(description="Show all outlet gangs")
    public String outletGang() throws DriverException {
        int[] gangs = this.pdu.getOutletGang();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < gangs.length; ++j) {
            if (j % 8 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %1s", j + 1, gangs[j]));
        }
        return text.toString();
    }

    @Command(description="Show the state of an outlet")
    public String outletState(@Argument(description="Outlet number") int outlet) throws DriverException {
        return this.pdu.isOutletOn(outlet) ? "on" : "off";
    }

    @Command(description="Show the state of all outlets")
    public String outletState() throws DriverException {
        boolean[] states = this.pdu.getOutletOnStates();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < states.length; ++j) {
            if (j % 6 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %s", j + 1, states[j] ? "on " : "off"));
        }
        return text.toString();
    }

    @Command(description="Turn outlet power on")
    public void outletOn(@Argument(description="Outlet number") int outlet) throws DriverException {
        this.pdu.powerOutletOn(outlet, 0);
    }

    @Command(description="Turn outlet power on")
    public void outletOn(@Argument(description="Outlet number") int outlet, @Argument(description="Delay (sec)") int delay) throws DriverException {
        this.pdu.powerOutletOn(outlet, delay);
    }

    @Command(description="Turn outlet power off")
    public void outletOff(@Argument(description="Outlet number") int outlet) throws DriverException {
        this.pdu.powerOutletOff(outlet, 0);
    }

    @Command(description="Turn outlet power off")
    public void outletOff(@Argument(description="Outlet number") int outlet, @Argument(description="Delay (sec)") int delay) throws DriverException {
        this.pdu.powerOutletOff(outlet, delay);
    }

    @Command(description="Show outlet current")
    public String outletCurrent(@Argument(description="Outlet number") int outlet) throws DriverException {
        return String.format("%.3f amps", this.pdu.readOutletCurrent(outlet));
    }

    @Command(description="Show all outlet currents")
    public String outletCurrent() throws DriverException {
        double[] currents = this.pdu.readOutletCurrent();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < currents.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.3f", j + 1, currents[j]));
        }
        return text.toString();
    }

    @Command(description="Show outlet power")
    public String outletPower(@Argument(description="Outlet number") int outlet) throws DriverException {
        return String.format("%.1f watts", this.pdu.readOutletPower(outlet));
    }

    @Command(description="Show all outlet power values")
    public String outletPower() throws DriverException {
        double[] powers = this.pdu.readOutletPower();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < powers.length; ++j) {
            if (j % 5 == 0) {
                text.append(j == 0 ? "" : "\n");
            }
            text.append(String.format("%5s: %6.1f", j + 1, powers[j]));
        }
        return text.toString();
    }

    @Command(description="Time outlet current reading")
    public String timeCurrent(@Argument(description="Outlet number") int outlet, @Argument(description="Read count") int count) throws DriverException {
        long startTime = System.currentTimeMillis();
        for (int j = 0; j < count; ++j) {
            this.pdu.readOutletCurrent(outlet);
        }
        long msec = System.currentTimeMillis() - startTime;
        return String.format("Rate = %.1f reads/sec", 1000.0 * (double)count / (double)msec);
    }

    @Command(description="Time outlet current reading")
    public String timeCurrent(@Argument(description="Read count") int count) throws DriverException {
        long startTime = System.currentTimeMillis();
        for (int j = 0; j < count; ++j) {
            this.pdu.readOutletCurrent();
        }
        long msec = System.currentTimeMillis() - startTime;
        return String.format("Rate = %.1f reads/sec", 1000.0 * (double)count / (double)msec);
    }

    @Command(description="Time temperature reading")
    public String timeTemperature(@Argument(description="Read count") int count) throws DriverException {
        long startTime = System.currentTimeMillis();
        for (int j = 0; j < count; ++j) {
            this.pdu.readTemperature();
        }
        long msec = System.currentTimeMillis() - startTime;
        return String.format("Rate = %.1f reads/sec", 1000.0 * (double)count / (double)msec);
    }

    @Command(description="Talk to the PDU interactively")
    public void talk() throws DriverException, IOException {
        String cmnd;
        out.println("Type ctrl-D to exit");
        ConsoleReader reader = new ConsoleReader();
        while ((cmnd = reader.readLine(this.pdu.getPrompt())) != null) {
            this.pdu.send(cmnd);
            String[] resp = this.pdu.receive();
            for (int j = 1; j < resp.length; ++j) {
                out.println(resp[j]);
            }
        }
        out.println();
    }
}

