/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class SimpleSimDevice
extends Device {
    private final Map<String, Integer> channelMap = new HashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) {
        int index = this.channelValues.size();
        this.channelMap.put(name, index);
        this.channelValues.add(Double.valueOf(index));
        return new int[]{index, 0};
    }

    protected double readChannel(int hwChan, int type) {
        return this.channelValues.get(type);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws RefrigException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new RefrigException("Invalid channel name");
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

