/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.PressureTemperatureUtils;

public class EvaporatorPressDevice
extends Device {
    public static final int CHAN_COLD1 = 0;
    public static final int CHAN_COLD2 = 1;
    public static final int NUM_CHANS = 2;
    private static final int x = 0;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService asas;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    private List<String> returnPressChans;
    private List<String> coldRtdChans;
    private String thermalSubsysName;
    private static final Logger LOG = Logger.getLogger(EvaporatorPressDevice.class.getName());
    private final List<Channel> returnPrsChannels = new ArrayList<Channel>();

    protected void initDevice() {
        if (this.returnPressChans == null || this.returnPressChans.size() != 2) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"returnPressChans", (String)"must contain 2 elements");
        }
        for (String chanName : this.returnPressChans) {
            Channel chan = this.allChannels.get(chanName);
            if (chan == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"returnPressChans", (String)("contains non-existent channel: " + chanName));
            }
            this.returnPrsChannels.add(chan);
        }
        if (this.thermalSubsysName == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"thermalSubsysName", (String)"has not been specified");
        }
        if (this.coldRtdChans == null || this.coldRtdChans.size() != 2) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"coldRtdChans", (String)"must contain 2 elements");
        }
        AgentPropertyPredicate app = new AgentPropertyPredicate("[agentName:" + this.thermalSubsysName + "]");
        this.asas.setAggregatePattern(app, this.coldRtdChans.get(0) + "|" + this.coldRtdChans.get(1));
        this.coldRtdChans.add(0, this.thermalSubsysName + "/" + this.coldRtdChans.get(0));
        this.coldRtdChans.add(1, this.thermalSubsysName + "/" + this.coldRtdChans.get(1));
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 2) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int hwChan, int type) {
        Double temp = (Double)this.asas.getLast(this.coldRtdChans.get(hwChan));
        temp = temp == null ? Double.NaN : temp;
        return PressureTemperatureUtils.evaluatePressure(temp) - this.returnPrsChannels.get(hwChan).getValue();
    }
}

