/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bk;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.bk.XLNSeries;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestXLN
extends TestScpi {
    private final XLNSeries bk = (XLNSeries)this.dev;
    private final int chanNum = 1;

    public TestXLN() {
        super((Scpi)new XLNSeries());
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.bk.setVoltage(value, 1);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage() throws DriverException {
        return "Voltage = " + this.bk.getVoltage(1);
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.bk.readVoltage(1);
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.bk.setVoltageLimit(value, 1);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String showVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.bk.getVoltageLimit(1);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.bk.setCurrent(value, 1);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent() throws DriverException {
        return "Current = " + this.bk.getCurrent(1);
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.bk.readCurrent(1);
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) throws DriverException {
        this.bk.setCurrentLimit(value, 1);
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public String showCurrentLimit() throws DriverException {
        return "Current limit = " + this.bk.getCurrentLimit(1);
    }

    @Command(name="setondelay", description="Set the output on delay")
    public void setOnDelay(@Argument(name="delay", description="Delay time (sec)") double delay) throws DriverException {
        this.bk.setOnDelay(delay, 1);
    }

    @Command(name="setoffdelay", description="Set the output off delay")
    public void setOffDelay(@Argument(name="delay", description="Delay time (sec)") double delay) throws DriverException {
        this.bk.setOffDelay(delay, 1);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state) throws DriverException {
        this.bk.setOutput(state == OnOff.ON, 1);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.bk.getOutput(1));
    }

    @Command(name="lock", description="Lock the front panel")
    public void lock() throws DriverException {
        this.bk.lockPanel(true);
    }

    @Command(name="unlock", description="Unlock the front panel")
    public void unlock() throws DriverException {
        this.bk.lockPanel(false);
    }

    @Command(name="showstatusword", description="Show the status word")
    public String showStatusWord() throws DriverException {
        return String.format("Status word = 0x%06x", this.bk.getStatusWord());
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum OnOff {
        OFF,
        ON;

    }
}

