/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentExecutionService;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MonitorUpdateTask {
    private final String name;
    private static final Logger LOG = Logger.getLogger(MonitorUpdateTask.class.getName());
    private final List<Channel> listOfChannels = new ArrayList<Channel>();
    private final Set<Alarm> listOfAlarms = new HashSet<Alarm>();
    private final Set<String> listOfGroups = new TreeSet<String>();
    private final Map<Device, Map<String, List<Channel>>> deviceGroupChannelMap = new HashMap<Device, Map<String, List<Channel>>>();
    private StateBundle currentState = new StateBundle(new Enum[0]);
    private volatile int nConsecutivePublish = 0;
    private volatile boolean disableUpdating = false;
    private final List<String> channels = new ArrayList<String>();
    private final Monitor monitor;
    private final AgentExecutionService agentExecutionService;
    private final Map<String, Serializable> dataAttributes = new HashMap<String, Serializable>();
    private final Object monitorUpdateLock = new Object();

    MonitorUpdateTask(String name, List<Channel> channels, Monitor monitor) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        this.monitor = monitor;
        this.name = name;
        this.listOfChannels.addAll(channels);
        for (Channel ch : this.listOfChannels) {
            this.channels.add(ch.getPath());
        }
        this.agentExecutionService = monitor.subsys.getAgentService(AgentExecutionService.class);
        this.dataAttributes.put("taskName", (Serializable)((Object)name));
    }

    List<Channel> configureTask(List<Channel> mapOfChannels) {
        mapOfChannels.removeIf(e -> {
            Channel channel = e;
            if (this.listOfChannels.contains(channel)) {
                String channelGroup = channel.getGroup();
                this.listOfGroups.add(channelGroup);
                Map groupChannelMap = this.deviceGroupChannelMap.getOrDefault(channel.getDevice(), new HashMap());
                List groupListOfChannels = groupChannelMap.getOrDefault(channelGroup, new ArrayList());
                groupListOfChannels.add(channel);
                Collections.sort(groupListOfChannels, (o1, o2) -> ((Channel)o1).getPath().compareTo(((Channel)o2).getPath()));
                groupChannelMap.put(channelGroup, groupListOfChannels);
                this.deviceGroupChannelMap.put(channel.getDevice(), groupChannelMap);
                return true;
            }
            return false;
        });
        this.dataAttributes.put("taskSize", Integer.valueOf(this.listOfChannels.size()));
        return mapOfChannels;
    }

    void updateAlarms() {
        for (Channel ch : this.listOfChannels) {
            if (ch.alarmHiA != null) {
                this.listOfAlarms.add(ch.alarmHiA);
            }
            if (ch.alarmLoA == null) continue;
            this.listOfAlarms.add(ch.alarmLoA);
        }
    }

    public void monitorPublish() {
        this.forceDataPublicationOnNextUpdates(1);
    }

    public void forceDataPublicationOnNextUpdates(int nUpdates) {
        if (this.nConsecutivePublish < nUpdates) {
            this.nConsecutivePublish = nUpdates;
        }
        LOG.log(Level.FINEST, "Requesting data to be published for the next {0} times. Actual: {1}", new Object[]{nUpdates, this.nConsecutivePublish});
    }

    public Future<Void> scheduleUpdateAndPublishNow() {
        return this.agentExecutionService.task(() -> this.monitorUpdate(false)).start();
    }

    public void monitorUpdate() {
        this.monitorUpdate(true);
    }

    public Future<Void> pausePeriodicUpdate() {
        return this.agentExecutionService.task(() -> {
            long start = System.currentTimeMillis();
            this.disableUpdating = true;
            Object object = this.monitorUpdateLock;
            synchronized (object) {
                long delta = System.currentTimeMillis() - start;
                LOG.log(Level.FINEST, "Pausing Monitoring {0} completed in {1} ms.", new Object[]{this.name, delta});
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumePeriodicUpdate() {
        Object object = this.monitorUpdateLock;
        synchronized (object) {
            this.disableUpdating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorUpdate(boolean isPeriodicInvocation) {
        Object object = this.monitorUpdateLock;
        synchronized (object) {
            boolean doPublishData;
            boolean bl = isPeriodicInvocation ? this.nConsecutivePublish-- > 0 : (doPublishData = true);
            if (this.disableUpdating && isPeriodicInvocation) {
                return;
            }
            int totalTasks = (Integer)this.dataAttributes.computeIfAbsent("totalTasks", a -> Integer.valueOf(this.monitor.getMonitorTasksList().size()));
            if (isPeriodicInvocation) {
                if (doPublishData) {
                    this.dataAttributes.put("publicationType", (Serializable)((Object)(totalTasks == 1 ? "scheduledFull" : "scheduledPartial")));
                } else {
                    this.dataAttributes.put("publicationType", (Serializable)((Object)"stateChange"));
                }
            } else {
                this.dataAttributes.put("publicationType", (Serializable)((Object)"triggered"));
            }
            long start = System.currentTimeMillis();
            long slowestChannelReadTime = -1L;
            String slowestChannelReadName = null;
            long slowestGroupReadTime = -1L;
            String slowestGroupReadName = null;
            long totalGroupReadTime = 0L;
            long totalChannelReadTime = 0L;
            for (Map.Entry<Device, Map<String, List<Channel>>> deviceEntry : this.deviceGroupChannelMap.entrySet()) {
                Device device = deviceEntry.getKey();
                for (Map.Entry<String, List<Channel>> entry : deviceEntry.getValue().entrySet()) {
                    long groupTime;
                    String deviceGroup = entry.getKey();
                    List<Channel> channelsInGroupForDevice = entry.getValue();
                    if (this.disableUpdating && isPeriodicInvocation) {
                        return;
                    }
                    long groupStart = System.currentTimeMillis();
                    if (device != null && device.isOnline()) {
                        if (this.getName().isEmpty() || deviceGroup.isEmpty()) {
                            device.readChannelGroup();
                        } else {
                            device.readChannelGroup(deviceGroup);
                        }
                    }
                    if ((groupTime = System.currentTimeMillis() - groupStart) > slowestGroupReadTime) {
                        slowestGroupReadTime = groupTime;
                        slowestGroupReadName = deviceGroup;
                    }
                    totalGroupReadTime += groupTime;
                    for (Channel ch : channelsInGroupForDevice) {
                        long channelTime;
                        if (this.disableUpdating && isPeriodicInvocation) {
                            return;
                        }
                        long channelStart = System.currentTimeMillis();
                        if (ch.getState() != DataProviderState.DISABLED) {
                            ch.readSensor();
                        }
                        if ((channelTime = System.currentTimeMillis() - channelStart) > slowestChannelReadTime) {
                            slowestChannelReadTime = channelTime;
                            slowestChannelReadName = ch.getPath();
                        }
                        totalChannelReadTime += channelTime;
                    }
                }
            }
            String readSummary = "Groups total read time: " + totalGroupReadTime + " ms";
            if (slowestGroupReadTime >= 0L) {
                readSummary = readSummary + " (slowest group: " + slowestGroupReadName + " " + slowestGroupReadTime + " ms)";
            }
            readSummary = readSummary + "\nChannels total read time: " + totalChannelReadTime + " ms";
            if (slowestChannelReadTime >= 0L) {
                readSummary = readSummary + " (slowest channel: " + slowestChannelReadName + " " + slowestChannelReadTime + " ms)";
            }
            StateBundle sb = new StateBundle(new Enum[0]);
            for (Channel ch : this.listOfChannels) {
                ch.checkLimits();
                if (ch.doNotPublish) continue;
                sb.setComponentState(ch.getPath(), new Enum[]{ch.getState()});
            }
            StateBundle diffState = sb.diffState(this.currentState);
            this.currentState = sb;
            Map statesMap = diffState.getComponentsWithState(DataProviderState.class);
            for (Alarm alarm : this.listOfAlarms) {
                alarm.setState();
            }
            if (doPublishData || !statesMap.isEmpty()) {
                KeyValueDataList keyValueDataList = new KeyValueDataList(this.dataAttributes);
                for (Channel ch : this.listOfChannels) {
                    double value;
                    if (!doPublishData && !statesMap.containsKey(ch.getPath()) || ch.doNotPublish) continue;
                    CCSTimeStamp ts = ch.getCCSTimeStamp();
                    if (ts != null && !Double.isNaN(value = ch.getValue())) {
                        keyValueDataList.addData(ch.getPath(), (Serializable)Double.valueOf(value), ts);
                    }
                    this.monitor.dataProviderDictionaryService.addMetadataForObject(keyValueDataList, DataProviderInfo.Attribute.STATE.getName(), ch.getState().name(), ch);
                }
                if (!keyValueDataList.getListOfKeyValueData().isEmpty() && this.monitor.readyToPublish) {
                    LOG.log(Level.FINER, "{0} publishing Monitor data for {1} key: {2} entries: {3}", new Object[]{this.name, this.monitor.subsys.getName(), keyValueDataList.getKey(), keyValueDataList.getListOfKeyValueData().size()});
                    this.monitor.subsys.publishSubsystemDataOnStatusBus((KeyValueData)keyValueDataList);
                }
            }
            long l = System.currentTimeMillis() - start;
            LOG.log(Level.FINE, "Monitoring loop {0} completed in {1} ms. \n{2}", new Object[]{this.name, l, readSummary});
        }
    }

    public String getName() {
        String n = this.name;
        if (n.startsWith("default")) {
            n = n.replace("default", "");
        }
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        return n;
    }

    public Set<Device> getDevices() {
        return this.deviceGroupChannelMap.keySet();
    }

    public Set<String> getGroupsForDevice(Device device) {
        return this.deviceGroupChannelMap.get(device).keySet();
    }

    public List<Channel> getChannelsForDeviceGroup(Device device, String group) {
        return this.deviceGroupChannelMap.get(device).get(group);
    }

    public List<Channel> getAllChannels() {
        return this.listOfChannels;
    }

    public Set<String> getAllGroups() {
        return this.listOfGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Monitor Task: ").append(this.getName()).append("\n");
        for (Map.Entry<Device, Map<String, List<Channel>>> deviceEntry : this.deviceGroupChannelMap.entrySet()) {
            Device device = deviceEntry.getKey();
            sb.append("Device: ").append(device != null ? device.getName() : "no device").append("\n");
            for (Map.Entry<String, List<Channel>> groupEntry : deviceEntry.getValue().entrySet()) {
                String deviceGroup = groupEntry.getKey();
                List<Channel> channelsInGroupForDevice = groupEntry.getValue();
                sb.append("   Channels in group: ").append(deviceGroup).append("\n");
                int count = 0;
                for (Channel ch : channelsInGroupForDevice) {
                    sb.append("    ").append(count).append(" ").append(ch.getPath()).append("\n");
                    ++count;
                }
            }
        }
        return sb.toString();
    }
}

