/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class ComCamTelemetrySender
extends TelemetrySender {
    private final GenericConverter converter;

    public ComCamTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);
        HashMap<String, String> nameChange = new HashMap<String, String>();
        nameChange.put("ionpumpsvoltage", "ionpumpvoltage");
        nameChange.put("ionpumpscurrent", "ionpumpcurrent");
        nameChange.put("turborpm", "rpm");
        nameChange.put("pdu5votm3bi", "otm0bi");
        nameChange.put("pdu5votm3bv", "otm0bv");
        nameChange.put("pdu5votm3ai", "otm0ai");
        nameChange.put("pdu5votm3av", "otm0av");
        nameChange.put("steppermotor_motortemperature", "motorTemperature");
        nameChange.put("steppermotor_motorencoder", "motorEncoder");
        nameChange.put("linearencoder_linearposition", "linearPosition");
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-vacuum");
        subSystems.add("comcam-rebpower");
        subSystems.add("comcam-quadbox");
        subSystems.add("comcam-daq-monitor");
        subSystems.add("comcam-fp");
        subSystems.add("comcam-fcs");
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("CCCamera_comcam-daq-monitor_Store", Daq_monitor_StoreTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Reb", Focal_plane_RebTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Ccd", Focal_plane_CcdTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Segment", Focal_plane_SegmentTelemetry.class);
        classMap.put("CCCamera_comcam-fp_RebTotalPower", Focal_plane_RebTotalPowerTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Turbo", Vacuum_TurboTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cold1", Vacuum_Cold1Telemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cold2", Vacuum_Cold2Telemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cryo", Vacuum_CryoTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_VQMonitor", Vacuum_VQMonitorTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_IonPumps", Vacuum_IonPumpsTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Rtds", Vacuum_RtdsTelemetry.class);
        classMap.put("CCCamera_comcam-fcs", FcsTelemetry.class);
        Mapping mapping = Mapping.defaultMapping();
        this.converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return this.converter;
    }
}

