/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryDataChain;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationLoadedData;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.remote.LocalToRemoteMigrationDAO;
import org.lsst.ccs.config.remote.RestFileServerRemoteDAO;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationDAOWrapper
implements ConfigurationListener,
Closeable {
    private static final Logger LOG = Logger.getLogger(ConfigurationDAOWrapper.class.getName());
    private final ConfigurationService configurationService;
    private final ConfigurationDAO configurationDao;
    private final Map<SingleCategoryTag, SingleCategoryTagData> newLoadedViewsBySourceAndByCategory = new ConcurrentHashMap<SingleCategoryTag, SingleCategoryTagData>();
    private final Map<SingleCategoryTag, SingleCategoryTagData> pendingLoadedViewsBySource = new ConcurrentHashMap<SingleCategoryTag, SingleCategoryTagData>();
    private volatile ConfigurationDescription pendingConfigDescription = null;

    ConfigurationDAOWrapper(String descriptionName, ConfigurationService configurationService) {
        Properties props;
        String dao;
        this.configurationService = configurationService;
        if (configurationService != null) {
            configurationService.addConfigurationListener(this);
        }
        if ((dao = (props = BootstrapResourceUtils.getBootstrapSystemProperties()).getProperty("org.lsst.ccs.config.remote", "")).isEmpty()) {
            dao = props.getProperty("org.lsst.ccs.remote", "false");
        }
        this.configurationDao = dao.equalsIgnoreCase("true") ? new RestFileServerRemoteDAO(descriptionName) : (dao.equalsIgnoreCase("migrate") ? new LocalToRemoteMigrationDAO(descriptionName) : new LocalConfigurationDAO());
    }

    ConfigurationDAOWrapper(String descriptionName) {
        this(descriptionName, null);
    }

    Properties getConfigurationProperties(SingleCategoryTag singleCategoryTag) throws ConfigurationServiceException {
        Properties res = new Properties();
        try {
            SingleCategoryTagData data = this.configurationDao.loadCategoryTag(singleCategoryTag);
            res.putAll((Map<?, ?>)data.getConfigurationData());
        }
        catch (ConfigurationServiceException e) {
            LOG.log(Level.FINE, "Unable to load build configuration " + singleCategoryTag, e);
        }
        return res;
    }

    public ConfigurationLoadedData initialLoadConfiguration(ConfigurationDescription configDescription, boolean failOnException) {
        ConfigurationLoadedData viewResult = this.loadConfiguration(configDescription, failOnException);
        this.updatePendingInformation();
        return viewResult;
    }

    public ConfigurationLoadedData loadConfiguration(ConfigurationDescription configDescription) throws ConfigurationServiceException {
        return this.loadConfiguration(configDescription, true);
    }

    private ConfigurationLoadedData loadConfiguration(ConfigurationDescription configDescription, boolean failOnException) throws ConfigurationServiceException {
        ConfigurationLoadedData loadedData = new ConfigurationLoadedData();
        try {
            for (String category : configDescription.getCategoriesSet()) {
                CategoryDescription categoryTag = configDescription.getCategoryTag(category);
                CategoryDataChain categoryDataChain = new CategoryDataChain(category);
                for (SingleCategoryTag singleCategoryTag : categoryTag.getSingleCategoryTags()) {
                    if (singleCategoryTag.getSource() == null || singleCategoryTag.getSource().isEmpty()) {
                        throw new IllegalArgumentException("Cannot load data with an empty source: " + singleCategoryTag);
                    }
                    try {
                        SingleCategoryTagData tagData;
                        block13: {
                            tagData = new SingleCategoryTagData(singleCategoryTag);
                            try {
                                tagData = this.configurationDao.loadCategoryTag(singleCategoryTag);
                            }
                            catch (ConfigurationServiceException ex) {
                                if (!failOnException) break block13;
                                throw ex;
                            }
                        }
                        Map loadedDataForTag = tagData.getConfigurationData();
                        Iterator iterator = loadedDataForTag.entrySet().iterator();
                        ArrayList<Object> removedParameters = new ArrayList<Object>();
                        while (iterator.hasNext()) {
                            Map.Entry e = iterator.next();
                            String parameterPath = (String)e.getKey();
                            boolean bl = parameterPath.contains(".") && !parameterPath.contains("/");
                            if (bl || this.configurationService.getParameterByPath(ParameterPath.valueOf((String)parameterPath)).getCategory().equals(tagData.getSingleCategoryTag().getCategory())) continue;
                            iterator.remove();
                            removedParameters.add(parameterPath);
                        }
                        if (!removedParameters.isEmpty()) {
                            StringBuilder sb = new StringBuilder("The following parameters don't belong to category " + singleCategoryTag.getCategory() + "\n");
                            for (String string : removedParameters) {
                                sb.append(string).append("\n");
                            }
                            sb.append("Please remove them from ").append(singleCategoryTag.toString());
                            LOG.log(Level.WARNING, sb.toString());
                            if (failOnException) {
                                RuntimeException re = new RuntimeException(sb.toString());
                                throw new ConfigurationServiceException("Could not load " + singleCategoryTag, (Throwable)re);
                            }
                        }
                        configDescription.putSingleTagForCategory(category, singleCategoryTag, tagData.getSingleCategoryTag().getVersion());
                        this.pendingLoadedViewsBySource.put(singleCategoryTag, tagData);
                        categoryDataChain.addSingleCategoryTagData(tagData);
                    }
                    catch (ConfigurationServiceException ex) {
                        if (!failOnException) continue;
                        throw ex;
                    }
                }
                loadedData.putCategoryDataChain(categoryDataChain);
            }
            this.pendingConfigDescription = configDescription;
        }
        catch (Exception e) {
            this.pendingLoadedViewsBySource.clear();
            this.pendingConfigDescription = null;
            throw e;
        }
        return loadedData;
    }

    public ConfigurationDescription saveChangesForCategoriesAs(ConfigurationDescription configDesc, ConfigurationInfo configInfo, boolean fullConfiguration) throws ConfigurationServiceException {
        List sourcedTags;
        ConfigurationView currentView = this.configurationService.getCurrentConfigurationView();
        if (!fullConfiguration) {
            for (String category : configDesc.getCategoriesSet()) {
                HashMap loadedDataBelowRightmostTag = new HashMap();
                CategoryDescription catTag = configDesc.getCategoryTag(category);
                sourcedTags = catTag.getSingleCategoryTags();
                for (SingleCategoryTag singleCategoryTag : sourcedTags) {
                    boolean isLastTag;
                    boolean bl = isLastTag = sourcedTags.indexOf(singleCategoryTag) == sourcedTags.size() - 1;
                    if (isLastTag) continue;
                    loadedDataBelowRightmostTag.putAll(this.newLoadedViewsBySourceAndByCategory.get(singleCategoryTag).getConfigurationData());
                }
                for (Map.Entry entry : loadedDataBelowRightmostTag.entrySet()) {
                    ParameterPath path = ParameterPath.valueOf((String)((String)entry.getKey()));
                    if (!currentView.containsPath(path) || !this.isObjectValueEqual(path, currentView.getPathValue(path), (String)entry.getValue())) continue;
                    currentView.removeValueForPath(path);
                }
            }
        }
        ConcurrentHashMap<SingleCategoryTag, SingleCategoryTagData> dataToBeSavedByByCategoryTag = new ConcurrentHashMap<SingleCategoryTag, SingleCategoryTagData>();
        for (Map.Entry lastLoadedValues : currentView.getAsParameterPathMap().entrySet()) {
            ParameterPath pp = (ParameterPath)lastLoadedValues.getKey();
            String currentViewValue = (String)lastLoadedValues.getValue();
            String parameterCategory = configInfo.getCurrentParameterInfo(pp.toString()).getCategoryName();
            CategoryDescription categoryDescription = configDesc.getCategoryTag(parameterCategory);
            if (categoryDescription == null) continue;
            List sourcedTags2 = categoryDescription.getSingleCategoryTags();
            SingleCategoryTag singleCategoryTag = (SingleCategoryTag)sourcedTags2.get(sourcedTags2.size() - 1);
            SingleCategoryTagData lastLoadedViewForKey = dataToBeSavedByByCategoryTag.computeIfAbsent(singleCategoryTag, k -> {
                SingleCategoryTagData loadedData = this.newLoadedViewsBySourceAndByCategory.computeIfAbsent(singleCategoryTag, j -> new SingleCategoryTagData(singleCategoryTag));
                SingleCategoryTagData dataToSave = new SingleCategoryTagData(loadedData);
                dataToSave.getConfigurationData().clear();
                return dataToSave;
            });
            if (this.configurationService.configurationHandler.isParameterReadOnly(pp.getComponentName(), pp.getParameterName())) {
                lastLoadedViewForKey.getConfigurationData().remove(pp.toString());
                continue;
            }
            lastLoadedViewForKey.getConfigurationData().put(pp.toString(), currentViewValue);
        }
        for (String category : configDesc.getCategoriesSet()) {
            CategoryDescription categoryTag = configDesc.getCategoryTag(category);
            sourcedTags = categoryTag.getSingleCategoryTags();
            SingleCategoryTag singleCategoryTag = (SingleCategoryTag)sourcedTags.get(sourcedTags.size() - 1);
            SingleCategoryTagData singleCategoryTagData = this.newLoadedViewsBySourceAndByCategory.getOrDefault(singleCategoryTag, new SingleCategoryTagData(singleCategoryTag));
            SingleCategoryTagData dataToBeSaved = dataToBeSavedByByCategoryTag.getOrDefault(singleCategoryTag, new SingleCategoryTagData(singleCategoryTag));
            SingleCategoryTagData saveData = new SingleCategoryTagData(dataToBeSaved);
            if (category.equals("build")) {
                SingleCategoryTagData buildProperties = this.configurationDao.loadCategoryTag(singleCategoryTag);
                buildProperties.mergeSingleCategoryTagData(saveData);
                saveData = buildProperties;
            }
            if (!this.isCategoryTagDataEqual(singleCategoryTagData, saveData)) {
                if (singleCategoryTag.getSource() == null || singleCategoryTag.getSource().isEmpty()) {
                    throw new IllegalArgumentException("Cannot load data with an empty source: " + singleCategoryTag);
                }
                SingleCategoryTag res = this.configurationDao.saveCategoryTagData(saveData);
                this.newLoadedViewsBySourceAndByCategory.put(singleCategoryTag, dataToBeSaved);
                configDesc.putSingleTagForCategory(category, res, res.getVersion());
                continue;
            }
            LOG.log(Level.INFO, "No configuration changes need to be saved for category tag: {0}", singleCategoryTag);
        }
        return configDesc;
    }

    private void resentPendingInformation() {
        this.pendingLoadedViewsBySource.clear();
        this.pendingConfigDescription = null;
    }

    private void updatePendingInformation() {
        for (String category : this.pendingConfigDescription.getCategoriesSet()) {
            for (SingleCategoryTag singleCategoryTag : this.newLoadedViewsBySourceAndByCategory.keySet()) {
                if (!singleCategoryTag.getCategory().equals(category)) continue;
                this.newLoadedViewsBySourceAndByCategory.remove(singleCategoryTag);
            }
        }
        this.newLoadedViewsBySourceAndByCategory.putAll(this.pendingLoadedViewsBySource);
        this.resentPendingInformation();
    }

    @Override
    public void failedConfigurationOperation(ConfigurationInfo configurationInfo, ConfigurationListener.ConfigurationOperation configurationOperation, Exception ex) {
        if (configurationOperation == ConfigurationListener.ConfigurationOperation.LOAD && ex != null) {
            this.resentPendingInformation();
        }
    }

    @Override
    public void configurationChanged(ConfigurationInfo ci, ConfigurationInfo oldci, ConfigurationListener.ConfigurationOperation configurationOperation) {
        if (configurationOperation == ConfigurationListener.ConfigurationOperation.LOAD) {
            if (this.pendingLoadedViewsBySource.isEmpty()) {
                this.resentPendingInformation();
                return;
            }
            this.updatePendingInformation();
        }
    }

    @Override
    public void close() {
        if (this.configurationDao != null) {
            this.configurationDao.close();
        }
    }

    private boolean isCategoryTagDataEqual(SingleCategoryTagData data1, SingleCategoryTagData data2) {
        Map map1 = data1.getConfigurationData();
        Map map2 = data2.getConfigurationData();
        boolean isBuildCategory = data1.getSingleCategoryTag().getCategory().equals("build");
        if (map1.size() != map2.size()) {
            return false;
        }
        if (!map1.keySet().equals(map2.keySet())) {
            return false;
        }
        for (Map.Entry e : map1.entrySet()) {
            String path = (String)e.getKey();
            try {
                ParameterPath pp = ParameterPath.valueOf((String)path);
                if (this.isObjectValueEqual(pp, (String)e.getValue(), (String)map2.get(path))) continue;
                return false;
            }
            catch (Exception ex) {
                if (isBuildCategory) continue;
                throw ex;
            }
        }
        return true;
    }

    private boolean isObjectValueEqual(ParameterPath pp, String str1, String str2) {
        ConfigurationParameterHandler parHandler = this.configurationService.configurationHandler.getConfigurationParameterHandler(pp);
        Object obj1 = parHandler.convert(str1).getValue();
        Object obj2 = parHandler.convert(str2).getValue();
        if (obj1 == null && obj2 != null) {
            return false;
        }
        return obj1 == null || Objects.deepEquals(obj1, obj2);
    }
}

