/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.raes;

import de.schlichtherle.crypto.io.CipherOutputStream;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesParametersAgent;
import de.schlichtherle.crypto.io.raes.RaesParametersException;
import de.schlichtherle.crypto.io.raes.Type0RaesOutputStream;
import de.schlichtherle.crypto.io.raes.Type0RaesParameters;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.Mac;

public abstract class RaesOutputStream
extends CipherOutputStream {
    static final /* synthetic */ boolean $assertionsDisabled;

    static void klac(Mac klac, long length, byte[] buf) {
        for (int i = 0; i < 8; ++i) {
            klac.update((byte)length);
            length >>= 8;
        }
        int bufLen = klac.doFinal(buf, 0);
        if (!$assertionsDisabled && bufLen != buf.length) {
            throw new AssertionError();
        }
    }

    public static RaesOutputStream getInstance(OutputStream out, RaesParameters parameters) throws NullPointerException, IllegalArgumentException, RaesParametersException, IOException {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (parameters == null) {
            throw new RaesParametersException();
        }
        if (parameters instanceof Type0RaesParameters) {
            return new Type0RaesOutputStream(out, (Type0RaesParameters)parameters);
        }
        if (parameters instanceof RaesParametersAgent) {
            parameters = ((RaesParametersAgent)parameters).getParameters(RaesParameters.class);
            return RaesOutputStream.getInstance(out, parameters);
        }
        throw new RaesParametersException();
    }

    RaesOutputStream(OutputStream out, BufferedBlockCipher cipher) {
        super(out, cipher);
    }

    public abstract int getKeySizeBits();

    static {
        $assertionsDisabled = !RaesOutputStream.class.desiredAssertionStatus();
    }
}

