/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.A1000Device;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.constants.ColdCompValves;
import org.lsst.ccs.subsystem.refrig.constants.OilSepHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.constants.VfdState;
import org.lsst.ccs.subsystem.refrig.data.ColdCompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class ColdCompressor
extends Compressor {
    private static final int[] maqChannels = new int[3];
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private A1000Device vfdDevc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile int discPressDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double liquidTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double liquidTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile int liquidTempDelayTime;
    private String liquidTempChan;
    private static final Logger LOG;
    private final ColdCompState coldState = (ColdCompState)this.getState();

    public ColdCompressor() {
        super(new ColdCompState());
    }

    public void build() {
        this.stateService.registerState(OilSepHeaterState.class, "Oil separator heater state", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{OilSepHeaterState.OFFLINE});
    }

    @Override
    public void postInit() {
        Channel liquidTemp;
        if (this.vfdDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"vfdDevc", (String)"not specified");
        }
        this.switchDevices[1] = this.maq20Devc;
        this.switchChannels[1] = 1;
        Channel channel = liquidTemp = this.liquidTempChan != null ? (Channel)this.channelMap.get(this.liquidTempChan) : null;
        if (liquidTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"liquidTempChan", (String)"not specified or not defined");
        }
        this.limitData[7].channel = liquidTemp;
        super.postInit();
    }

    @ConfigurationParameterChanger
    public void setLiquidTempImmedLimit(double value) {
        this.liquidTempImmedLimit = value;
        this.limitData[7].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayLimit(double value) {
        this.liquidTempDelayLimit = value;
        this.limitData[7].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayTime(int value) {
        this.liquidTempDelayTime = value;
        this.limitData[7].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setDiscPressDelayTime(int value) {
        this.discPressDelayTime = value;
        this.limitData[0].delayTime = 1000 * value;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the valid valve names", level=0)
    public List<String> getValveNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String vName : ColdCompValves.NAME_MAP.keySet()) {
            names.add(vName);
        }
        return names;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a cold compressor's valve position")
    public synchronized void setValvePosition(@Argument(description="Valve name") String valve, @Argument(description="Valve position") double posn) throws RefrigException {
        this.gotCommand = true;
        Integer valveId = ColdCompValves.NAME_MAP.get(valve);
        if (valveId == null) {
            throw new RefrigException("Invalid cold valve name: " + valve);
        }
        this.maq20Devc.setValvePosition(maqChannels[valveId], posn);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a cold compressor's VFD frequency")
    public synchronized void setVfdFrequency(@Argument(description="Frequency") double freq) throws RefrigException {
        this.gotCommand = true;
        this.vfdDevc.setFrequency(freq);
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a cold compressor's VFD fault")
    public synchronized void resetVfdFault() throws RefrigException {
        this.gotCommand = true;
        this.vfdDevc.resetFault();
    }

    @Override
    protected synchronized boolean updateState() {
        VfdState vfdState;
        boolean changed = super.updateState();
        if (changed) {
            SwitchState swState = this.coldState.getSwitchState(1);
            OilSepHeaterState osState = swState == SwitchState.ON ? OilSepHeaterState.ON : (swState == SwitchState.OFF ? OilSepHeaterState.OFF : OilSepHeaterState.OFFLINE);
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{osState});
        }
        for (int valveId = 0; valveId < 3; ++valveId) {
            double posn = this.maq20Devc.getValvePosition(maqChannels[valveId]);
            if (this.areEqual(posn, this.coldState.getValvePosition(valveId))) continue;
            this.coldState.setValvePosition(valveId, posn);
            changed = true;
        }
        double freq = this.vfdDevc.getFrequency();
        if (!this.areEqual(freq, this.coldState.getVfdFrequency())) {
            this.coldState.setVfdFrequency(freq);
            changed = true;
        }
        if ((vfdState = this.vfdDevc.getState()) != this.coldState.getVfdState()) {
            this.coldState.setVfdState(vfdState);
            changed = true;
        }
        return changed;
    }

    static {
        ColdCompressor.maqChannels[0] = 0;
        ColdCompressor.maqChannels[1] = 2;
        ColdCompressor.maqChannels[2] = 1;
        LOG = Logger.getLogger(ColdCompressor.class.getName());
    }
}

