/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

public class DictionaryProvider
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(DictionaryProvider.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dpdService;
    private final Listener listener = new Listener();
    private final Map<String, SALClassDescription> salClassDescriptions = new HashMap<String, SALClassDescription>();

    public void start() {
        this.dpdService.addDataProviderDictionaryListener((DataProviderDictionaryService.DataProviderDictionaryListener)this.listener);
    }

    Map<String, SALClassDescription> getStatusClassDescriptions() {
        return this.salClassDescriptions;
    }

    private class Listener
    implements DataProviderDictionaryService.DataProviderDictionaryListener {
        Mapping mapping = Mapping.defaultMapping();

        private Listener() {
        }

        public void dataProviderDictionaryUpdate(DataProviderDictionaryService.DataProviderDictionaryEvent evt) {
            try {
                AgentInfo.AgentType type;
                if (evt.getEventType() == DataProviderDictionaryService.DataProviderDictionaryEvent.EventType.ADDED && ((type = evt.getAgentInfo().getType()) == AgentInfo.AgentType.WORKER || type == AgentInfo.AgentType.SERVICE)) {
                    String name = evt.getAgentInfo().getName();
                    DataProviderDictionary dictionary = evt.getDictionary();
                    SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary, "CCCamera", name, 1, this.mapping, "MONITORING", "trending");
                    DictionaryProvider.this.salClassDescriptions.putAll(maker.getSALClassDescriptions());
                    LOG.log(Level.INFO, "Added dictionary for {0}", name);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception adding dictionary", t);
            }
        }
    }
}

