/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ifountain.opsgenie.client.OpsGenieClientException;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.http.OpsGenieHttpClient;
import com.ifountain.opsgenie.client.http.OpsGenieHttpResponse;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.rest.HttpMethod;
import com.ifountain.opsgenie.client.rest.ResponseHandler;
import com.ifountain.opsgenie.client.rest.response.RestFailureResult;
import com.ifountain.opsgenie.client.rest.response.RestSuccessResult;
import com.ifountain.opsgenie.client.util.JsonUtils;
import com.ifountain.opsgenie.client.util.LogUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.http.HttpEntity;

public class RestApiRequest {
    private static final String AUTHENTICATION_TOKEN_TYPE = "GenieKey";
    private static final String REQUEST_ID_HEADER = "X-Request-ID";
    private static final String RESPONSE_TIME_HEADER = "X-Response-Time";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Log logger;
    private final OpsGenieHttpClient httpClient;
    private Object body;
    private String uri;
    private String rootUri;
    private ResponseHandler responseHandler = new DefaultResponseHandler();
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpMethod httpMethod;
    private String rootApiKey;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    RestApiRequest(HttpMethod httpMethod, OpsGenieHttpClient httpClient, Log logger, String rootUri) {
        this.httpMethod = httpMethod;
        this.httpClient = httpClient;
        this.logger = logger;
        this.rootUri = rootUri;
    }

    public RestApiRequest httpEntity(HttpEntity entity) {
        this.body = entity;
        return this;
    }

    public RestApiRequest content(String content) {
        this.body = content;
        return this;
    }

    public RestApiRequest json(Object json) throws IOException, ParseException {
        this.body = json;
        this.headers.put("Content-Type", "application/json; charset=utf-8");
        return this;
    }

    public RestApiRequest apiKey(String genieKey) {
        this.rootApiKey = genieKey;
        return this;
    }

    private void setGenieKey(String genieKey) {
        this.headers.put("Authorization", "GenieKey " + genieKey);
    }

    public RestApiRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    public RestApiRequest responseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public RestApiRequest addParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public RestApiRequest parameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    private void validate() {
        this.assertNotNull(this.logger, "log");
        this.assertNotNull(this.httpClient, "httpClient");
        this.assertNotBlank(this.uri, "uri");
    }

    private void assertNotNull(Object field, String name) {
        if (field == null) {
            throw new IllegalStateException(name + " cannot be null");
        }
    }

    private void assertNotBlank(String field, String name) {
        if (field == null || field.trim().isEmpty()) {
            throw new IllegalStateException(name + " cannot be blank");
        }
    }

    public <T> RestSuccessResult<T> getResponse(Class<T> claz) throws OpsGenieClientException, IOException, ParseException {
        BaseRequest baseRequest;
        this.validate();
        this.logger.info((Object)("Executing OpsGenie " + (Object)((Object)this.httpMethod) + " request to [" + this.uri + "] with Parameters " + LogUtils.getInsensitiveLogMessage(this.parameters) + ", Headers " + this.headers));
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.setGenieKey(this.rootApiKey);
        if (this.body instanceof BaseRequest && (baseRequest = (BaseRequest)this.body).getApiKey() != null && !baseRequest.getApiKey().trim().isEmpty()) {
            this.setGenieKey(baseRequest.getApiKey());
        }
        OpsGenieHttpResponse response = null;
        try {
            if (this.httpMethod == HttpMethod.GET) {
                response = this.get();
            } else if (this.httpMethod == HttpMethod.DELETE) {
                response = this.delete();
            } else if (this.httpMethod == HttpMethod.POST) {
                response = this.post();
            } else if (this.httpMethod == HttpMethod.PATCH) {
                response = this.patch();
            }
        }
        catch (URISyntaxException e) {
            throw new OpsGenieClientValidationException("Invalid [name] or [id]", 400);
        }
        if (this.responseHandler != null) {
            this.responseHandler.handleResponse(response);
        }
        T data = this.convertObject(response.getContent(), claz);
        RestSuccessResult<T> result = new RestSuccessResult<T>();
        result.setData(data).setRawData(response.getContentAsString()).setStatusCode(response.getStatusCode());
        if (response.getHeaders().containsKey(REQUEST_ID_HEADER)) {
            result.setRequestId(response.getHeaders().get(REQUEST_ID_HEADER));
        }
        if (response.getHeaders().containsKey(RESPONSE_TIME_HEADER)) {
            try {
                result.setTook(Double.valueOf(response.getHeaders().get(RESPONSE_TIME_HEADER)));
            }
            catch (NumberFormatException e) {
                this.logger.debug((Object)"Number format exception while parsing Response Time header", (Throwable)e);
            }
        }
        return result;
    }

    private OpsGenieHttpResponse get() throws IOException, URISyntaxException, OpsGenieClientException {
        return this.httpClient.get(this.generateUrl(), this.parameters, this.headers);
    }

    private OpsGenieHttpResponse post() throws IOException, OpsGenieClientException, ParseException {
        return this.body != null && this.body instanceof HttpEntity ? this.postWithBodyAsHttpEntity() : this.postWithBodyAsJson();
    }

    private OpsGenieHttpResponse postWithBodyAsHttpEntity() throws IOException, OpsGenieClientException {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            return this.httpClient.post(this.generateUrl(), (HttpEntity)this.body, this.headers, this.parameters);
        }
        return this.httpClient.post(this.generateUrl(), (HttpEntity)this.body, this.headers);
    }

    private OpsGenieHttpResponse postWithBodyAsJson() throws IOException, ParseException, OpsGenieClientException {
        String json = JsonUtils.toJson(this.body);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            return this.httpClient.post(this.generateUrl(), json, this.headers, this.parameters);
        }
        return this.httpClient.post(this.generateUrl(), json, this.headers);
    }

    private OpsGenieHttpResponse delete() throws IOException, OpsGenieClientException {
        return this.httpClient.delete(this.generateUrl(), this.parameters, this.headers);
    }

    private OpsGenieHttpResponse patch() throws IOException, ParseException, OpsGenieClientException {
        String json = JsonUtils.toJson(this.body);
        return this.httpClient.patch(this.generateUrl(), json, this.parameters, this.headers);
    }

    private <T> T convertObject(byte[] json, Class<T> claz) throws IOException {
        TypeReference typeReference = new TypeReference<RestSuccessResult<Map<?, ?>>>(){};
        RestSuccessResult successResponse = (RestSuccessResult)MAPPER.readValue(json, typeReference);
        Map data = (Map)successResponse.getData();
        return (T)MAPPER.convertValue((Object)data, claz);
    }

    private String generateUrl() {
        return this.rootUri + this.uri;
    }

    private static class DefaultResponseHandler
    implements ResponseHandler {
        private DefaultResponseHandler() {
        }

        @Override
        public void handleResponse(OpsGenieHttpResponse response) throws OpsGenieClientException, IOException {
            if (response.getStatusCode() < 200 || response.getStatusCode() > 299) {
                String contentType = response.getHeaders().get("Content-Type");
                if (contentType != null && contentType.toLowerCase().startsWith("application/json")) {
                    RestFailureResult result = (RestFailureResult)MAPPER.readValue(response.getContentAsString(), RestFailureResult.class);
                    result.setRawData(response.getContentAsString());
                    result.setStatusCode(response.getStatusCode());
                    int code = result.getCode() != null ? result.getCode().intValue() : response.getStatusCode();
                    throw new OpsGenieClientException(result.getMessage(), code);
                }
                throw new IOException(new String(response.getContent(), "UTF-8"));
            }
        }
    }
}

