/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcam.filterchanger;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.nanotec.NanotecPD4N;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class NanotecPD4NDevice
extends Device
implements ConfigurationBulkChangeHandler {
    private final NanotecPD4N pd4n = new NanotecPD4N();
    private static final Logger LOG = Logger.getLogger(NanotecPD4NDevice.class.getName());
    private Map<Integer, String> chanMap = new HashMap<Integer, String>();
    private Integer chanKey;
    private final int LIMIT_STOP = 9250;
    private final int LIMIT_FREE = 5154;
    private final double fullStep = 1.8;
    private final double screwLead = 4.0;
    private final double scale = 100.0;
    private final int encoderDir = 1;
    private final double maxDevDistance = 0.1;
    private final int encoderMaxDev = 10;
    private final int errCorr = 0;
    private final int errCorrRec = 0;
    private final int encoderSettleTime = 8;
    private final int digitalLinePolarities = 458812;
    private final int debounceTime = 10;
    private final int minMinStepFreq = 100;
    private int posMode = 1;
    private int stepFreq2 = 1000;
    private int dirChangeRepeat = 0;
    private int repeatCount = 1;
    private int repeatPause = 0;
    private int contRecNum = 0;
    @ConfigurationParameter(isFinal=true, category="Motor", description="phase current % (of 3.2 Amps)", units="unitless")
    private volatile Integer iPhase;
    @ConfigurationParameter(isFinal=true, category="Motor", description="phase current % at standstill", units="unitless")
    private volatile Integer iPhaseStill;
    @ConfigurationParameter(isFinal=true, category="Motor", description="1/(steps per 1.8 deg)", units="unitless")
    private volatile Integer stepMode;
    @ConfigurationParameter(isFinal=true, category="Motor", units="n/a", description="true = back-off from limit switch")
    private volatile Boolean backOff;
    @ConfigurationParameter(category="Motor", units="unitless", description="reverse clearance (stepMode = 2)")
    private volatile Integer reverseClearance;
    @ConfigurationParameter(isFinal=true, category="Motor", description="ramp type (0=trapezoid, 2=jerk-free)", units="unitless")
    private volatile Integer rampType;
    @ConfigurationParameter(category="Motor", units="Hz/s", description="quick-stop ramp (Hz/s)")
    private volatile Integer quickRamp;
    @ConfigurationParameter(category="Motor", description="steps/s", units="Hz")
    private volatile Integer stepFreq;
    @ConfigurationParameter(category="Motor", description="initial steps/s", units="Hz")
    private volatile Integer minStepFreq;
    @ConfigurationParameter(category="Motor", units="Hz/s", description="acceleration ramp (Hz/s)")
    private volatile Integer accelRamp;
    @ConfigurationParameter(category="Motor", units="Hz/s", description="brake ramp (Hz/s), 0 if = accel")
    private volatile Integer brakeRamp;
    @ConfigurationParameter(isFinal=true, category="Motor", description="max accel jerk (unit 100/s^3)", units="100/s^3")
    private volatile Integer maxJerkAccel;
    @ConfigurationParameter(isFinal=true, category="Motor", description="max brake jerk (unit 100/s^3)", units="100/s^3")
    private volatile Integer maxJerkBrake;
    @ConfigurationParameter(isFinal=true, category="Motor", units="s", description="time limit (s) on each ramp")
    private volatile Double maxRampTime;
    @ConfigurationParameter(isFinal=true, description="port Id", units="n/a")
    private volatile String devcId;

    protected void initDevice() {
        this.chanKey = 0;
        this.fullName = "NanotecPD4N " + this.name + " (" + this.devcId + ")";
    }

    protected void initialize() {
        try {
            this.pd4n.open(this.devcId);
            this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.ERRCORR_MODE, 0);
            this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.ERRCORR_RECNUM, 0);
            this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.ENCODER_SETTLE_TIME, 8);
            this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.ENCODER_DIR, 1);
            this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.ENCODER_MAXDEV, 10 * this.stepMode / 2);
            this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.REVERSE_POLARITIES, 458812);
            this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.INPUT_DEBOUNCE_TIME, 10);
            this.pd4n.writeMotion(NanotecPD4N.CmndMotion.MODE, this.posMode);
            this.pd4n.writeMotion(NanotecPD4N.CmndMotion.FREQ2_MAX, this.stepFreq2);
            this.pd4n.writeMotion(NanotecPD4N.CmndMotion.DIR_CHANGE_FOR_REP, this.dirChangeRepeat);
            this.pd4n.writeMotion(NanotecPD4N.CmndMotion.REPETITIONS, this.repeatCount);
            this.pd4n.writeMotion(NanotecPD4N.CmndMotion.PAUSE_BETW_RECORDS, this.repeatPause);
            this.pd4n.writeMotion(NanotecPD4N.CmndMotion.CONTINUATION_RECNUM, this.contRecNum);
            this.writeConfigurableSettings();
            this.initSensors();
            LOG.info("NanotecPD4N " + this.name + " starting motor-encoder value = " + this.pd4n.readGeneral(NanotecPD4N.CmndGeneral.READ_ENCODER));
            LOG.info("\n Connected to " + this.fullName);
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe("Error connecting to or initializing " + this.fullName + ": " + (Object)((Object)e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.pd4n.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    void writeConfigurableSettings() throws DriverException {
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.PHASE_CURRENT, this.iPhase.intValue());
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.PHASE_CURRENT_STILL, this.iPhaseStill.intValue());
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.STEP_MODE, this.stepMode.intValue());
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.SWITCH_BEHAVIOR, this.backOff != false ? 5154 : 9250);
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.REVERSE_CLEARANCE, this.reverseClearance * this.stepMode / 2);
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.RAMP_TYPE, this.rampType.intValue());
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.QUICKSTOP_RAMP, this.quickRamp.intValue());
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.FREQUENCY_MAX, this.stepFreq * this.stepMode / 2);
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.FREQUENCY_MIN, this.minStepFreq * this.stepMode / 2);
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.RAMP_ACCEL, this.accelRamp * this.stepMode / 2);
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.RAMP_BRAKE, this.brakeRamp * this.stepMode / 2);
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.JERK_MAX_ACCEL, this.maxJerkAccel.intValue());
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.JERK_MAX_BRAKE, this.maxJerkBrake.intValue());
    }

    public void validateBulkChange(Map<String, Object> params) {
        String msg;
        Set<String> keys = params.keySet();
        for (String str : keys) {
            if (params.get(str) != null) continue;
            if (this.inited) {
                throw new RuntimeException(this.name + ": " + str + " is null");
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)str, (String)" is null");
        }
        for (String str : keys) {
            Object value = params.get(str);
            if (!(value instanceof Integer) || (Integer)value >= 0) continue;
            if (this.inited) {
                throw new RuntimeException(this.name + ": " + str + " is negative");
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)str, (String)" is negative");
        }
        Integer stepFreqParam = (Integer)params.get("stepFreq");
        Integer minStepFreqParam = (Integer)params.get("minStepFreq");
        Integer accelRampParam = (Integer)params.get("accelRamp");
        Integer brakeRampParam = (Integer)params.get("brakeRamp");
        if (brakeRampParam == 0) {
            brakeRampParam = accelRampParam;
        }
        Double maxRampTimeParam = (Double)params.get("maxRampTime");
        if (minStepFreqParam > stepFreqParam) {
            msg = " must not be larger than stepFreq";
            if (this.inited) {
                throw new RuntimeException(this.name + ": minStepFreq" + msg);
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"minStepFreq", (String)msg);
        }
        if (minStepFreqParam < 100) {
            msg = " must be at least " + Integer.toString(100);
            if (this.inited) {
                throw new RuntimeException(this.name + ": minStepFreq" + msg);
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"minStepFreq", (String)msg);
            throw new RuntimeException("minStepFreq must not be larger than stepFreq");
        }
        double t_accel = (double)(stepFreqParam - minStepFreqParam) / (double)accelRampParam.intValue();
        double t_brake = (double)(stepFreqParam - minStepFreqParam) / (double)brakeRampParam.intValue();
        if (t_accel > maxRampTimeParam || t_brake > maxRampTimeParam) {
            String msg2 = String.format("accelerating time %.2f s or braking time %.2f s exceeds maximum %.2f s", t_accel, t_brake, maxRampTimeParam);
            if (this.inited) {
                throw new RuntimeException(this.name + " " + msg2);
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"", (String)msg2);
        }
    }

    public void setParameterBulk(Map<String, Object> params) {
        Set<String> keys = params.keySet();
        if (keys.contains("iPhase")) {
            this.iPhase = (Integer)params.get("iPhase");
        }
        if (keys.contains("iPhaseStill")) {
            this.iPhaseStill = (Integer)params.get("iPhaseStill");
        }
        if (keys.contains("stepMode")) {
            this.stepMode = (Integer)params.get("stepMode");
        }
        if (keys.contains("backOff")) {
            this.backOff = (Boolean)params.get("backOff");
        }
        if (keys.contains("reverseClearance")) {
            this.reverseClearance = (Integer)params.get("reverseClearance");
        }
        if (keys.contains("rampType")) {
            this.rampType = (Integer)params.get("rampType");
        }
        if (keys.contains("quickRamp")) {
            this.quickRamp = (Integer)params.get("quickRamp");
        }
        if (keys.contains("stepFreq")) {
            this.stepFreq = (Integer)params.get("stepFreq");
        }
        if (keys.contains("minStepFreq")) {
            this.minStepFreq = (Integer)params.get("minStepFreq");
        }
        if (keys.contains("accelRamp")) {
            this.accelRamp = (Integer)params.get("accelRamp");
        }
        if (keys.contains("brakeRamp")) {
            this.brakeRamp = (Integer)params.get("brakeRamp");
        }
        if (keys.contains("maxJerkAccel")) {
            this.maxJerkAccel = (Integer)params.get("maxJerkAccel");
        }
        if (keys.contains("maxJerkBrake")) {
            this.maxJerkBrake = (Integer)params.get(",maxJerkBrake");
        }
        if (this.inited && this.isOnline()) {
            try {
                this.writeConfigurableSettings();
            }
            catch (DriverException e) {
                throw new RuntimeException(this.name + " DriverException while changing hardware settings:  " + (Object)((Object)e));
            }
        }
    }

    protected int[] checkChannel(String chName, int hwChan, String type, String subtype) throws Exception {
        try {
            NanotecPD4N.CmndGeneral.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)chName, (String)"type", (Object)type);
        }
        Integer n = this.chanKey;
        Integer n2 = this.chanKey = Integer.valueOf(this.chanKey + 1);
        this.chanMap.put(this.chanKey, type);
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        String chanName = this.chanMap.get(type);
        try {
            value = chanName.equals("TEMPERATURE") ? this.pd4n.readTemperature() : (double)Integer.parseInt(this.pd4n.readGeneral(NanotecPD4N.CmndGeneral.valueOf((String)chanName)));
        }
        catch (DriverTimeoutException et) {
            LOG.severe(this.name + " timeout reading " + chanName + ": " + (Object)((Object)et));
            this.setOnline(false);
        }
        catch (DriverException e) {
            LOG.severe(this.name + " exception reading data " + chanName + ": " + (Object)((Object)e));
        }
        return value;
    }

    public boolean getReadyFlag() throws DriverException {
        return this.pd4n.isMotorReady();
    }

    public boolean getPosError() throws DriverException {
        return this.pd4n.isPositionError();
    }

    public boolean getMotorError() throws DriverException {
        return this.pd4n.getErrorFlag();
    }

    public int getLimitSwitches() throws DriverException {
        return this.pd4n.getLimitSwitches();
    }

    @Command(type=Command.CommandType.QUERY, name="readAll", description="Read all controller settings and data")
    public String readAll() {
        String table = "Read all stepper motor settings and data\n\n";
        NanotecPD4N.CmndGeneral[] cmndN = NanotecPD4N.CmndGeneral.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", cmndN[i]);
            try {
                String respN = this.pd4n.readGeneral(cmndN[i]);
                table = table + respN + "   " + cmndN[i].getUnits();
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n\n";
        table = table + String.format("Checksum in use %14b\n\n", this.isChecksumUsed());
        table = table + this.readMotionRecord();
        return table;
    }

    @Command(type=Command.CommandType.QUERY, name="isChecksumUsed", description="<true|false> if checksum is <in use | not in use>")
    public boolean isChecksumUsed() {
        return this.pd4n.readChecksumUsage();
    }

    @Command(type=Command.CommandType.QUERY, name="readMotionRecord", description="Read all motion-record settings")
    public String readMotionRecord() {
        String table = "Stepper motor motion-record settings\n\n";
        NanotecPD4N.CmndMotion[] cmndN = NanotecPD4N.CmndMotion.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", cmndN[i]);
            try {
                String respN = this.pd4n.readMotion(cmndN[i]);
                table = table + String.format("%-12s", respN) + cmndN[i].getUnits();
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        return table;
    }

    @Command(type=Command.CommandType.QUERY, name="readEncoder", description="Read motor encoder position")
    public int readEncoder() throws DriverException {
        String resp = this.pd4n.readGeneral(NanotecPD4N.CmndGeneral.READ_ENCODER);
        return Integer.parseInt(resp);
    }

    @Command(type=Command.CommandType.QUERY, name="readTemperature", description="Read motor temperature in degrees C")
    public String readTemperature() throws DriverException {
        double temp = this.pd4n.readTemperature();
        return String.format("% .2f", temp);
    }

    @Command(type=Command.CommandType.QUERY, name="showFlags", description="Read useful status flags and error flag")
    public String showFlags() throws DriverException {
        boolean ready = this.getReadyFlag();
        boolean posErr = this.getPosError();
        boolean error = this.getMotorError();
        int switches = this.getLimitSwitches();
        return "Ready = " + Boolean.toString(ready) + ", Position error = " + Boolean.toString(posErr) + ", Error = " + Boolean.toString(error) + ", Limit switches = " + Integer.toString(switches);
    }

    @Command(type=Command.CommandType.QUERY, name="decodeLastError", description="Decode last error types")
    public String decodeLastError() throws DriverException {
        return this.pd4n.getErrorType();
    }

    @Command(type=Command.CommandType.ACTION, name="resetError", description="Reset controller error flags")
    public void resetError() throws DriverException {
        this.pd4n.resetError();
    }

    @Command(type=Command.CommandType.ACTION, name="saveMotionRecord", description="save current motion record")
    public void saveMotionRecord(@Argument(name="recordNumber", description="location in EEPROM (1 to 32)") int recordNumber) throws DriverException {
        this.pd4n.saveRecord(recordNumber);
    }

    @Command(type=Command.CommandType.ACTION, name="loadMotionRecord", description="load motion record from EEPROM")
    public void loadMotionRecord(@Argument(name="recordNumber", description="location in EEPROM (1 to 32)") int recordNumber) throws DriverException {
        this.pd4n.loadRecord(recordNumber);
    }

    public Duration getTimeEstimate(double distance) {
        double tNominal = Math.abs(distance) * 100.0 * (double)this.stepMode.intValue() / 2.0 / (double)this.stepFreq.intValue();
        double tAccel = (double)(this.stepFreq - this.minStepFreq) / (double)this.accelRamp.intValue();
        double tBrake = this.brakeRamp == 0 ? tAccel : (double)(this.stepFreq - this.minStepFreq) / (double)this.brakeRamp.intValue();
        long tTotal = (long)(1000.0 * (tNominal + tAccel + tBrake));
        return Duration.ofMillis(tTotal);
    }

    @Command(type=Command.CommandType.ACTION, name="move", description="Start motor and move")
    public void move(@Argument(name="relative position", description="signed linear distance (mm) for move") double relPos) throws DriverException {
        LOG.info(this.name + String.format(" initiating move of %f mm", relPos));
        int steps = (int)(Math.abs(relPos) * 100.0 * (double)this.stepMode.intValue() / 2.0);
        int dir = relPos > 0.0 ? 0 : 1;
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.DISTANCE, steps);
        this.pd4n.writeMotion(NanotecPD4N.CmndMotion.ROTATION_DIRECTION, dir);
        this.pd4n.startMotor();
    }

    @Command(type=Command.CommandType.ACTION, name="stop", description="stop motor, using current brake ramp")
    public void stop() throws DriverException {
        this.pd4n.stopMotor(1);
    }

    @Command(type=Command.CommandType.ACTION, name="stopQuick", description="stop motor, using quickstop ramp")
    public void stopQ() throws DriverException {
        this.pd4n.stopMotor(0);
    }

    public void moveBackOff() throws DriverException {
        int switches = this.getLimitSwitches();
        if (switches == 0) {
            LOG.info(this.name + ": ignore moveBackOff, limit switches not set");
            return;
        }
        LOG.info(this.name + ": backing off from limit switch");
        double backDist = 5.0;
        if ((switches & 1) != 0) {
            backDist = -backDist;
        }
        double timeEst = Math.abs(backDist) * 100.0 * (double)this.stepMode.intValue() / 2.0 / (double)this.minStepFreq.intValue();
        long tsleep = (long)(1000.0 * (timeEst + 1.0));
        this.move(backDist);
        try {
            Thread.sleep(tsleep);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Unexpected interrupt while waiting for motion to complete ", ex);
        }
    }
}

