/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.localdb.statusdb.model.CCSNamingStrategy;

public class StatusdbUtils {
    private static Configuration cfg;
    private static SessionFactory fac;
    private static final Logger LOG;

    private StatusdbUtils() {
    }

    public static boolean isInitialized() {
        return fac != null;
    }

    public static synchronized SessionFactory getSessionFactory() {
        return StatusdbUtils.getSessionFactory(null);
    }

    public static synchronized SessionFactory getSessionFactory(Properties inputProperties) {
        if (cfg == null) {
            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");
            try {
                URL configFileFullURL = BootstrapResourceUtils.getResourceURL((String)hibernateConfigFile);
                LOG.log(Level.INFO, "hibernate config from {0}", configFileFullURL);
                cfg = new Configuration().configure(configFileFullURL);
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.SEVERE, "Problem loading hibernate configuration file " + hibernateConfigFile, ex);
                throw new RuntimeException("Could not configur Hibernate", ex);
            }
            cfg.setImplicitNamingStrategy((ImplicitNamingStrategy)new CCSNamingStrategy());
            Properties cfgProps = new Properties();
            try {
                cfgProps.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)propertiesFile, StatusdbUtils.class));
                LOG.log(Level.INFO, "hibernate properties from {0}:\n {1}", new Object[]{propertiesFile, cfgProps});
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputProperties != null) {
                cfgProps.putAll((Map<?, ?>)inputProperties);
            }
            LOG.log(Level.INFO, "hibernate configuration:\n {0}", cfgProps);
            cfg = cfg.addProperties(cfgProps);
            Properties finalP = cfg.getProperties();
            LOG.log(Level.FINER, "*** Working with connection properties ");
            for (Object key : finalP.keySet()) {
                String skey = (String)key;
                if (!skey.startsWith("hibernate")) continue;
                LOG.log(Level.FINER, "{0}: {1}", new Object[]{skey, finalP.getProperty(skey)});
            }
            LOG.log(Level.FINER, "*********************************");
        }
        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }
        return fac;
    }

    public static synchronized void closeSessionFactory() {
        if (fac != null) {
            fac.close();
        }
        fac = null;
        cfg = null;
    }

    static {
        LOG = Logger.getLogger(StatusdbUtils.class.getName());
    }
}

