import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.subsystem.comcam.filterchanger.ComCamFilterChanger;
import org.lsst.ccs.subsystem.comcam.filterchanger.NanotecPD4NDevice;
import org.lsst.ccs.subsystem.comcam.filterchanger.MotronaIV251Device;
import org.lsst.ccs.subsystem.comcam.filterchanger.alerts.ComCamFCAlerts;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["comcam-fcs"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()

Class nanotecClass = Class.forName("org.lsst.ccs.subsystem.comcam.filterchanger.NanotecPD4NDevice");
Class motronaClass = Class.forName("org.lsst.ccs.subsystem.comcam.filterchanger.MotronaIV251Device");

builder.fcs (ComCamFilterChanger)
{
    AlarmMotorTemp (Alarm, description:"Motor over-temperatur", 
                    eventParm:ComCamFCAlerts.MOTOR_OVERTEMP.ordinal())

    StepperMotor(nanotecClass)
    {
        MotorTemperature (Channel, description:"motor temperature, degrees C",
                          devcName:"StepperMotor", type:"TEMPERATURE",
                          format:"%.2f", checkLo:"none", checkHi:"alarm",
                          alarmHi:"AlarmMotorTemp")

        MotorEncoder (Channel, description:"motor encoder reading in steps",
                      devcName:"StepperMotor", type:"READ_ENCODER",
                      format:"%.0f", checkLo:"none", checkHi:"none")
    }

    LinearEncoder(motronaClass)
    {
        LinearPosition(Channel, 
                       description:"linear encoder value converted to mm",
                       devcName:"LinearEncoder", type:"POSITION", units:"mm",
                       format:"%.3f", checkLo:"none", checkHi:"none")
    }

}
