/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

public class ValveMaq20Device
extends Maq20Device {
    private static final Logger LOG = Logger.getLogger(ValveMaq20Device.class.getName());
    private int[] setMask;
    private int[] getMask;
    private int[] posnMask;
    private int[] outMask;
    private int[] inMask;
    private boolean[] offline;
    private final List<Integer> outModules = new ArrayList<Integer>();
    private final List<Integer> inModules = new ArrayList<Integer>();

    protected void initDevice() {
        super.initDevice();
        this.outMask = new int[this.getModuleCount()];
        this.inMask = new int[this.getModuleCount()];
        this.setMask = new int[this.getModuleCount()];
        this.getMask = new int[this.getModuleCount()];
        this.posnMask = new int[this.getModuleCount()];
        this.offline = new boolean[this.getModuleCount()];
    }

    protected void initialize() {
        super.initialize();
        if (!this.isOnline()) {
            return;
        }
        for (int mod = 0; mod < this.getModuleCount(); ++mod) {
            if (this.outMask[mod] != 0) {
                if (this.getModuleData((int)mod).maqDiscOut == null) {
                    LOG.log(Level.SEVERE, "{0} MAQ20 module with index {1} cannot perform discrete output", new Object[]{this.name, mod});
                    this.offline[mod] = true;
                } else {
                    this.outModules.add(mod);
                    this.offline[mod] = false;
                }
            }
            if (this.inMask[mod] == 0) continue;
            if (this.getModuleData((int)mod).maqDiscIn == null) {
                LOG.log(Level.SEVERE, "{0} MAQ20 module with index {1} cannot perform discrete input", new Object[]{this.name, mod});
                this.offline[mod] = true;
                continue;
            }
            this.inModules.add(mod);
            this.offline[mod] = false;
        }
        this.getSetValves();
        System.arraycopy(this.getMask, 0, this.setMask, 0, this.getModuleCount());
        this.readPositions();
    }

    public void setValves() {
        for (int mod : this.outModules) {
            if (this.getModuleData((int)mod).maqDiscOut == null) continue;
            try {
                this.getModuleData((int)mod).maqDiscOut.writeDiscAll(this.setMask[mod]);
                this.offline[mod] = false;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "{0} MAQ20 write error: {1}", new Object[]{this.name, e});
                this.offline[mod] = true;
                this.setOnline(false);
            }
        }
    }

    public void getSetValves() {
        for (int mod : this.outModules) {
            if (this.getModuleData((int)mod).maqDiscOut == null) continue;
            try {
                this.getMask[mod] = this.getModuleData((int)mod).maqDiscOut.readDiscAll();
                this.offline[mod] = false;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "{0} MAQ20 read error: {1}", new Object[]{this.name, e});
                this.offline[mod] = true;
                this.setOnline(false);
            }
        }
    }

    public void readPositions() {
        for (int mod : this.inModules) {
            if (this.getModuleData((int)mod).maqDiscIn == null) continue;
            try {
                this.posnMask[mod] = this.getModuleData((int)mod).maqDiscIn.readDiscAll();
                this.offline[mod] = false;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "{0} MAQ20 read error: {1}", new Object[]{this.name, e});
                this.offline[mod] = true;
                this.setOnline(false);
            }
        }
    }

    public boolean registerOut(int index, int chan) {
        if ((this.outMask[index] & 1 << chan) != 0 || this.inMask[index] != 0) {
            return false;
        }
        int n = index;
        this.outMask[n] = this.outMask[n] | 1 << chan;
        return true;
    }

    public boolean registerIn(int index, int chan) {
        if ((this.inMask[index] & 1 << chan) != 0 || this.outMask[index] != 0) {
            return false;
        }
        int n = index;
        this.inMask[n] = this.inMask[n] | 1 << chan;
        return true;
    }

    public void setValve(int index, int chan, boolean on) {
        if (on) {
            int n = index;
            this.setMask[n] = this.setMask[n] | 1 << chan;
        } else {
            int n = index;
            this.setMask[n] = this.setMask[n] & ~(1 << chan);
        }
    }

    public Boolean isValveSet(int index, int chan) {
        return this.offline[index] ? null : Boolean.valueOf((this.getMask[index] & 1 << chan) != 0);
    }

    public Boolean isPositionSet(int index, int chan) {
        return this.offline[index] ? null : Boolean.valueOf((this.posnMask[index] & 1 << chan) != 0);
    }
}

