/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class LargeFileObjectAvailableEvent
extends CameraEvent {
    private final String url;
    private final String generator;
    private final float version;
    private final int byteSize;
    private final String checkSum;
    private final String mimeType;
    private final String id;

    public LargeFileObjectAvailableEvent(int priority, String url, String generator, float version, int byteSize, String checkSum, String mimeType, String id) {
        super(priority);
        this.url = url;
        this.generator = generator;
        this.version = version;
        this.byteSize = byteSize;
        this.checkSum = checkSum;
        this.mimeType = mimeType;
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getGenerator() {
        return this.generator;
    }

    public float getVersion() {
        return this.version;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "LargeFileObjectAvailableEvent{url=" + this.url + ", generator=" + this.generator + ", version=" + this.version + ", byteSize=" + this.byteSize + ", checkSum=" + this.checkSum + ", mimeType=" + this.mimeType + ", id=" + this.id + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int priority;
        private String url;
        private String generator;
        private float version;
        private int byteSize;
        private String checkSum;
        private String mimeType;
        private String id;

        private Builder() {
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder generator(String generator) {
            this.generator = generator;
            return this;
        }

        public Builder version(float version) {
            this.version = version;
            return this;
        }

        public Builder byteSize(int byteSize) {
            this.byteSize = byteSize;
            return this;
        }

        public Builder checkSum(String checkSum) {
            this.checkSum = checkSum;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public LargeFileObjectAvailableEvent build() {
            return new LargeFileObjectAvailableEvent(this.priority, this.url, this.generator, this.version, this.byteSize, this.checkSum, this.mimeType, this.id);
        }
    }
}

