/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.alerts.DeviceAlerts;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Device
implements HardwareController,
HasLifecycle {
    protected boolean inited;
    protected volatile boolean online;
    private volatile boolean initializing = false;
    private final boolean allowRepeatedAlarm = false;
    protected final Logger log = Logger.getLogger((String)"org.lsst.ccs.monitor.device");
    protected int lineMask;
    protected int lineWarm;
    protected int lineState;
    private final List<Channel> deviceChannels = new ArrayList<Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem s;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupPath
    protected String fullName;
    protected String alertOfflineId;
    @ConfigurationParameter(category="Devices", description="If true, Device is diabled")
    private volatile boolean disabled = false;
    private volatile boolean canInvokeCheckOnline = false;

    @Override
    public void init() {
        this.alertOfflineId = DeviceAlerts.DEVICE_OFFLINE.getAlertId(this.name);
        this.initDevice();
        this.configure(this.mon);
        this.canInvokeCheckOnline = true;
    }

    protected void initDevice() {
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isOnline() {
        return this.online;
    }

    @Deprecated
    public void disable() {
        this.changeDisabled(true);
    }

    @Deprecated
    public void enable() {
        this.changeDisabled(false);
    }

    private void changeDisabled(boolean disable) {
        if (this.mon.useFullPath) {
            this.configService.change(this.path, "disabled", disable);
        } else {
            this.configService.change(this.name, "disabled", disable);
        }
    }

    protected void configure(Monitor mon) {
    }

    @ConfigurationParameterChanger(propertyName="disabled")
    public void setDisabled(Boolean value) {
        if (value != null) {
            this.log.info((Object)(this.fullName + "config. change request: set disabled = " + value));
            this.disabled = value;
            if (this.disabled) {
                this.setOnline(false);
            } else if (this.canInvokeCheckOnline) {
                this.checkOnline();
            }
        } else {
            throw new IllegalArgumentException(this.fullName + ": parameter \"disabled\" cannot be null; value not changed.");
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        return new int[]{0, 0};
    }

    protected abstract void initialize();

    protected abstract void close();

    protected final void initSensors() {
        for (Channel ch : this.deviceChannels) {
            if (ch.getState() == DataProviderState.DISABLED) continue;
            ch.initSensor();
        }
    }

    protected void initChannel(int hwChan, int type, int subtype) {
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        this.initChannel(hwChan, type, subtype);
    }

    void addChannel(Channel ch) {
        this.deviceChannels.add(ch);
    }

    protected void dropChannel(int id) {
        this.mon.getChannel(id).setValid(false);
    }

    public void checkOnline() {
        this.log.debug((Object)("Checking if device is online (" + this.online + ") or disabled (" + this.disabled + ")"));
        if (this.online || this.disabled) {
            return;
        }
        this.doInitialize();
    }

    private void doInitialize() {
        this.initializing = true;
        RaisedAlertHistory alertHistory = this.alertService.getRaisedAlertSummary().getRaisedAlert(this.alertOfflineId);
        boolean alarm = alertHistory != null && alertHistory.getLatestAlertState() == AlertState.ALARM;
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.warn((Object)("Exception during initialize " + this.name), (Throwable)e);
        }
        if (!this.online && !alarm) {
            String msg = "ALARM due to failure to initialize " + this.name;
            this.alertService.raiseAlert(DeviceAlerts.DEVICE_OFFLINE.newAlert(this.name), AlertState.ALARM, msg);
        } else if (this.online && alarm) {
            String msg = "NOMINAL after successful initialize of " + this.name;
            this.alertService.raiseAlert(DeviceAlerts.DEVICE_OFFLINE.newAlert(this.name), AlertState.NOMINAL, msg);
        }
        this.initializing = false;
    }

    protected boolean testOnline() {
        if (!this.online) {
            this.log.error((Object)("Device " + this.fullName + " is offline"));
        }
        return this.online;
    }

    protected void setOnline(boolean online) {
        if (this.online == online) {
            return;
        }
        this.online = online;
        if (!online) {
            if (!this.disabled) {
                this.log.error((Object)("Disconnected from " + this.fullName));
                if (!this.initializing) {
                    String msg = "ALARM due to channel-reading failure " + this.name;
                    this.alertService.raiseAlert(DeviceAlerts.DEVICE_OFFLINE.newAlert(this.name), AlertState.ALARM, msg);
                }
            }
            this.close();
        }
    }

    protected void readChannelGroup() {
    }

    protected void readChannelGroup(String group) {
        throw new UnsupportedOperationException("When using groups with devices, this method must be overwritten");
    }

    protected String getGroupForChannel(Channel ch) {
        return null;
    }

    protected double readChannel(int hwChan, int type) {
        return Double.NaN;
    }

    protected double readChannel(Channel ch) {
        if (ch.getState() == DataProviderState.DISABLED) {
            return Double.NaN;
        }
        return this.readChannel(ch.hwChan, ch.typeI);
    }

    protected double readChannelNow(int hwChan, int type) {
        return this.readChannel(hwChan, type);
    }

    @Deprecated
    protected void checkTimeout(Exception e, Class<?> eClass) throws Exception {
        if (this.isTimeout(e)) {
            this.setOnline(false);
        }
        Constructor<?> eCon = eClass.getConstructor(String.class);
        throw (Exception)eCon.newInstance(e.getMessage());
    }

    @Deprecated
    protected boolean isTimeout(Exception e) {
        return e.getMessage().matches(".*time.*out.*");
    }

    protected final void checkLine(String name, int line) throws Exception {
        this.checkHwLine(name, line);
    }

    protected void checkHwLine(String name, int line) throws Exception {
    }

    protected void setLineWarm(int line, boolean on) {
        this.lineWarm = on ? (this.lineWarm |= 1 << line) : (this.lineWarm &= ~(1 << line));
    }

    protected final void setLine(int line, boolean on) {
        this.lineState = on ? (this.lineState |= 1 << line) : (this.lineState &= ~(1 << line));
        this.setHwLine(line, on);
    }

    protected void setHwLine(int line, boolean on) {
    }

    protected final Boolean isLineSet(int line) {
        return this.isHwLineSet(line);
    }

    protected Boolean isHwLineSet(int line) {
        return null;
    }

    protected void setOutputLines() {
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                if ((this.lineWarm & 1 << line) == 0) {
                    this.setLine(line, (this.lineState & 1 << line) != 0);
                } else {
                    Boolean set = this.isHwLineSet(line);
                    if (set != null) {
                        this.setLine(line, set);
                    }
                }
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void getOutputLines() {
        this.lineState = 0;
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                Boolean set = this.isHwLineSet(line);
                this.lineState |= set != null && set != false ? 1 << line : 0;
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void addLine(int line) {
        this.lineMask |= 1 << line;
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        if (!this.disabled) {
            this.doInitialize();
        }
        return TreeWalkerDiag.GO;
    }

    public List<MonitorUpdateTask> getDeviceMonitorUpdateTasks() {
        return this.mon.getMonitorUpdateTasksForDevice(this);
    }

    public List<MonitorUpdateTask> getMonitorUpdateTasksForChannels(Channel ... channels) {
        ArrayList<MonitorUpdateTask> result = new ArrayList<MonitorUpdateTask>();
        List<MonitorUpdateTask> deviceTasks = this.getDeviceMonitorUpdateTasks();
        for (Channel ch : channels) {
            if (!this.deviceChannels.contains(ch)) {
                throw new RuntimeException("Channel " + ch.getName() + " does not belong to device " + this.path);
            }
            for (MonitorUpdateTask task : deviceTasks) {
                if (!task.getAllChannels().contains(ch) || result.contains(task)) continue;
                result.add(task);
            }
        }
        return result;
    }

    List<Channel> getChannels() {
        return Collections.unmodifiableList(this.deviceChannels);
    }
}

