/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jline.console.ConsoleReader;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.apcpdu.AP9630UPS;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestAP9630UPS {
    private static final Map<Integer, String> statusMap = new HashMap<Integer, String>();
    private static final PrintStream out;
    private final AP9630UPS ups = new AP9630UPS();
    private ConsoleReader reader;

    @Command(description="Open connection to a UPS")
    public void open(@Argument(name="conntype", description="Connection type") Session.ConnType connType, @Argument(name="devcid", description="Device ID") String devcId, @Argument(name="username", description="User name") String userName, @Argument(name="password", description="Password") String password) throws DriverException {
        this.ups.open(connType, devcId, userName, password);
    }

    @Command(description="Open connection to a UPS")
    public void open(@Argument(name="conntype", description="Connection type") Session.ConnType connType, @Argument(name="devcid", description="Device ID") String devcId) throws DriverException {
        this.ups.open(connType, devcId);
    }

    @Command(description="Set the response overall timeout")
    public void setTimeout(@Argument(description="Timeout (ms)") int timeout) throws DriverException {
        this.ups.setTimeout(timeout);
    }

    @Command(description="Set the response inter-character timeout")
    public void setCharTimeout(@Argument(description="Timeout (ms)") int timeout) throws DriverException {
        this.ups.setCharTimeout(timeout);
    }

    @Command(description="Close the connection")
    public void close() throws DriverException {
        this.ups.close();
    }

    @Command(description="Show the product name")
    public String product() throws DriverException {
        return this.ups.getProductName();
    }

    @Command(description="Show the firmware version")
    public String version() throws DriverException {
        return this.ups.getFWVersion();
    }

    @Command(description="Show the UPS status")
    public String status() throws DriverException {
        int stat = this.ups.getStatus();
        return statusMap.get(stat) + " (" + stat + ")";
    }

    @Command(description="Show the output voltage")
    public double outputVoltage() throws DriverException {
        return this.ups.getOutputVoltage();
    }

    @Command(description="Show the output current")
    public double outputCurrent() throws DriverException {
        return this.ups.getOutputCurrent();
    }

    @Command(description="Show the output power")
    public double outputPower() throws DriverException {
        return this.ups.getOutputPower();
    }

    @Command(description="Show the battery temperature")
    public double temperature() throws DriverException {
        return this.ups.getTemperature();
    }

    @Command(description="Show the battery voltage")
    public double batteryVoltage() throws DriverException {
        return this.ups.getBatteryVoltage();
    }

    @Command(description="Show the battery charge")
    public double batteryCharge() throws DriverException {
        return this.ups.getBatteryCharge();
    }

    @Command(description="Show the remaining run time")
    public int runTime() throws DriverException {
        return this.ups.getRunTime();
    }

    @Command(name="talk", description="Talk to the UPS interactively")
    public void talk() throws DriverException, IOException {
        String cmnd;
        out.println("Type ctrl-D to exit");
        ConsoleReader consoleReader = this.reader = this.reader == null ? new ConsoleReader() : this.reader;
        while ((cmnd = this.reader.readLine(this.ups.getPrompt())) != null) {
            String[] resp = this.ups.receive(cmnd);
            for (int j = 1; j < resp.length; ++j) {
                out.println(resp[j]);
            }
        }
        out.println();
    }

    static {
        statusMap.put(0, "Online");
        statusMap.put(1, "Battery");
        out = System.out;
    }
}

