import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.utility.PurgeTestMain
import org.lsst.ccs.subsystem.utility.FanPIControl
import org.lsst.ccs.subsystem.utility.Maq20DevicePT
import org.lsst.ccs.subsystem.utility.BfrDevicePT
import org.lsst.ccs.subsystem.utility.Pdu24VDevicePT
import org.lsst.ccs.subsystem.utility.Pdu48VDevicePT
import org.lsst.ccs.subsystem.utility.VpcControlPT
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PulseControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["purgetest"]

builder.main (PurgeTestMain, mpcFan: "MPCFan", vpcFan: "VPCFan", utFan: "UTFan") {

    Maq20 (Maq20DevicePT, modules: ["DIOL:pwm:pulse", "DIOL:pwm:pulse", "DIOL:pwm:pulse", "IS", "TTC", "RTD", "RTD", "IO"]) {

       MPCPwm (Maq20PWMControl, modIndex: 0, funcIndex: 0, frequency: 200.0)

       MPCPulse (Maq20PulseControl, modIndex: 0, funcIndex: 1, pulsesPerRevn: 2)

       VPCPwm (Maq20PWMControl, modIndex: 1, funcIndex: 0, frequency: 200.0)

       VPCPulse (Maq20PulseControl, modIndex: 1, funcIndex: 1, pulsesPerRevn: 2)

       UTPwm (Maq20PWMControl, modIndex: 2, funcIndex: 0, frequency: 200.0)

       UTPulse (Maq20PulseControl, modIndex: 2, funcIndex: 1, pulsesPerRevn: 2)

       AnalogOut (Maq20AnalogControl, modIndex: 7, ranges: ["MA4_20", "MA4_20", "MA4_20"])
    }

    BFR (BfrDevicePT)

    PDU_24V (Pdu24VDevicePT)

    PDU_48V (Pdu48VDevicePT)

    /*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1, pageId: 0, 
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

    "Power/BFR_I" (Channel, description: "BFR total current", units: "mA", format: ".1f",
                   devcName: "BFR", hwChan: 0, scale: 1000.0)

    "Power/24V_Main_V" (Channel, description: "24V PDU main voltage", units: "Volts", format: ".2f",
                        devcName: "PDU_24V", type: "MAINVOLT")

    "Power/24V_Main_I" (Channel, description: "24V PDU main current", units: "mA", format: ".1f",
                        devcName: "PDU_24V", type: "MAINCURR", scale: 1000.0)

    "Power/24V_Main_T" (Channel, description: "24V PDU main temperature", units: "\u00b0C", format: ".1f",
                        devcName: "PDU_24V", type: "MAINTEMP")

    //"Power/24V_Board_T" (Channel, description: "24V PDU board temperature", units: "\u00b0C", format: ".1f",
    //                     devcName: "PDU_24V", type: "BOARDTEMP")

    //"Power/24V_FPGA_T" (Channel, description: "24V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
    //                    devcName: "PDU_24V", type: "FPGATEMP")

    "Power/48V_Main_V" (Channel, description: "48V PDU main voltage", units: "Volts", format: ".2f",
                        devcName: "PDU_48V", type: "MAINVOLT")

    "Power/48V_Main_I" (Channel, description: "48V PDU main current", units: "mA", format: ".1f",
                        devcName: "PDU_48V", type: "MAINCURR", scale: 1000.0)

    "Power/48V_Main_T" (Channel, description: "48V PDU main temperature", units: "\u00b0C", format: ".1f",
                        devcName: "PDU_48V", type: "MAINTEMP")

    //"Power/48V_Board_T" (Channel, description: "48V PDU board temperature", units: "\u00b0C", format: ".1f",
    //                     devcName: "PDU_48V", type: "BOARDTEMP")

    //"Power/48V_FPGA_T" (Channel, description: "48V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
    //                    devcName: "PDU_48V", type: "FPGATEMP")

    "Power/Electronics_V" (Channel, description: "Electronics voltage", units: "Volts", format: ".2f",
                           devcName: "PDU_24V", hwChan: Pdu24VDevicePT.CHAN_ELECTRONICS, type: "VOLTAGE")

    "Power/Electronics_I" (Channel, description: "Electronics current", units: "mA", format: ".1f",
                           devcName: "PDU_24V", hwChan: Pdu24VDevicePT.CHAN_ELECTRONICS, type: "CURRENT", scale: 1000.0)

    "Power/MechFan_V" (Channel, description: "Mechanism fan voltage", units: "Volts", format: ".2f",
                       devcName: "PDU_48V", hwChan: Pdu48VDevicePT.CHAN_MPC_FAN, type: "VOLTAGE")

    "Power/MechFan_I" (Channel, description: "Mechanism fan current", units: "mA", format: ".1f",
                       devcName: "PDU_48V", hwChan: Pdu48VDevicePT.CHAN_MPC_FAN, type: "CURRENT", scale: 1000.0)

    "Power/VolumeFan_V" (Channel, description: "Volume fan voltage", units: "Volts", format: ".2f",
                         devcName: "PDU_48V", hwChan: Pdu48VDevicePT.CHAN_VPC_FAN, type: "VOLTAGE")

    "Power/VolumeFan_I" (Channel, description: "Volume fan current", units: "mA", format: ".1f",
                         devcName: "PDU_48V", hwChan: Pdu48VDevicePT.CHAN_VPC_FAN, type: "CURRENT", scale: 1000.0)

    "Power/CoolingFan_V" (Channel, description: "UT cooling fan voltage", units: "Volts", format: ".2f",
                          devcName: "PDU_48V", hwChan: Pdu48VDevicePT.CHAN_UT_FAN, type: "VOLTAGE")

    "Power/CoolingFan_I" (Channel, description: "UT cooling fan current", units: "mA", format: ".1f",
                          devcName: "PDU_48V", hwChan: Pdu48VDevicePT.CHAN_UT_FAN, type: "CURRENT", scale: 1000.0)

    "MPC/RtnAirtemp" (Channel, description: "MPC return air temperature", units: "\u00b0C",
                      devcName: "Maq20", hwChan: 0, type: "5", subtype: "R200")

    "MPC/SplyAirtemp" (Channel, description: "MPC supply air temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 1, type: "5", subtype: "R200")

    "MPC/DeltatempAct" (Channel, description: "MPC actual delta temperature", units: "\u00b0C",
                        devcName: "Calc", type: "DIFF", subtype: "MPC/AvgAirtempOut:MPC/AmbAirtemp")

    "MPC/AvgAirtempOut" (Channel, description: "MPC average air temperature", units: "\u00b0C",
                         devcName: "Maq20", hwChan: 0, type: "5", subtype: "R200")

    "MPC/AmbAirtemp" (Channel, description: "MPC ambient air temperature", units: "\u00b0C",
                      devcName: "Maq20", hwChan: 1, type: "5", subtype: "R200")

    "MPC/FanTach" (Channel, description: "MPC fan tachometer", units: "rpm", format: ".0f",
                   devcName: "Maq20", hwChan: Maq20DevicePT.CHAN_PULSE_RPM, type: "0", subtype: "1")

    "MPC/RtnPress" (Channel, description: "MPC return air pressure", units: "in. H\u2082O",
                    devcName: "Maq20", hwChan: 6, type: "3", subtype: "MA4_20", scale: 625, offset: -2.5)

    "MPC/PreFiltPress" (Channel, description: "MPC pre-filter air pressure", units: "in. H\u2082O",
                        devcName: "Maq20", hwChan: 7, type: "3", subtype: "MA4_20", scale: 625, offset: -2.5)

    "MPC/SplyPress" (Channel, description: "MPC supply air pressure", units: "in. H\u2082O",
                     devcName: "Maq20", hwChan: 8, type: "3", subtype: "MA4_20", scale: 625, offset: -2.5)

    "MPC/Humidity" (Channel, description: "MPC relative humidity", units: "%",
                    devcName: "Maq20", hwChan: 9, type: "3", subtype: "MA4_20", scale: 6250, offset: -25.0)

    "Sim/HtrDutyCycle" (Channel, description: "Simulator heater duty cycle",
                        devcName: "Maq20", hwChan: Maq20DevicePT.CHAN_SIM_HEATER, type: "7", subtype: "")

    "Sim/InletAirTemp" (Channel, description: "Simulator inlet air temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 0, type: "6", subtype: "R200")

    "Sim/OutletAirTemp" (Channel, description: "Simulator outlet air temperature", units: "\u00b0C",
                         devcName: "Maq20", hwChan: 1, type: "6", subtype: "R200")

    "Sim/SlabTemp" (Channel, description: "Simulator slab temperature", units: "\u00b0C",
                    devcName: "Maq20", hwChan: 2, type: "6", subtype: "R200")

    "Sim/AmbientTemp" (Channel, description: "Simulator ambient temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 3, type: "6", subtype: "R200")

    "Sim/CoolSuppTemp" (Channel, description: "Simulator coolant supply temperature", units: "\u00b0C",
                        devcName: "Maq20", hwChan: 4, type: "6", subtype: "R200")

    "Sim/CoolRetnTemp" (Channel, description: "Simulator coolant return temperature", units: "\u00b0C",
                        devcName: "Maq20", hwChan: 5, type: "6", subtype: "R200")

    "VPC/SplyAirvel" (Channel, description: "VPC supply air velocity", units: "m/s",
                      devcName: "Maq20", hwChan: 0, type: "3", subtype: "MA4_20", scale: 1250.0, offset: -5.0)

    "VPC/SplyAirtemp" (Channel, description: "VPC supply air temperature", units: "\u00b0C",
                       devcName: "Maq20", hwChan: 1, type: "3", subtype: "MA4_20", scale: 6250.0, offset: -50.0)

    "VPC/RtnAirtemp" (Channel, description: "VPC return air temperature", units: "\u00b0C",
                      devcName: "Maq20", hwChan: 2, type: "5", subtype: "R200")

    "VPC/DeltatempAct" (Channel, description: "VPC actual delta temperature", units: "\u00b0C",
                        devcName: "Calc", type: "DIFF", subtype: "VPC/AvgAirtempOut:VPC/AmbAirtemp")

    "VPC/AvgAirtempOut" (Channel, description: "VPC average air temperature", units: "\u00b0C",
                         devcName: "Maq20", hwChan: 0, type: "5", subtype: "R200")

    "VPC/AmbAirtemp" (Channel, description: "VPC ambient air temperature", units: "\u00b0C",
                      devcName: "Maq20", hwChan: 1, type: "5", subtype: "R200")

    "VPC/FanTach" (Channel, description: "VPC fan tachometer", units: "rpm", format: ".0f",
                   devcName: "Maq20", hwChan: Maq20DevicePT.CHAN_PULSE_RPM, type: "1", subtype: "1")

    "VPC/RtnPress" (Channel, description: "VPC return air pressure", units: "in. H\u2082O",
                    devcName: "Maq20", hwChan: 2, type: "3", subtype: "MA4_20", scale: 625, offset: -2.5)

    "VPC/PreFiltPress" (Channel, description: "VPC pre-filter air pressure", units: "in. H\u2082O",
                        devcName: "Maq20", hwChan: 3, type: "3", subtype: "MA4_20", scale: 625, offset: -2.5)

    "VPC/SplyPress" (Channel, description: "VPC supply air pressure", units: "in. H\u2082O",
                     devcName: "Maq20", hwChan: 4, type: "3", subtype: "MA4_20", scale: 625, offset: -2.5)

    "VPC/Humidity" (Channel, description: "VPC relative humidity", units: "%",
                    devcName: "Maq20", hwChan: 5, type: "3", subtype: "MA4_20", scale: 6250, offset: -25.0)

    "VPC/ValvePosn" (Channel, description: "VPC coolant valve position", units: "%",
                     devcName: "Maq20", hwChan: 11, type: "3", subtype: "MA4_20", scale: 6250, offset: -25.0)

    "UT/AvgAirtempOut" (Channel, description: "UT average air temperature", units: "\u00b0C",
                        devcName: "Maq20", hwChan: 0, type: "4", subtype: "T220")

    "UT/AmbAirtemp" (Channel, description: "UT ambient air temperature", units: "\u00b0C",
                     devcName: "Maq20", hwChan: 1, type: "4", subtype: "T220")

    "UT/FanTach" (Channel, description: "UT fan tachometer", units: "rpm", format: ".0f",
                  devcName: "Maq20", hwChan: Maq20DevicePT.CHAN_PULSE_RPM, type: "2", subtype: "1")

    MPCFan  (FanPIControl, fan: ref("Maq20/MPCPwm"), refTempChans: [ref("Sim/AmbientTemp")],
             ctrlTempChans: [ref("Sim/OutletAirTemp")], ctrlTempWeights: [1.0])

    VPCFan  (FanPIControl, fan: ref("Maq20/VPCPwm"), refTempChans: [], ctrlTempChans: [], ctrlTempWeights: [])

    VPCHtrs (VpcControlPT, refTempChans: ["Sim/AmbientTemp"], ctrlTempChans: ["Sim/OutletAirTemp"])

    UTFan   (FanPIControl, fan: ref("Maq20/UTPwm"), refTempChans: [ref("UT/AmbAirtemp")],
             ctrlTempChans: [ref("UT/AvgAirtempOut")], ctrlTempWeights: [1.0])

}
