/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.event;

import org.lsst.sal.camera.CameraEvent;

public class LogMessageEvent
extends CameraEvent {
    private final String name;
    private final int level;
    private final String message;
    private final String traceback;
    private final String filePath;
    private final String functionName;
    private final int lineNumber;
    private final int process;

    public LogMessageEvent(int priority, String name, int level, String message, String traceback, String filePath, String functionName, int lineNumber, int process) {
        super(priority);
        this.name = name;
        this.level = level;
        this.message = message;
        this.traceback = traceback;
        this.filePath = filePath;
        this.functionName = functionName;
        this.lineNumber = lineNumber;
        this.process = process;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTraceback() {
        return this.traceback;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getProcess() {
        return this.process;
    }

    public String toString() {
        return "LogMessageEvent{name=" + this.name + ", level=" + this.level + ", message=" + this.message + ", traceback=" + this.traceback + ", filePath=" + this.filePath + ", functionName=" + this.functionName + ", lineNumber=" + this.lineNumber + ", process=" + this.process + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int priority;
        private String name;
        private int level;
        private String message;
        private String traceback;
        private String filePath;
        private String functionName;
        private int lineNumber;
        private int process;

        private Builder() {
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder traceback(String traceback) {
            this.traceback = traceback;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder process(int process) {
            this.process = process;
            return this;
        }

        public LogMessageEvent build() {
            return new LogMessageEvent(this.priority, this.name, this.level, this.message, this.traceback, this.filePath, this.functionName, this.lineNumber, this.process);
        }
    }
}

