/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.ascii.Multidrop;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.Model9XX;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class Mks9xxDevice
extends Device {
    private static final String DEVC_ID = "devcId";
    private static final String BUS_ADDR = "busAddr";
    @ConfigurationParameter(name="devcId", category="Cryo", isFinal=true)
    private String devcId;
    @ConfigurationParameter(name="busAddr", category="Cryo", isFinal=true)
    private int busAddr = 253;
    private Multidrop.ConnType connType = Multidrop.ConnType.SERIAL;
    private int baudRate = 9600;
    private static final Logger LOG = Logger.getLogger(Mks9xxDevice.class.getName());
    private final Model9XX mks = new Model9XX();
    private int errorCount = 0;
    private boolean initError = false;

    public void initDevice() {
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)DEVC_ID, (String)"is missing");
        }
        this.fullName = "MKS model 9XX (" + this.devcId + ":" + this.busAddr + ")";
    }

    public void initialize() {
        try {
            this.mks.open(this.connType, this.devcId, this.baudRate, this.busAddr);
            this.mks.setLock(false);
            this.mks.setPressureUnit(Model9XX.Unit.TORR);
            this.mks.setLock(true);
            this.errorCount = 0;
            this.setOnline(true);
            this.initSensors();
            LOG.log(Level.INFO, "Connected to {0}: model = {1}, serial no. = {2}", new Object[]{this.fullName, this.mks.getModel(), this.mks.getSerialNumber()});
            this.initError = false;
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.mks.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            this.mks.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    public double readChannel(int hwChan, int type) {
        double value;
        block3: {
            value = Double.NaN;
            if (this.isOnline()) {
                try {
                    value = this.mks.readPressure(Model9XX.Sensor.COMB4);
                    this.errorCount = 0;
                }
                catch (DriverException e) {
                    LOG.log(Level.SEVERE, "Error reading pressure from {0}: {1}", new Object[]{this.fullName, e});
                    if (++this.errorCount < 5) break block3;
                    this.setOnline(false);
                }
            }
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, description="Read the pressure")
    public double readPressure(@Argument(description="Sensor name") Model9XX.Sensor sensor) throws DriverException {
        return this.mks.readPressure(sensor);
    }

    @Command(type=Command.CommandType.QUERY, description="Read the Micropirani temperature")
    public double readTemperature() throws DriverException {
        return this.mks.readTemperature();
    }

    @Command(type=Command.CommandType.QUERY, description="Get a relay trip point")
    public double getRelayTrip(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.getRelayTrip(relay);
    }

    @Command(type=Command.CommandType.QUERY, description="Get a relay hysteresis value")
    public double getRelayHyst(int relay) throws DriverException {
        return this.mks.getRelayHyst(relay);
    }

    @Command(type=Command.CommandType.QUERY, description="Get a relay trip direction")
    public Model9XX.Direction getRelayDirection(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.getRelayDirection(relay);
    }

    @Command(type=Command.CommandType.QUERY, description="Get a relay enabled state")
    public Model9XX.Enable getRelayEnable(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.getRelayEnable(relay);
    }

    @Command(type=Command.CommandType.QUERY, description="Get whether a relay is active")
    public boolean isRelayActive(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.isRelayActive(relay);
    }

    @Command(type=Command.CommandType.QUERY, description="Get an analog output setting")
    public String getAnalogOut(@Argument(description="Channel number") int chan) throws DriverException {
        return this.mks.getAnalogOut(chan);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the calibration gas")
    public Model9XX.Gas getCalibrationGas() throws DriverException {
        return this.mks.getCalibrationGas();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the device type")
    public String getDeviceType() throws DriverException {
        return this.mks.getDeviceType();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the firmware version")
    public String getFirmwareVersion() throws DriverException {
        return this.mks.getFirmwareVersion();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hardware version")
    public String getHardwareVersion() throws DriverException {
        return this.mks.getHardwareVersion();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the manufacturer")
    public String getManufacturer() throws DriverException {
        return this.mks.getManufacturer();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the model")
    public String getModel() throws DriverException {
        return this.mks.getModel();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the part number")
    public String getPartNumber() throws DriverException {
        return this.mks.getPartNumber();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the serial number")
    public String getSerialNumber() throws DriverException {
        return this.mks.getSerialNumber();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the transducer time on (hours)")
    public int getTimeOn() throws DriverException {
        return this.mks.getTimeOn();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the sensor time on (hours)")
    public int getSensorTimeOn() throws DriverException {
        return this.mks.getSensorTimeOn();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the sensor pressure dose")
    public double getSensorDose() throws DriverException {
        return this.mks.getSensorDose();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the transducer status")
    public char getStatus() throws DriverException {
        return this.mks.getStatus();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the pressure unit")
    public Model9XX.Unit getPressureUnit() throws DriverException {
        return this.mks.getPressureUnit();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the baud rate")
    public int getBaudRate() throws DriverException {
        return this.mks.getBaudRate();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the user tag")
    public String getUserTag() throws DriverException {
        return this.mks.getUserTag();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the switch enabled state")
    public boolean isSwitchEnabled() throws DriverException {
        return this.mks.isSwitchEnabled();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the RS-485 delayed response state")
    public boolean isResponseDelayed() throws DriverException {
        return this.mks.isResponseDelayed();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the relay trip delayed state")
    public boolean isRelayDelayed() throws DriverException {
        return this.mks.isRelayDelayed();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the identify state")
    public boolean isIdentifying() throws DriverException {
        return this.mks.isIdentifying();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the atmospheric pressure calibration factor")
    public double getAtmospheric() throws DriverException {
        return this.mks.getAtmospheric();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the MicroPirani auto zero limit")
    public double getAutoZeroLimit() throws DriverException {
        return this.mks.getAutoZeroLimit();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the cold cathode full-scale pressure calibration factor")
    public double getFullScale() throws DriverException {
        return this.mks.getFullScale();
    }

    @Command(type=Command.CommandType.QUERY, description="Get cold cathode turn-on pressure")
    public double getOnPressureCC() throws DriverException {
        return this.mks.getOnPressureCC();
    }

    @Command(type=Command.CommandType.QUERY, description="Get cold cathode turn-off pressure")
    public double getOffPressureCC() throws DriverException {
        return this.mks.getOffPressureCC();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the low integration pressure")
    public double getLowIntPressure() throws DriverException {
        return this.mks.getLowIntPressure();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the high integration pressure")
    public double getHighIntPressure() throws DriverException {
        return this.mks.getHighIntPressure();
    }

    @Command(type=Command.CommandType.QUERY, description="Get cold cathode auto power state")
    public boolean isCCAutoPowerOn() throws DriverException {
        return this.mks.isCCAutoPowerOn();
    }

    @Command(type=Command.CommandType.QUERY, description="Get cold cathode power state")
    public boolean isCCPowerOn() throws DriverException {
        return this.mks.isCCPowerOn();
    }

    @Command(type=Command.CommandType.QUERY, description="Get cold cathode protection delay")
    public int getCCProtDelay() throws DriverException {
        return this.mks.getCCProtDelay();
    }

    @Command(type=Command.CommandType.QUERY, description="Get cold cathode pressure dose limit")
    public double getSensorDoseLimit() throws DriverException {
        return this.mks.getSensorDoseLimit();
    }
}

