/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;

public class HelpGenerator {
    private final Dictionary dict;
    private final PrintWriter out;
    private CommandSet cmdSet = null;
    private final HelpCommands builtIns = new HelpCommands();

    public HelpGenerator(PrintWriter out, Dictionary dict) {
        this.out = out;
        this.dict = dict;
    }

    void help(Options opts) {
        this.builtIns.help(opts);
    }

    void help(String command) {
        this.builtIns.help(command);
    }

    public CommandSet getCommandSet() {
        if (this.cmdSet == null) {
            CommandSetBuilder builder = new CommandSetBuilder();
            this.cmdSet = builder.buildCommandSet(this.builtIns);
        }
        return this.cmdSet;
    }

    private class HelpCommands {
        private HelpCommands() {
        }

        @Option(name="targets", description="Show command targets (t)")
        @Command(description="List available commands", level=0)
        public void help(Options opts) {
            HelpGenerator.this.out.printf("%s", DictionaryUtils.basicHelpForDictionary(HelpGenerator.this.dict, opts));
        }

        @Command(description="Show help for a single command", level=0)
        public void help(@Argument(name="command", allowedValueProvider="getHelpAllowedValues") String command) {
            boolean foundCommand = false;
            DictionaryHelpGenerator helpGenerator = HelpGenerator.this.dict.getHelpGenerator();
            for (DictionaryCommand def : HelpGenerator.this.dict) {
                if (!def.getCommandName().equals(command)) continue;
                foundCommand = true;
                String help = DictionaryUtils.basicHelpForCommand(def);
                int maxNameLeng = 0;
                int maxTypeLeng = 0;
                for (DictionaryArgument param : def.getArguments()) {
                    int leng = param.getName().length();
                    maxNameLeng = leng > maxNameLeng ? leng : maxNameLeng;
                    leng = param.getSimpleType().length();
                    maxTypeLeng = leng > maxTypeLeng ? leng : maxTypeLeng;
                }
                String spaces = String.format("%80s", "");
                for (DictionaryArgument param : def.getArguments()) {
                    if (param.getAllowedValues().size() == 1) continue;
                    String name = param.getName();
                    String type = param.getSimpleType();
                    help = help + "    " + name + spaces.substring(0, maxNameLeng - name.length()) + "   " + type + spaces.substring(0, maxTypeLeng - type.length()) + "   " + param.getDescription() + "\n";
                }
                if (helpGenerator != null && helpGenerator.hasHelp(def)) {
                    help = helpGenerator.modifyHelpForCommand(def, help, false);
                }
                HelpGenerator.this.out.printf("%s", help);
            }
            if (!foundCommand) {
                throw new IllegalArgumentException("No help found for " + command);
            }
        }

        public List<String> getHelpAllowedValues() {
            ArrayList<String> allowedValues = new ArrayList<String>();
            for (DictionaryCommand cmd : HelpGenerator.this.dict.filterByVisibilityIterator()) {
                String cmdName = cmd.getCommandName();
                if (allowedValues.contains(cmdName)) continue;
                allowedValues.add(cmdName);
            }
            return allowedValues;
        }
    }
}

