/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.data.MonitorTask;
import org.lsst.ccs.subsystem.refrig.ColdCompressor;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.CryoCompressor;
import org.lsst.ccs.subsystem.refrig.constants.ColdState;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.data.UpdatePeriod;

public class RefrigMain
extends Subsystem
implements HasLifecycle,
ClearAlertHandler,
AlertListener {
    private static final ColdState[] coldStates = new ColdState[]{ColdState.BOTH_OFF, ColdState.ONE_ON, ColdState.TWO_ON, ColdState.BOTH_ON};
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, ColdCompressor> coldCompMap = new LinkedHashMap<String, ColdCompressor>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, CryoCompressor> cryoCompMap = new LinkedHashMap<String, CryoCompressor>();
    private static final Logger LOG = Logger.getLogger(RefrigMain.class.getName());
    private final Compressor[] coldComps = new Compressor[2];
    private final Compressor[] cryoComps = new Compressor[6];
    private final RefrigState refrigState = new RefrigState();
    private MonitorTaskControl monitorControl;
    private Map<String, MonitorTask> monitorTaskMap;

    public RefrigMain() {
        super("refrig", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("compressor-state", () -> this.publishUpdatedRefrigState()).withPeriod(Duration.ofMillis(2000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        pt = new AgentPeriodicTask("update-time", () -> this.publishUpdateTime()).withPeriod(Duration.ofMillis(5000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        this.stateService.registerState(ColdState.class, "Overall cold compressor state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{ColdState.UNKNOWN});
    }

    public void postInit() {
        int j;
        ArrayList<String> keys;
        int nComp;
        this.propertiesService.setAgentProperty("compressorType", RefrigMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        this.monitorTaskMap = this.monitorControl.getMonitorTaskMap();
        this.refrigState.setNumMonTasks(this.monitorTaskMap.size());
        if (this.coldCompMap.isEmpty() && this.cryoCompMap.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"No compressors", (String)"defined");
        }
        if ((nComp = this.coldCompMap.size()) > 2) {
            LOG.log(Level.WARNING, "Too many ({0}) cold compressors specified: using only the first {1}", new Object[]{nComp, 2});
            keys = new ArrayList<String>(this.coldCompMap.keySet());
            for (j = 2; j < nComp; ++j) {
                this.coldCompMap.remove(keys.get(j));
            }
        }
        nComp = 0;
        keys = this.coldCompMap.values().iterator();
        while (keys.hasNext()) {
            Compressor comp;
            this.coldComps[nComp] = comp = (Compressor)keys.next();
            comp.setIndex(nComp++);
        }
        this.refrigState.setNumColdComps(nComp);
        nComp = this.cryoCompMap.size();
        if (nComp > 6) {
            LOG.log(Level.WARNING, "Too many ({0}) cryo compressors specified: using only the first {1}", new Object[]{nComp, 6});
            keys = new ArrayList<String>(this.cryoCompMap.keySet());
            for (j = 6; j < nComp; ++j) {
                this.cryoCompMap.remove(keys.get(j));
            }
        }
        nComp = 0;
        Iterator<CryoCompressor> iterator = this.cryoCompMap.values().iterator();
        while (iterator.hasNext()) {
            Compressor comp;
            this.cryoComps[nComp] = comp = (Compressor)iterator.next();
            comp.setIndex(nComp++);
        }
        this.refrigState.setNumCryoComps(nComp);
    }

    public void postStart() {
        LOG.log(Level.INFO, "Refrigeration subsystem started with {0} cold compressors and {1} cryo compressors", new Object[]{this.coldCompMap.size(), this.cryoCompMap.size()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, description="Get the refrigeration state", level=0)
    public RefrigState getSystemState() {
        RefrigState refrigState = this.refrigState;
        synchronized (refrigState) {
            this.refrigState.clearCompStates();
            this.refrigState.setTickMillis(this.monitorControl.getPublishPeriod());
            for (Compressor compressor : this.coldCompMap.values()) {
                this.refrigState.addColdState(compressor.getState());
            }
            for (Compressor compressor : this.cryoCompMap.values()) {
                this.refrigState.addCryoState(compressor.getState());
            }
            this.refrigState.clearMonitorTasks();
            for (MonitorTask monitorTask : this.monitorTaskMap.values()) {
                this.refrigState.addMonitorTask(monitorTask);
            }
            return this.refrigState;
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        String id = alert.getAlertId();
        for (String compName : this.coldCompMap.keySet()) {
            if (!id.startsWith(compName)) continue;
            return this.coldCompMap.get(compName).canClearAlert(alert);
        }
        for (String compName : this.cryoCompMap.keySet()) {
            if (!id.startsWith(compName)) continue;
            return this.cryoCompMap.get(compName).canClearAlert(alert);
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        block0: for (String id : event.getClearedIds()) {
            if (!id.endsWith("PLC")) continue;
            boolean reset = false;
            for (String compName : this.coldCompMap.keySet()) {
                if (!id.startsWith(compName)) continue;
                this.coldCompMap.get(compName).resetLatches();
                reset = true;
                break;
            }
            if (reset) continue;
            for (String compName : this.cryoCompMap.keySet()) {
                if (!id.startsWith(compName)) continue;
                this.cryoCompMap.get(compName).resetLatches();
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishUpdatedRefrigState() {
        RefrigState refrigState = this.refrigState;
        synchronized (refrigState) {
            boolean changed = this.monitorControl.hasPeriodChanged();
            this.refrigState.clearCompStates();
            int running = 0;
            for (Compressor compressor : this.coldCompMap.values()) {
                CompressorState compState;
                if (compressor.updateSystem()) {
                    changed = true;
                    this.refrigState.addColdState(compressor.getState());
                }
                if ((compState = compressor.getState().getCompressorState()) != CompressorState.RUNNING && compState != CompressorState.WAITING) continue;
                running |= 1 << compressor.getIndex();
            }
            this.stateService.updateAgentState(new Enum[]{coldStates[running]});
            for (Compressor compressor : this.cryoCompMap.values()) {
                if (!compressor.updateSystem()) continue;
                changed = true;
                this.refrigState.addCryoState(compressor.getState());
            }
            this.refrigState.clearMonitorTasks();
            for (MonitorTask monitorTask : this.monitorTaskMap.values()) {
                if (!monitorTask.hasChanged()) continue;
                this.refrigState.addMonitorTask(monitorTask);
                changed = true;
            }
            if (changed) {
                this.refrigState.setTickMillis(this.monitorControl.getPublishPeriod());
                this.publishSubsystemDataOnStatusBus(new KeyValueData("RefrigState", (Serializable)this.refrigState));
            }
        }
    }

    private void publishUpdateTime() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("UpdatePeriod", (Serializable)new UpdatePeriod(this.monitorControl.getPublishPeriod())));
    }
}

