/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;

public class BfrDevice
extends Device
implements SwitchControl {
    private static final Logger LOG = Logger.getLogger(BfrDevice.class.getName());
    private static final String NODE = "node";
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true)
    private volatile Integer node;
    private final Bfr bfr = new Bfr();
    private double[] currents = null;
    private boolean initError = false;

    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = "BFR board (" + this.node + ")";
    }

    public void initialize() {
        block2: {
            try {
                this.bfr.open(this.node.intValue());
                this.setOnline(true);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.bfr.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 11) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void readChannelGroup() {
        this.currents = null;
        if (this.online) {
            try {
                this.currents = this.bfr.readCurrent(Bfr.CurrentType.AC);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} currents: {1}", new Object[]{this.fullName, e});
                this.setOnline(false);
            }
        }
    }

    protected double readChannel(int hwChan, int type) {
        return this.currents == null ? Double.NaN : this.currents[hwChan];
    }

    @Override
    public int getSwitchDevice() {
        return 0;
    }

    @Override
    public void switchOn(int relay) {
        try {
            this.bfr.setRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
        }
    }

    @Override
    public void switchOff(int relay) {
        try {
            this.bfr.setRelayOff(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
        }
    }

    @Override
    public Boolean isSwitchOn(int relay) {
        if (!this.online || relay < 0) {
            return null;
        }
        try {
            return this.bfr.isRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting state for relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
            return null;
        }
    }
}

