/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class MCMCommandSender {
    private final ConcurrentMessagingUtils cmu;
    private final String target;
    private final AgentLockService lockService;
    private final AgentMessagingLayer agentMessagingLayer;

    MCMCommandSender(String target, AgentMessagingLayer agentMessagingLayer, AgentLockService lockService) {
        this.target = target;
        this.lockService = lockService;
        this.agentMessagingLayer = agentMessagingLayer;
        this.cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
    }

    void sendCommand(String command, Object ... args) throws ExecutionException {
        this.sendCommand(Void.TYPE, null, command, args);
    }

    <T> T sendCommand(Class<T> returnType, String command, Object ... args) throws ExecutionException {
        return this.sendCommand(returnType, null, command, args);
    }

    <T> T sendCommand(Class<T> returnType, Duration timeout, String command, Object ... args) throws ExecutionException {
        CommandRequest request = new CommandRequest(this.target, command, args);
        try {
            Object result = timeout == null ? this.cmu.sendSynchronousCommand(request) : this.cmu.sendSynchronousCommand(request, timeout);
            return returnType.cast(result);
        }
        catch (Exception ex) {
            throw new ExecutionException(String.format("Error sending command %s to %s", command, this.target), ex);
        }
    }

    void lock(int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        this.lockService.setLevelForAgent(this.target, level);
    }

    void unlock() {
    }
}

