/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

class ShutterSubsystemLayer
extends ControlledSubsystem
implements ShutterInterface {
    private static final Logger LOG = Logger.getLogger(ShutterSubsystemLayer.class.getName());
    private final State shutterState;

    ShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config, State shutterState) {
        super(mcm, config.getShutterSubsystemName(), ccs, config);
        this.shutterState = shutterState;
    }

    @Override
    public void expose(Duration exposeTime) throws ExecutionException {
        this.shutterState.setState(Shutter.ShutterState.OPEN);
        this.commandSender.sendCommand("takeExposure", (double)exposeTime.toMillis() / 1000.0);
        this.commandSender.sendCommand("waitForExposure", new Object[0]);
        this.shutterState.setState(Shutter.ShutterState.CLOSED);
    }

    @Override
    public void open() throws ExecutionException {
        this.commandSender.sendCommand("openShutter", new Object[0]);
    }

    @Override
    public void close() throws ExecutionException {
        this.commandSender.sendCommand("closeShutter", new Object[0]);
    }
}

